/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.utils.LoadImageFile;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;

public class FuguTagAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<GetAgentsResponse.Agents> agentDetails = new ArrayList();
    private FuguChatActivity fuguChatActivity;
    private String removableText;
    private Callback callback;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.tag_recycler_layout, parent, false);
        return new FuguTagging(v);
    }

    public FuguTagAdapter(FuguChatActivity fuguChatActivity, ArrayList<GetAgentsResponse.Agents> agentDetails, String removableText, Callback callback) {
        this.agentDetails = agentDetails;
        this.fuguChatActivity = fuguChatActivity;
        this.removableText = removableText;
        this.callback = callback;
        this.activity = fuguChatActivity;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        final FuguTagging holder1 = (FuguTagging)holder;
        holder1.tvTaggedPerson.setText((CharSequence)this.agentDetails.get(position).getFullName());
        try {
            LoadImageFile.getInstance().loadImage((Context)this.fuguChatActivity, this.agentDetails.get(position).getUserImage(), (ImageView)holder1.ivTagPerson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.agentDetails.get(position).getOnlineStatus().equals("AVAILABLE")) {
            holder1.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_available_without_border));
        } else if (this.agentDetails.get(position).getOnlineStatus().equals("AWAY")) {
            holder1.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_away_without_border));
        } else {
            holder1.viewStatus.setBackground(this.activity.getResources().getDrawable(R.drawable.ic_offline_without_border));
        }
        holder1.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                holder1.rlBackground.setBackgroundColor(-1);
                holder1.tvTaggedPerson.setTextColor(Color.parseColor((String)"#627de3"));
                holder1.viewSelectedBar.setVisibility(0);
                return false;
            }
        });
        holder1.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguTagAdapter.this.callback.onClick((GetAgentsResponse.Agents)FuguTagAdapter.this.agentDetails.get(position));
                holder1.rlBackground.setBackgroundColor(-1);
                holder1.tvTaggedPerson.setTextColor(Color.parseColor((String)"#627de3"));
                holder1.viewSelectedBar.setVisibility(0);
            }
        });
    }

    public int getItemCount() {
        return this.agentDetails.size();
    }

    public void setData(List<GetAgentsResponse.Agents> agentDetails) {
        this.agentDetails = (ArrayList)agentDetails;
        this.notifyDataSetChanged();
    }

    public static interface Callback {
        public void onClick(GetAgentsResponse.Agents var1);
    }

    class FuguTagging
    extends RecyclerView.ViewHolder {
        private TextView tvTaggedPerson;
        private CircleImageView ivTagPerson;
        private RelativeLayout rlBackground;
        private View viewSelectedBar;
        private View viewStatus;

        public FuguTagging(View itemView) {
            super(itemView);
            this.tvTaggedPerson = (TextView)itemView.findViewById(R.id.tvTaggedPerson);
            this.ivTagPerson = (CircleImageView)itemView.findViewById(R.id.ivTagPerson);
            this.rlBackground = (RelativeLayout)itemView.findViewById(R.id.rlBackground);
            this.viewSelectedBar = itemView.findViewById(R.id.viewSelectedBar);
            this.viewStatus = itemView.findViewById(R.id.viewStatus);
        }
    }
}

