/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.DescriptionObject;
import com.hippoagent.utils.FuguColorConfig;
import java.util.ArrayList;

public class CustomActionDescriptionAdapter
extends RecyclerView.Adapter<DescriptionViewHolder> {
    private LayoutInflater mLayoutInflater;
    private ArrayList<DescriptionObject> mDescriptionList = new ArrayList();
    private FuguColorConfig fuguColorConfig;

    public CustomActionDescriptionAdapter(Context context, ArrayList<DescriptionObject> description) {
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mDescriptionList = description;
        this.fuguColorConfig = CommonData.getColorConfig();
    }

    public DescriptionViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View main = this.mLayoutInflater.inflate(R.layout.hippo_list_item_description, parent, false);
        return new DescriptionViewHolder(main);
    }

    public void onBindViewHolder(DescriptionViewHolder holder, int position) {
        int pos = holder.getAdapterPosition();
        DescriptionObject descriptionObject = this.mDescriptionList.get(pos);
        holder.tvHeader.setText((CharSequence)descriptionObject.getHeader());
        holder.tvContent.setText((CharSequence)descriptionObject.getContent());
        holder.tvHeader.setTextColor(this.fuguColorConfig.getFuguPrimaryTextMsgFrom());
        holder.tvContent.setTextColor(this.fuguColorConfig.getFuguPrimaryTextMsgFrom());
    }

    public int getItemCount() {
        return this.mDescriptionList.size();
    }

    class DescriptionViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvHeader;
        TextView tvContent;

        public DescriptionViewHolder(View itemView) {
            super(itemView);
            this.tvHeader = (TextView)itemView.findViewById(R.id.tvHeader);
            this.tvContent = (TextView)itemView.findViewById(R.id.tvContent);
        }
    }
}

