/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.os.Handler;
import android.text.Html;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.adapters.ItemClickListener;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.ColorPicker.ColorGenerator;
import com.hippoagent.utils.ColorPicker.TextDrawable;
import com.hippoagent.utils.DateUtils;
import java.util.ArrayList;

public class ConversationChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ItemClickListener {
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    public static final int VIDEO_CALL = 18;
    public static final int FILE_ITEM = 11;
    private ArrayList<Object> conversationList;
    private Activity activity;
    private Callback callback;
    private RecyclerView recyclerView;
    float d;
    private Handler handler = new Handler();
    Typeface boldFont;
    Typeface normalFont;
    Typeface semiBoldFont;
    private RequestOptions options;

    public ConversationChatAdapter(ArrayList<Object> conversationList, Activity activity, Callback callback, RecyclerView recyclerView) {
        this.conversationList = conversationList;
        this.activity = activity;
        this.callback = callback;
        this.recyclerView = recyclerView;
        this.d = activity.getResources().getDisplayMetrics().density;
        this.boldFont = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/TitilliumWeb-SemiBold.ttf");
        this.normalFont = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/TitilliumWeb-Regular.ttf");
        this.semiBoldFont = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/TitilliumWeb-SemiBold.ttf");
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_header, parent, false);
            return new ViewHolderHeader(v);
        }
        if (viewType == 3) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        }
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_conversation, parent, false);
        return new ViewHolder(v, this);
    }

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color2 = generator.getColor(name.trim());
        Resources r = this.activity.getResources();
        float px = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)r.getDisplayMetrics());
        name = name.trim();
        char text = ' ';
        text = name.trim().charAt(0);
        TextDrawable drawable2 = TextDrawable.builder().buildRoundRect((text + "").toUpperCase(), color2, Math.round(px));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).fitCenter()).priority(Priority.HIGH)).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)drawable2);
        this.options.error((Drawable)drawable2);
        return this.options;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            String[] nameArray;
            ViewHolder holder = (ViewHolder)viewholder;
            Conversation conversation = (Conversation)this.conversationList.get(position);
            if (conversation.getMessage_type() == 18) {
                holder.tvMessage.setText((CharSequence)this.getMessageData(conversation));
            } else if (conversation.getMessage_type() == 11) {
                holder.tvMessage.setText((CharSequence)this.getFileMessageData(conversation));
            } else if (!TextUtils.isEmpty((CharSequence)conversation.getMessage())) {
                if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
                    holder.tvMessage.setText((CharSequence)("You: " + Html.fromHtml((String)conversation.getMessage())));
                } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        try {
                            nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                            holder.tvMessage.setText((CharSequence)(nameArray[0] + ": " + Html.fromHtml((String)conversation.getMessage())));
                        }
                        catch (Exception e) {
                            holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                        }
                    } else {
                        holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                    }
                } else if (!TextUtils.isEmpty((CharSequence)conversation.getLast_sent_by_full_name())) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        try {
                            nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                            holder.tvMessage.setText((CharSequence)(nameArray[0] + ": " + Html.fromHtml((String)conversation.getMessage())));
                        }
                        catch (Exception e) {
                            holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                        }
                    } else {
                        holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                    }
                } else {
                    holder.tvMessage.setText((CharSequence)Html.fromHtml((String)conversation.getMessage()));
                }
            } else if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
                if (conversation.getMessage_type() == 19) {
                    holder.tvMessage.setText((CharSequence)"You sent a payment");
                } else {
                    holder.tvMessage.setText((CharSequence)"You sent a photo");
                }
            } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
                if (conversation.getLast_sent_by_full_name().contains(" ")) {
                    try {
                        nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                        holder.tvMessage.setText((CharSequence)(nameArray[0] + " sent a photo"));
                    }
                    catch (Exception e) {
                        holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + " sent a photo"));
                    }
                } else {
                    holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + " sent a Photo"));
                }
            } else if (conversation.getMessage_type() == 19) {
                holder.tvMessage.setText((CharSequence)"You received a payment");
            } else {
                holder.tvMessage.setText((CharSequence)"You received a photo");
            }
            holder.tvName.setText((CharSequence)conversation.getLabel());
            String name = conversation.getLabel().trim().substring(0, 1).toUpperCase();
            Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(name)).load(conversation.getUserImage()).into(holder.ivChannelIcon);
            if (conversation.getStatus().intValue() == MessageMode.CLOSED_CHAT.getOrdinal()) {
                holder.tvClosed.setVisibility(0);
                float width = this.activity.getResources().getDimension(R.dimen.fugu_name_width);
                holder.tvName.setMaxWidth((int)width);
                holder.tvName.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.read_chat_text_color));
                holder.tvMessage.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.read_chat_text_color));
                holder.tvTime.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.read_chat_text_color));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(3.0f * this.d), (int)(50.0f * this.d), 0);
                holder.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.bg_tag_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.read_chat_text_color));
            } else {
                holder.tvClosed.setVisibility(8);
                holder.tvClosed.setFilters(new InputFilter[]{new InputFilter.LengthFilter(R.dimen.fugu_name_width_unClose)});
                float width = this.activity.getResources().getDimension(R.dimen.fugu_name_width_unClose);
                holder.tvName.setMaxWidth((int)width);
                holder.tvName.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.text_color));
                holder.tvName.setTypeface(this.boldFont);
                holder.tvMessage.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.text_color));
                holder.tvTime.setTextColor(Color.parseColor((String)"#b3bec9"));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(-2.0f * this.d), (int)(50.0f * this.d), 0);
                holder.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.bg_unassigned_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.white));
            }
            if (!conversation.getUnreadCount().equals(0)) {
                holder.tvUnread.setVisibility(0);
                holder.tvUnread.setText((CharSequence)String.valueOf(conversation.getUnreadCount()));
                holder.tvMessage.setTypeface(this.normalFont);
                holder.tvMessage.setTextColor(-16777216);
                holder.tvTime.setTypeface(this.boldFont);
            } else {
                holder.tvUnread.setVisibility(8);
                holder.tvMessage.setTypeface(this.boldFont);
                holder.tvMessage.setTextColor(Color.parseColor((String)"#b3bec9"));
                holder.tvTime.setTypeface(this.normalFont);
            }
            if (conversation.isBotEnabled()) {
                holder.tvBotInProgress.setVisibility(0);
            } else {
                holder.tvBotInProgress.setVisibility(8);
            }
            if (conversation.getAgentId() <= 0) {
                holder.tvUnassigned.setVisibility(0);
            } else {
                holder.tvUnassigned.setVisibility(8);
            }
            if (conversation.getOverlay() != null && conversation.getOverlay().intValue() != Overlay.DEFAULT.getOrdinal()) {
                holder.tvOverlay.setVisibility(0);
                if (conversation.getOverlay().intValue() == Overlay.OPEN_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_re_opened, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.activity, (int)R.color.overlay_green_95));
                    holder.tvOverlay.setText((CharSequence)this.activity.getResources().getString(R.string.conversation_re_opend));
                } else if (conversation.getOverlay().intValue() == Overlay.CLOSED_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_close, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.activity, (int)R.color.overlay_black_95));
                    holder.tvOverlay.setText((CharSequence)this.activity.getResources().getString(R.string.conversation_closed));
                } else if (conversation.getOverlay().intValue() == Overlay.ASSIGNMENT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_assigned, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.activity, (int)R.color.overlay_yellow_95));
                    holder.tvOverlay.setText((CharSequence)this.activity.getResources().getString(R.string.conversation_assigned));
                }
            } else {
                holder.tvOverlay.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getLastUpdatedAt())) {
                TextView textView = holder.tvTime;
                DateUtils.getInstance();
                textView.setText((CharSequence)DateUtils.getDateTimeToShow(conversation.getLastUpdatedAt()));
            }
            if (holder.timer != null) {
                holder.timer.cancel();
            }
        } else if (viewholder instanceof ViewHolderHeader) {
            ViewHolderHeader holder = (ViewHolderHeader)viewholder;
            holder.tvHeader.setText((CharSequence)("2 " + this.activity.getResources().getString(R.string.open_conversations)));
        }
    }

    public int getItemCount() {
        if (this.conversationList == null || this.conversationList.size() == 0) {
            return 0;
        }
        return this.conversationList.size();
    }

    public int getItemViewType(int position) {
        if (this.conversationList.get(position) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    @Override
    public void onItemClick(View viewClicked, View parentView) {
        int pos = this.recyclerView.getChildLayoutPosition(parentView);
        if (pos != -1 && viewClicked.getId() == R.id.rlChat) {
            try {
                parentView.findViewById(R.id.tvUnread).setVisibility(8);
                Conversation conversation = (Conversation)this.conversationList.get(pos);
                conversation.setUnreadCount(0);
                this.callback.onClick(pos, conversation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getFileMessageData(Conversation conversation) {
        String message = "You sent a file";
        if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
            message = "You sent a file";
        } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(MyApplication.getInstance().getUserData().getUserId())) {
            if (conversation.getLast_sent_by_full_name().contains(" ")) {
                String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                message = nameArray[0] + " sent a file";
            } else {
                message = conversation.getLast_sent_by_full_name() + " sent a file";
            }
        } else {
            message = "You received a file";
        }
        return message;
    }

    private String getMessageData(Conversation currentChannelItem) {
        String message = "The video call ended";
        String customerName = "Customer";
        String callType = "video";
        String agentName = "You";
        if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            callType = "voice";
        }
        if (currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState() == 2) {
            if (currentChannelItem.getLast_sent_by_user_type() == 1) {
                customerName = currentChannelItem.getLast_sent_by_full_name();
                if (!this.isChatAssignToMe(currentChannelItem)) {
                    agentName = currentChannelItem.getAgentName();
                }
                message = agentName + " missed a " + callType + " call with " + customerName;
            } else {
                agentName = currentChannelItem.getLast_sent_by_id().intValue() == MyApplication.getInstance().getUserData().getUserId().intValue() ? "you" : currentChannelItem.getLast_sent_by_full_name();
                message = customerName + " missed a " + callType + " call with " + agentName;
            }
        } else {
            message = "The " + callType + " call ended";
        }
        return message;
    }

    private boolean isChatAssignToMe(Conversation currentChannelItem) {
        return currentChannelItem.getAgentId().intValue() == MyApplication.getInstance().getUserData().getUserId().intValue();
    }

    public static interface Callback {
        public void onClick(int var1, Conversation var2);
    }

    public static class ProgressBarItem {
    }

    private static class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View itemView) {
            super(itemView);
        }
    }

    public class ViewHolderHeader
    extends RecyclerView.ViewHolder {
        public TextView tvHeader;

        public ViewHolderHeader(View itemView) {
            super(itemView);
            this.tvHeader = (TextView)itemView.findViewById(R.id.tvHeader);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public RelativeLayout rlChat;
        public TextView tvMessage;
        public TextView tvName;
        public TextView tvTime;
        public TextView tvUnread;
        public TextView tvClosed;
        public TextView tvOverlay;
        public TextView tvUnassigned;
        public TextView tvBotInProgress;
        public CountDownTimer timer;
        private ImageView ivChannelIcon;

        public ViewHolder(final View itemView, final ItemClickListener itemClickListener) {
            super(itemView);
            this.rlChat = (RelativeLayout)itemView.findViewById(R.id.rlChat);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.tvUnread = (TextView)itemView.findViewById(R.id.tvUnread);
            this.tvClosed = (TextView)itemView.findViewById(R.id.tvClosed);
            this.tvUnassigned = (TextView)itemView.findViewById(R.id.tvUnassigned);
            this.tvBotInProgress = (TextView)itemView.findViewById(R.id.tvBotInProgress);
            this.tvOverlay = (TextView)itemView.findViewById(R.id.tvOverlay);
            this.ivChannelIcon = (ImageView)itemView.findViewById(R.id.ivChannelIcon);
            this.rlChat.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)ViewHolder.this.rlChat, itemView);
                }
            });
            this.tvOverlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
    }
}

