/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.adapters.OnRecyclerListener;
import com.hippoagent.adapters.UserConcentListener;
import com.hippoagent.model.ContentValue;
import com.hippoagent.model.Message;
import com.hippoagent.utils.Constants;
import java.util.ArrayList;

public class ButtonsAdapter
extends RecyclerView.Adapter<ViewHolder>
implements OnRecyclerListener {
    private static final String TAG = ButtonsAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<ContentValue> arrayList;
    private String selectedBtnId;
    private UserConcentListener userConcentListener;
    private Message message;
    private RecyclerView recyclerView;
    private int isActive = 1;
    private String alpha = "#66";

    public ButtonsAdapter(Context context, Message message, ArrayList<ContentValue> arrayList, UserConcentListener userConcentListener, RecyclerView recyclerView, int isActive, String selectedBtnId) {
        this.context = context;
        this.arrayList = arrayList;
        this.userConcentListener = userConcentListener;
        this.recyclerView = recyclerView;
        this.isActive = isActive;
        this.isActive = 0;
        this.selectedBtnId = selectedBtnId;
        this.message = message;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_action_button, viewGroup, false), this);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int pos) {
        viewHolder.button.setText((CharSequence)this.arrayList.get(pos).getBtnTitle());
        viewHolder.button.setEnabled(this.isActive != 0);
        viewHolder.button.setClickable(this.isActive != 0);
        this.selectedBtnId = this.message.getSelectedBtnId();
        String textColor = this.arrayList.get(pos).getBtnTitleColor().replace("#", "");
        String btnColor = this.arrayList.get(pos).getBtnColor().replace("#", "");
        String btnStrokeColor = this.arrayList.get(pos).getBtnTitleColor().replace("#", "");
        textColor = this.alpha + textColor;
        btnColor = this.alpha + btnColor;
        btnStrokeColor = this.alpha + btnStrokeColor;
        if (!TextUtils.isEmpty((CharSequence)this.selectedBtnId) && this.selectedBtnId.equalsIgnoreCase(this.arrayList.get(pos).getBtnId())) {
            textColor = this.arrayList.get(pos).getBtnTitleSelectedColor().replace("#", "");
            btnColor = this.arrayList.get(pos).getBtnSelectedColor().replace("#", "");
            btnStrokeColor = this.arrayList.get(pos).getBtnSelectedColor().replace("#", "");
            textColor = this.alpha + textColor;
            btnColor = this.alpha + btnColor;
            btnStrokeColor = this.alpha + btnStrokeColor;
        }
        viewHolder.button.setTextColor(Color.parseColor((String)textColor));
        int radius = (int)Constants.convertDpToPixel(1.0f);
        GradientDrawable drawable2 = (GradientDrawable)viewHolder.button.getBackground();
        drawable2.setStroke(radius, Color.parseColor((String)btnStrokeColor));
        drawable2.setColor(Color.parseColor((String)btnColor));
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
    }

    @Override
    public void onItemLongClick(View viewClicked, View parentView, int position, boolean isRight) {
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        AppCompatButton button;

        public ViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.button = (AppCompatButton)itemView.findViewById(R.id.button);
            this.button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)ViewHolder.this.button, itemView, ViewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

