/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.LoginResponse.Tag;
import com.hippoagent.model.graph.AgentsDatum;
import java.util.ArrayList;

public class AgentAnalyticsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<AgentsDatum> agentsList;

    public AgentAnalyticsAdapter(Activity activity, ArrayList<AgentsDatum> agentsList) {
        this.activity = activity;
        this.agentsList = agentsList;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_agent_data, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewHolder;
            AgentsDatum agentResponse = this.agentsList.get(position);
            if (position % 2 == 0) {
                holder.root.setBackgroundColor(ContextCompat.getColor((Context)this.activity, (int)R.color.agent_analytics_bg));
            } else {
                holder.root.setBackgroundColor(ContextCompat.getColor((Context)this.activity, (int)R.color.white));
            }
            holder.tvAgentName.setText((CharSequence)agentResponse.getAgentName());
            holder.tvAssigned.setText((CharSequence)(agentResponse.getCurrentlyAssigned() + ""));
            holder.tvReplied.setText((CharSequence)(agentResponse.getCurrentlyReplied() + ""));
            holder.tvClosed.setText((CharSequence)(agentResponse.getCurrentlyClosed() + ""));
            Double temp1 = agentResponse.getAvgFirstResponse();
            holder.tvAvgFirstReponseTime.setText((CharSequence)(this.getTimeInMinutes(temp1.intValue()) + ""));
        }
    }

    public int getItemCount() {
        return this.agentsList == null ? 0 : this.agentsList.size();
    }

    private String getTimeInMinutes(int seconds) {
        String timeString = "";
        if (seconds > 59) {
            int remainingSeconds;
            int minutes = seconds / 60;
            if (minutes > 0) {
                timeString = minutes + "m ";
            }
            if ((remainingSeconds = seconds % 60) > 0) {
                timeString = timeString + remainingSeconds + "s";
            }
        } else {
            timeString = seconds + "s";
        }
        return timeString;
    }

    public static interface Callback {
        public void onClick(int var1, Tag var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public LinearLayout root;
        public TextView tvAgentName;
        public TextView tvAssigned;
        public TextView tvReplied;
        public TextView tvClosed;
        public TextView tvAvgFirstReponseTime;
        public TextView tvAvgCloseTime;

        public ViewHolder(View itemView) {
            super(itemView);
            this.root = (LinearLayout)itemView.findViewById(R.id.root);
            this.tvAgentName = (TextView)itemView.findViewById(R.id.tvAgentName);
            this.tvAssigned = (TextView)itemView.findViewById(R.id.tvAssigned);
            this.tvReplied = (TextView)itemView.findViewById(R.id.tvReplied);
            this.tvClosed = (TextView)itemView.findViewById(R.id.tvClosed);
            this.tvAvgFirstReponseTime = (TextView)itemView.findViewById(R.id.tvAvgFirstReponseTime);
            this.tvAvgCloseTime = (TextView)itemView.findViewById(R.id.tvAvgCloseTime);
        }
    }
}

