/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.Colors;
import java.util.ArrayList;

public class AddTagsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Colors> colors;
    private AddTagsClick addTagsClick;

    public AddTagsAdapter(ArrayList<Colors> colors, AddTagsClick addTagsClick) {
        this.colors = colors;
        this.addTagsClick = addTagsClick;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_tags_colors, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, final int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewholder;
            holder.vwColor.setTag((Object)position);
            if (this.colors.get(position).isColorSelected() == 1) {
                holder.vwSelected.setVisibility(0);
            } else {
                holder.vwSelected.setVisibility(8);
            }
            GradientDrawable gd = new GradientDrawable();
            gd.setShape(0);
            gd.setColor(Color.parseColor((String)this.colors.get(position).getColor()));
            gd.setStroke(2, Color.parseColor((String)this.colors.get(position).getColor()));
            gd.setCornerRadius(15.0f);
            holder.vwColor.setBackground((Drawable)gd);
            holder.vwColor.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    for (int i = 0; i < AddTagsAdapter.this.colors.size(); ++i) {
                        if (((Colors)AddTagsAdapter.this.colors.get(i)).getColor().equalsIgnoreCase(((Colors)AddTagsAdapter.this.colors.get(position)).getColor())) {
                            ((Colors)AddTagsAdapter.this.colors.get(i)).setColorSelected(1);
                            AddTagsAdapter.this.addTagsClick.onClickListener(((Colors)AddTagsAdapter.this.colors.get(i)).getColor());
                            continue;
                        }
                        ((Colors)AddTagsAdapter.this.colors.get(i)).setColorSelected(0);
                    }
                    AddTagsAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    public int getItemCount() {
        if (this.colors == null || this.colors.size() == 0) {
            return 0;
        }
        return this.colors.size();
    }

    public static interface AddTagsClick {
        public void onClickListener(String var1);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public View vwColor;
        public View vwSelected;
        public int selectedPosition;

        public ViewHolder(View itemView) {
            super(itemView);
            this.vwColor = itemView.findViewById(R.id.vwColor);
            this.vwSelected = itemView.findViewById(R.id.vwSelected);
        }
    }
}

