/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import com.easyfilepicker.easypermissions.AfterPermissionGranted;
import com.easyfilepicker.easypermissions.AppSettingsDialog;
import com.easyfilepicker.easypermissions.EasyPermissions;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.filePicker.FileManager;
import java.util.List;

public class VideoPlayerActivity
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private static final String TAG = VideoPlayerActivity.class.getSimpleName();
    private VideoView videoView;
    private ImageView ivBack;
    private TextView title;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_player);
        this.videoView = (VideoView)this.findViewById(R.id.videoView);
        this.readExternalStorage();
        this.title = (TextView)this.findViewById(R.id.title);
        String name = TextUtils.isEmpty((CharSequence)this.getIntent().getStringExtra("title")) ? "Video" : this.getIntent().getStringExtra("title");
        this.title.setText((CharSequence)name);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlayerActivity.this.onBackPressed();
            }
        });
    }

    private void permissionGranted() {
        MediaController mediaController = new MediaController((Context)this);
        mediaController.setAnchorView((View)this.videoView);
        mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this.videoView);
        mediaController.setEnabled(true);
        this.videoView.setMediaController(mediaController);
        this.videoView.setVideoURI(Uri.parse((String)this.getIntent().getStringExtra("url")));
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.start();
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                VideoPlayerActivity.this.showErrorMessage("File type not supported! Do you want to open with other apps?", "OK", VideoPlayerActivity.this.getIntent().getStringExtra("url"));
                return true;
            }
        });
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final String localPath) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)VideoPlayerActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        VideoPlayerActivity.this.openFile(localPath);
                        dialog.dismiss();
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        VideoPlayerActivity.this.finish();
                    }
                }).setCancelable(false).show();
            }
        });
    }

    private void openFile(String localPath) {
        if (!TextUtils.isEmpty((CharSequence)localPath)) {
            FileManager.getInstance().openFileInDevice((Context)this, localPath, new FileManager.FileCopyListener(){

                @Override
                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                }

                @Override
                public void largeFileSize() {
                }

                @Override
                public void onError() {
                    Toast.makeText((Context)VideoPlayerActivity.this, (CharSequence)VideoPlayerActivity.this.getString(R.string.no_handler), (int)1).show();
                    VideoPlayerActivity.this.finish();
                }
            });
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EasyPermissions.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults, (Object[])new Object[]{this});
    }

    @AfterPermissionGranted(value=123)
    private void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions((Context)this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        if (isGranted) {
            this.permissionGranted();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)this.getString(R.string.vw_rationale_storage), (int)123, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        }
    }

    public void onPermissionsGranted(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + requestCode + ":" + perms.size()));
        this.permissionGranted();
    }

    public void onPermissionsDenied(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + requestCode + ":" + perms.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, perms)) {
            new AppSettingsDialog.Builder((Activity)this).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 16061) {
            if (EasyPermissions.hasPermissions((Context)this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"})) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }
}

