/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.fragments.ChangePasswordFragment;
import com.hippoagent.fragments.EditProfileFragment;
import com.hippoagent.fragments.ViewProfileFragment;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.filelogger.Logger;
import io.paperdb.Paper;
import java.util.HashMap;
import retrofit2.Callback;

public class ProfileActivity
extends FuguBaseActivity
implements View.OnClickListener {
    private LinearLayout llContainer;
    private LinearLayout llTitle;
    private Toolbar toolbar;
    private TextView toolbarTitle;
    private TextView tvLogout;
    private boolean isOpenAnotherFrag = false;
    private boolean isChangePass = false;
    private ImageChooser imageChooser;
    private int userOnBoardingValue = 0;
    private boolean onboardClassFinish = true;
    private boolean doubleBackToExitPressedOnce = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_profile);
        if (this.getIntent().hasExtra("user_onboard_value")) {
            this.userOnBoardingValue = this.getIntent().getIntExtra("user_onboard_value", 0);
            this.onboardClassFinish = this.getIntent().getBooleanExtra("onboard_class_finish", true);
        } else if (savedInstanceState != null) {
            this.userOnBoardingValue = savedInstanceState.getInt("user_onboard_value", 0);
            this.onboardClassFinish = savedInstanceState.getBoolean("onboard_class_finish", true);
        }
        this.initView();
        this.openScreens(this.userOnBoardingValue);
    }

    private void openScreens(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case ONLY_NAME: {
                this.openEditScreenFragment();
                break;
            }
            case ONLY_PASSWORD: {
                this.openPasswordFragment();
                break;
            }
            case BOTH_NAME_PASSWORD: {
                this.openEditScreenFragment();
                break;
            }
            default: {
                this.getAgentData();
            }
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putInt("user_onboard_value", this.userOnBoardingValue);
        outState.putBoolean("onboard_class_finish", this.onboardClassFinish);
        super.onSaveInstanceState(outState);
    }

    private void initView() {
        this.toolbarTitle = (TextView)this.findViewById(R.id.tv_toolbar_name);
        this.tvLogout = (TextView)this.findViewById(R.id.tvLogout);
        this.tvLogout.setOnClickListener((View.OnClickListener)this);
        this.llTitle = (LinearLayout)this.findViewById(R.id.llTitle);
        this.imageChooser = new ImageChooser((Activity)this);
        this.llContainer = (LinearLayout)this.findViewById(R.id.llContainer);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        try {
            this.getSupportActionBar().setDisplayShowTitleEnabled(false);
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(this.userOnBoardingValue == 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setToolbarTitle(this.getResources().getString(R.string.your_profile), false);
    }

    public void setToolbarTitle(String title, boolean isClicked) {
        this.toolbarTitle.setText((CharSequence)title);
        if (isClicked) {
            this.tvLogout.setVisibility(8);
        } else {
            this.tvLogout.setVisibility(0);
        }
    }

    public void setClickBool(boolean isClicked, boolean isChange) {
        this.isOpenAnotherFrag = isClicked;
        this.isChangePass = isChange;
    }

    private void backButton() {
        if (this.doubleBackToExitPressedOnce) {
            this.apiLogout();
            return;
        }
        this.doubleBackToExitPressedOnce = true;
        Toast.makeText((Context)this, (CharSequence)"Press again to exit", (int)0).show();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ProfileActivity.this.doubleBackToExitPressedOnce = false;
            }
        }, 2000L);
    }

    private void userOnBoardingBack(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case BOTH_NAME_PASSWORD: {
                break;
            }
        }
    }

    public void onBackPressed() {
        if (this.userOnBoardingValue == 0) {
            if (this.isOpenAnotherFrag) {
                this.isOpenAnotherFrag = false;
                this.getSupportFragmentManager().beginTransaction().setCustomAnimations(R.anim.anim_slide_in_right, R.anim.anim_slide_out_right, R.anim.anim_slide_in_left, R.anim.anim_slide_out_left).replace(this.llContainer.getId(), (Fragment)ViewProfileFragment.newInstance(), ViewProfileFragment.class.getName()).commit();
                this.setToolbarTitle(this.getResources().getString(R.string.your_profile), false);
                if (this.isChangePass) {
                    // empty if block
                }
            } else {
                super.onBackPressed();
            }
        }
    }

    public void updateMenu() {
        this.invalidateOptionsMenu();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        } else if (item.getItemId() == R.id.btnSkip) {
            this.onBackPressed();
        }
        return true;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.imageChooser.onActivityResult(requestCode, resultCode, data);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tvLogout) {
            this.performLogout();
        }
    }

    private void apiLogout() {
        if (this.isNetworkAvailable()) {
            Paper.book((String)CommonData.name).delete("latest_version");
            CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this)).add("device_type", "1").build();
            Logger.INSTANCE.apiRequest("/api/agent/agentLogout", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().logout(commonParams.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(LoginResponse loginResponse) {
                    Logger.INSTANCE.apiResponse("/api/agent/agentLogout", "");
                    try {
                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode().intValue()) {
                            MyApplication.getInstance().logout((Activity)ProfileActivity.this);
                        }
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.apiFailed("/api/agent/agentLogout", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/agent/agentLogout", error.getMessage());
                    Log.e("error", "error");
                }
            });
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    public void getAgentData() {
        this.getAgentData(false);
    }

    public void getAgentData(final boolean flag) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("en_user_id", String.valueOf(MyApplication.getInstance().getUserData().getEnUserId()));
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentProfileDetails>((Activity)this, Boolean.valueOf(!flag), Boolean.valueOf(true)){

            @Override
            public void success(AgentProfileDetails agentProfileDetails) {
                Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                try {
                    Paper.book((String)CommonData.name).delete("agent_data");
                    Paper.book((String)CommonData.name).write("agent_data", (Object)agentProfileDetails);
                    if (flag) {
                        MyApplication.getInstance().getAgentProfileDetails().getData().setUserImage(agentProfileDetails.getData().getUserImage());
                        MyApplication.getInstance().getUserData().setUserImage(agentProfileDetails.getData().getUserImage());
                    } else {
                        ProfileActivity.this.getSupportFragmentManager().beginTransaction().replace(ProfileActivity.this.llContainer.getId(), (Fragment)ViewProfileFragment.newInstance(), ViewProfileFragment.class.getName()).commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
            }
        });
    }

    private void performLogout() {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton((Context)this, "", this.getResources().getString(R.string.logout_message), this.getResources().getString(R.string.logout_caps), this.getResources().getString(R.string.cancel), new DialogPop.Callback(){

            @Override
            public void onPositiveClick() {
                ProfileActivity.this.apiLogout();
            }

            @Override
            public void onNegativeClick() {
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.hardKeyboardHidden != 1 && newConfig.hardKeyboardHidden == 2) {
            this.getWindow().getDecorView().clearFocus();
        }
    }

    public void hideKeyboardFrom(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm.isAcceptingText()) {
            imm.toggleSoftInput(1, 0);
        }
    }

    public void afterAgentOnBoard() {
        MyApplication.getInstance().getUserData().setAgentOnboardingComplete(0);
        MyApplication.getInstance().saveUserData(MyApplication.getInstance().getUserData());
        if (this.onboardClassFinish) {
            super.onBackPressed();
        } else {
            this.finish();
            this.startActivity(new Intent((Context)this, HomeActivity.class));
        }
    }

    private void openEditScreenFragment() {
        EditProfileFragment editProfileFragment = new EditProfileFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("user_onboard_value", this.userOnBoardingValue);
        editProfileFragment.setArguments(bundle);
        this.setClickBool(true, false);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.llContainer, (Fragment)editProfileFragment, EditProfileFragment.class.getName()).commit();
    }

    private ChangePasswordFragment getChangePasswordFragment() {
        return (ChangePasswordFragment)this.getSupportFragmentManager().findFragmentByTag(ChangePasswordFragment.class.getName());
    }

    public void openPasswordFragment() {
        this.setClickBool(true, true);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.llContainer, (Fragment)ChangePasswordFragment.newInstance(this.userOnBoardingValue), ChangePasswordFragment.class.getName()).commit();
    }
}

