/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.UploadingService;
import io.paperdb.Paper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import uk.co.chrisjenx.calligraphy.CalligraphyContextWrapper;

public class FuguBaseActivity
extends AppCompatActivity
implements FuguAppConstant {
    private Toolbar toolbar;
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    DialogPop dialogPop;

    protected void checkAutoUpload() {
        if (!this.isMyServiceRunning(UploadingService.class)) {
            ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (fileuploadModels == null) {
                return;
            }
            if (fileuploadModels.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), UploadingService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    protected void onResume() {
        super.onResume();
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        this.setSupportActionBar(toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setTitle((CharSequence)"");
        }
        ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
        return this.getSupportActionBar();
    }

    public void updateToolbar(Toolbar toolbar, String title) {
        ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
    }

    public void setToolBar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)CalligraphyContextWrapper.wrap((Context)newBase));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public int getAppVersion() {
        try {
            return this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            return "v" + this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void showErrorMessage(String errorMessage, String positiveButtonText) {
        this.showErrorMessage(errorMessage, positiveButtonText, false);
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)FuguBaseActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (isFinish) {
                            FuguBaseActivity.this.finish();
                        }
                    }
                }).setCancelable(false).show();
            }
        });
    }

    private boolean isEnabled() {
        VersionUpdate update = CommonData.getVersionInfo();
        if (update == null) {
            return false;
        }
        if (HippoConfig.getInstance().getAttributes().getVersionCode() >= update.getVersion()) {
            return false;
        }
        if (HippoConfig.getInstance().getAttributes().getVersionCode() < update.getVersion() && update.getLastVersion() != update.getVersion()) {
            return true;
        }
        if (update.getLastVersion() == update.getVersion() && update.getInterval() > 0L) {
            return System.currentTimeMillis() - update.getLastShown() > update.getInterval() * 60L * 1000L;
        }
        return false;
    }

    public void showUpdatePopup(Context context) {
        if (!this.isEnabled()) {
            return;
        }
        VersionUpdate update = CommonData.getVersionInfo();
        if (update == null) {
            return;
        }
        update.setLastVersion(update.getVersion());
        update.setLastShown(System.currentTimeMillis());
        CommonData.saveVersionInfo(update);
        String message = update.getText();
        final String link = update.getLink();
        if (this.dialogPop == null) {
            this.dialogPop = new DialogPop();
        }
        this.dialogPop.alertPopupWithTwoButton(context, "", message, this.getResources().getString(R.string.ok), this.getResources().getString(R.string.cancel), new DialogPop.Callback(){

            @Override
            public void onPositiveClick() {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                FuguBaseActivity.this.startActivity(browserIntent);
            }

            @Override
            public void onNegativeClick() {
            }
        });
    }

    protected void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ShowUpdateWindowTwoBtns(LoginResponse loginResponse) {
        Paper.book((String)CommonData.name).delete("user_data");
        Paper.book((String)CommonData.name).write("user_data", (Object)loginResponse.getUserData());
        Paper.book((String)CommonData.name).write("tags", loginResponse.getUserData().getTags());
        Paper.book((String)CommonData.name).delete("latest_version");
        Paper.book((String)CommonData.name).write("latest_version", (Object)loginResponse.getUserData().getVersion().getLatestVersion());
        this.startActivity(new Intent((Context)this, HomeActivity.class).putExtra("show_update", true).putExtra("update_link", loginResponse.getUserData().getVersion().getDownloadLink()).putExtra("update_title", loginResponse.getUserData().getVersion().getText()));
    }

    public void SingleBtnUpdateWindow(final LoginResponse loginResponse) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setMessage((CharSequence)loginResponse.getUserData().getVersion().getText());
        alertDialog.setButton(-3, (CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)loginResponse.getUserData().getVersion().getDownloadLink()));
                FuguBaseActivity.this.startActivity(browserIntent);
                FuguBaseActivity.this.finish();
            }
        });
        alertDialog.show();
    }
}

