/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.multidex.MultiDexApplication;
import com.hippoagent.Config;
import com.hippoagent.HippoActivityLifecycleCallback;
import com.hippoagent.R;
import com.hippoagent.callback.BaseManagerInterface;
import com.hippoagent.callback.BaseUIListener;
import com.hippoagent.callback.OnCloseListener;
import com.hippoagent.callback.OnInitializedListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.DeleteDatabase;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.TagData;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.receiver.NetworkManager;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.filelogger.LoggerObj;
import com.hippoagent.utils.typekit.Typekit;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;

public class MyApplication
extends MultiDexApplication
implements Application.ActivityLifecycleCallbacks,
LifecycleObserver {
    private static final String TAG = MyApplication.class.getSimpleName();
    private static MyApplication mInstance;
    private UserData userData;
    private GetAgentsResponse getAgentsResponse;
    private int latestVersion = 0;
    private static Bundle fuguBundle;
    private Integer isAppOpen;
    private AgentProfileDetails agentProfileDetails;
    public ArrayList<TagData> tagData = new ArrayList();
    public String deviceTokan = "";
    private Map<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>> uiListeners = new HashMap<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>>();
    private Map<Class<? extends BaseManagerInterface>, Collection<? extends BaseManagerInterface>> managerInterfaces;
    private Map<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>> messageListener = new HashMap<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>>();
    private final ArrayList<Object> registeredManagers;
    private boolean serviceStarted = false;
    private boolean closed = false;

    public void onCreate() {
        HippoActivityLifecycleCallback.register((Application)this);
        super.onCreate();
        this.addManagers();
        Typekit.getInstance().add(this.getString(R.string.proxima_r), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-Regular.ttf")).add(this.getString(R.string.proxima_b), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-SemiBold.ttf")).add(this.getString(R.string.proxima_sb), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-SemiBold.ttf")).add(this.getString(R.string.montserrat_m), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-Regular.ttf")).add(this.getString(R.string.montserrat_sb), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-SemiBold.ttf")).add(this.getString(R.string.montserrat_r), Typekit.createFromAsset((Context)this, "fonts/TitilliumWeb-Regular.ttf"));
        CalligraphyConfig.initDefault((CalligraphyConfig)new CalligraphyConfig.Builder().setDefaultFontPath("fonts/TitilliumWeb-Regular.ttf").setFontAttrId(R.attr.fontPath).build());
        Paper.init((Context)this);
        mInstance = this;
        String currentDBPath = this.getDatabasePath("hippo_agent").getAbsolutePath();
        Log.e(TAG, "currentDBPath = " + currentDBPath);
    }

    public static Bundle getFuguBundle() {
        return fuguBundle;
    }

    public static void setFuguBundle(Bundle fuguBundle) {
        MyApplication.fuguBundle = fuguBundle;
    }

    public static synchronized MyApplication getInstance() {
        return mInstance;
    }

    public void clearUserData() {
        this.userData = null;
    }

    public UserData getUserDataa() {
        if (this.userData == null) {
            this.userData = (UserData)Paper.book((String)CommonData.name).read("user_data");
            if (this.userData == null) {
                this.userData = (UserData)Paper.book().read("user_data");
            }
        }
        return this.userData;
    }

    public UserData getUserData() {
        if (this.userData == null) {
            this.userData = (UserData)Paper.book((String)CommonData.name).read("user_data");
        }
        return this.userData;
    }

    public void saveUserData(UserData uData) {
        Paper.book((String)CommonData.name).write("user_data", (Object)uData);
        this.userData = null;
    }

    public AgentProfileDetails getAgentProfileDetails() {
        if (this.agentProfileDetails == null) {
            this.agentProfileDetails = (AgentProfileDetails)Paper.book((String)CommonData.name).read("agent_data");
        }
        return this.agentProfileDetails;
    }

    public void setAgentProfileDetails(AgentProfileDetails agentProfileDetails) {
        this.agentProfileDetails = agentProfileDetails;
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    public void setAgentsResponse(GetAgentsResponse agentsResponse) {
        if (this.getAgentsResponse != null) {
            this.getAgentsResponse = agentsResponse;
        }
    }

    public GetAgentsResponse getAgentsResponse() {
        if (this.getAgentsResponse == null) {
            this.getAgentsResponse = (GetAgentsResponse)Paper.book((String)CommonData.name).read("agents");
        }
        return this.getAgentsResponse;
    }

    public void logout(Activity activity) {
        ConnectionManager.INSTANCE.onClose();
        this.agentProfileDetails = null;
        this.userData = null;
        this.clearData();
    }

    public void clearData() {
        this.deviceTokan = (String)Paper.book((String)CommonData.name).read("device_token");
        CommonData.clearData();
        this.userData = null;
        Prefs.with((Context)this).removeAll();
        try {
            new DeleteDatabase().execute(new Void[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public boolean isPermissionGranted(Context activity, String permission2) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)permission2) == 0;
    }

    public boolean askUserToGrantPermission(Activity activity, String permission2, String explanation, int code) {
        Log.e("permission", "permissions" + permission2);
        return this.askUserToGrantPermission(activity, new String[]{permission2}, explanation, code);
    }

    public boolean askUserToGrantPermission(Activity activity, String[] permissions, String explanation, int requestCode) {
        String permissionRequired = null;
        for (String permission2 : permissions) {
            if (this.isPermissionGranted((Context)activity, permission2)) continue;
            permissionRequired = permission2;
            break;
        }
        if (permissionRequired == null) {
            return true;
        }
        boolean explanationRequired = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, permissionRequired);
        Log.e("ask user", "askUserToGrantPermission: explanationRequired(" + explanationRequired + "): " + permissionRequired);
        if (explanationRequired) {
            if (explanation == null) {
                explanation = "Please grant permission";
            }
            Toast.makeText((Context)activity, (CharSequence)explanation, (int)0).show();
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
        }
        return false;
    }

    public Integer getIsAppOpen() {
        return this.isAppOpen;
    }

    public void setIsAppOpen(Integer isAppOpen) {
        this.isAppOpen = isAppOpen;
    }

    public void initializeServerURL() {
        ConfigMode configModeToSet = ConfigMode.LIVE;
        if (configModeToSet != Config.getConfigMode()) {
            RestClient.clearRestClients();
        }
        Config.setConfigMode(configModeToSet);
        Paper.book((String)CommonData.name).write("server_selected", (Object)Config.getServerUrl());
        RestClient.setupAllClients();
    }

    public MyApplication() {
        this.managerInterfaces = new HashMap<Class<? extends BaseManagerInterface>, Collection<? extends BaseManagerInterface>>();
        this.registeredManagers = new ArrayList();
    }

    private <T extends BaseUIListener> Collection<T> getOrCreateUIListeners(Class<T> cls) {
        Collection<? extends BaseUIListener> collection = this.uiListeners.get(cls);
        if (collection == null) {
            collection = new ArrayList<BaseUIListener>();
            this.uiListeners.put(cls, collection);
        }
        return collection;
    }

    public <T extends BaseUIListener> Collection<T> getUIListeners(Class<T> cls) {
        return Collections.unmodifiableCollection(this.getOrCreateUIListeners(cls));
    }

    public <T extends BaseUIListener> void addUIListener(Class<T> cls, T listener) {
        if (!this.getOrCreateUIListeners(cls).contains(listener)) {
            this.getOrCreateUIListeners(cls).add(listener);
        }
    }

    public <T extends BaseUIListener> void removeUIListener(Class<T> cls, T listener) {
        this.getOrCreateUIListeners(cls).remove(listener);
    }

    public <T extends BaseManagerInterface> Collection<T> getManagers(Class<T> cls) {
        if (this.closed) {
            return Collections.emptyList();
        }
        Collection<? extends BaseManagerInterface> collection = this.managerInterfaces.get(cls);
        if (collection == null) {
            collection = new ArrayList<BaseManagerInterface>();
            for (Object manager : this.registeredManagers) {
                if (!cls.isInstance(manager)) continue;
                collection.add((BaseManagerInterface)manager);
            }
            collection = Collections.unmodifiableCollection(collection);
            this.managerInterfaces.put(cls, collection);
        }
        return collection;
    }

    private void addManagers() {
        this.addManager(NetworkManager.getInstance((Application)this));
    }

    private void addManager(Object manager) {
        this.registeredManagers.add(manager);
    }

    private void onInitialized() {
        for (OnInitializedListener listener : this.getManagers(OnInitializedListener.class)) {
            Log.i(TAG, "OnInitializedListener onInitialized " + listener);
            listener.onInitialized();
        }
    }

    public void onTerminate() {
        super.onTerminate();
    }

    public void onServiceStarted() {
        if (this.serviceStarted) {
            return;
        }
        this.closed = false;
        Log.i(TAG, "onServiceStarted in HippoConfig");
        this.onInitialized();
    }

    public void onServiceDestroy() {
        Log.i(TAG, "onServiceDestroy");
        if (this.closed) {
            Log.i(TAG, "onServiceDestroy closed");
            return;
        }
        this.onClose();
    }

    private void onClose() {
        Log.i(TAG, "onClose1");
        for (Object manager : this.registeredManagers) {
            if (!(manager instanceof OnCloseListener)) continue;
            ((OnCloseListener)manager).onClose();
        }
        this.closed = true;
        this.serviceStarted = false;
        Log.i(TAG, "onClose2");
    }

    public int getAppVersion() {
        try {
            return this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getDeviceId() {
        try {
            return UniqueIMEIID.getUniqueIMEIId(this.getApplicationContext());
        }
        catch (Exception e) {
            return "EMPTY";
        }
    }

    public void showToast() throws Exception {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
    }

    class ClearData
    extends AsyncTask<Void, Void, Void> {
        ClearData() {
        }

        protected Void doInBackground(Void ... voids) {
            CopyOnWriteArrayList<LoggerObj> loggerObjs = Logger.INSTANCE.getData();
            CommonData.clearData();
            Paper.init((Context)MyApplication.this);
            Logger.INSTANCE.saveAllData(loggerObjs);
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
        }
    }
}

