/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.LoginCallback;
import com.hippoagent.MyApplication;
import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.LoginApi;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.apis.HippoLogout;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.database.CommonData;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.utils.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HippoConfig {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private static final String PAPER_BOOK = "hippo_agent_sdk";
    private Activity activity;
    private HippoConfigAttributes configAttributes;

    public static HippoConfig getInstance() {
        if (hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    public static void initHippoConfig(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        HippoConfig.getInstance().configAttributes = configAttributes;
        CommonData.saveAttributes(configAttributes);
        HippoConfig.getInstance().activity = activity;
        MyApplication.getInstance().initializeServerURL();
        HippoConfig.loginHippoAgent(activity, configAttributes, callback);
    }

    public void openMainScreen(@NotNull Activity activity) {
        if (MyApplication.getInstance().getUserData() != null) {
            activity.startActivity(new Intent((Context)activity, HomeActivity.class));
        } else {
            Log.e("HippoConfig", "Need to login first");
        }
    }

    public void openSavedReply(Activity activity) {
        if (MyApplication.getInstance().getUserData() != null && MyApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed()) {
            Intent planIntent = new Intent((Context)activity, PlansActivity.class);
            activity.startActivity(planIntent);
        } else {
            Log.e("Error", "Feature not available");
        }
    }

    public void openBroadcast(@NotNull Activity activity) {
        if (MyApplication.getInstance().getUserData() != null) {
            activity.startActivity(new Intent((Context)activity, BroadcastListActivity.class));
        } else {
            Log.e("HippoConfig", "Need to login first");
        }
    }

    public void logoutHippo(Activity activity) {
        HippoLogout.INSTANCE.logout(activity);
    }

    public HippoConfigAttributes getAttributes() {
        if (this.configAttributes == null) {
            this.configAttributes = CommonData.getConfigAttributes();
        }
        return this.configAttributes;
    }

    private static void loginHippoAgent(Activity activity, HippoConfigAttributes configAttributes, final LoginCallback callback) {
        LoginApi.INSTANCE.login(activity, configAttributes, new LoginApiCallBack(){

            @Override
            public void onErrorMessage(@NotNull LoginResponse t) {
                callback.onError();
            }

            @Override
            public void onApiSuccess(@NotNull LoginResponse t) {
                HippoConfig.openChannel();
                callback.success();
            }

            @Override
            public void onApiFailed(@Nullable APIError error) {
                callback.failed();
            }

            @Override
            public void singleBtnUpdateWindow(@NotNull LoginResponse t) {
                HippoConfig.openChannel();
                callback.success();
            }

            @Override
            public void showUpdateWindowTwoBtns(@NotNull LoginResponse t) {
                HippoConfig.openChannel();
                callback.success();
            }
        }, false, true);
    }

    private static void openChannel() {
        ConnectionManager.INSTANCE.initFayeConnection();
        if (MyApplication.getInstance().getUserData() != null && !TextUtils.isEmpty((CharSequence)MyApplication.getInstance().getUserData().getUserChannel())) {
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getUserChannel());
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/agentsRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/agentRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/userMigration");
        }
    }
}

