package com.hippoagent.utils.filelogger

import android.os.AsyncTask
import android.text.TextUtils
import com.hippoagent.MyApplication
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.FuguUploadImageResponse
import com.hippoagent.retrofit.*
import com.hippoagent.utils.Constants
import com.google.gson.Gson
import java.io.File

/**
 * Created by gurmail on 13/05/19.
 * @author gurmail
 */
class UploadLogFile : AsyncTask<String, Void, Void>(), FuguAppConstant {

    override fun doInBackground(vararg params: String?): Void? {
        uploadFile(params[0]!!)
        return null
    }

    private fun uploadFile(path: String) {
        try {
            val multipartBuilder = MultipartParams.Builder()
            val accessToken = MyApplication.getInstance().userData.accessToken
            if(TextUtils.isEmpty(accessToken))
                return
            val multipartParams = multipartBuilder
                    .add(Constants.ACCESS_TOKEN, accessToken)
                    .addFile("file", File(path))
                    .build()
            RestClient.getApiInterface().uploadFile(multipartParams.map).enqueue(object : ResponseResolver<FuguUploadImageResponse>() {
                override fun success(t: FuguUploadImageResponse?) {
                    try {
                        Logger.setFileUploading(false)

                        try {
                            val file = File(path)
                            file.delete()
                        } catch (e: Exception) {
                        }


                        var loggerParams : LoggerParams? = t?.let {
                            LoggerParams(it, MyApplication.getInstance().userData.userId,
                                    MyApplication.getInstance().getDeviceId())
                        }

                        val accessToken = MyApplication.getInstance().userData.accessToken
                        val commonParams = CommonParams.Builder()
                                .add("access_token", MyApplication.getInstance().userData.accessToken)
                                .add("error", Gson().toJson(loggerParams))
                                .build()


                        if(!TextUtils.isEmpty(accessToken))
                            sendFileData(commonParams)
                    } catch (e: Exception) {
                    }

                }

                override fun failure(error: APIError?) {
                    Logger.apiFailed("/api/conversation/uploadFile", "File uploading failed")
                }

            })
        } catch (e: Exception) {
        }
    }

    private fun sendFileData(params: CommonParams) {
        RestClient.getApiInterface().sendError(params.map).enqueue(object : ResponseResolver<CommonResponse>() {
            override fun success(t: CommonResponse?) {
                Logger.setFileUploading(false)
            }

            override fun failure(error: APIError?) {
                Logger.setFileUploading(false)
            }
        })
    }
}