package com.hippoagent.utils.filelogger

import android.text.TextUtils
import io.paperdb.Paper
import java.io.File
import java.util.*
import java.util.concurrent.CopyOnWriteArrayList

/**
 * Created by gurmail on 14/05/19.
 * @author gurmail
 */
object Logger {

    private var loggerObj = CopyOnWriteArrayList<LoggerObj>()
    private var tempLoggerObj = CopyOnWriteArrayList<LoggerObj>()
    private val LOGGER_KEY = "logger_data"
    private val LAST_LOGGER_UPLOAD = "last_log_uploaded"
    private var fileUploading: Boolean = false

    //var mLogPath :String = MyApplication.getInstance().applicationContext.filesDir.path+"${File.separator}logs.txt"


    @Synchronized
    fun saveData(logger: LoggerObj) {
        /*Thread(Runnable {
            android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_BACKGROUND)
            try {
                if(loggerObj.size == 0)
                    loggerObj = getData()
                if(fileUploading) {
                    tempLoggerObj.add(logger)
                } else {
                    loggerObj.add(logger)
                    try {
                        Paper.book("logs").write(LOGGER_KEY, loggerObj)
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            } catch (e: Exception) {
            }
        }).start()*/
    }

    fun fileSize() : Boolean {
        val path = Paper.book("logs").getPath(LOGGER_KEY)
        val size = File(path).length()
        return size/1024 > 3 * 1024
    }

    fun getData() : CopyOnWriteArrayList<LoggerObj> {
        try {
            loggerObj = Paper.book("logs").read(LOGGER_KEY)
        } catch (e: Exception) {
            Paper.book("logs").delete(LOGGER_KEY)
            return CopyOnWriteArrayList()
        }
        return loggerObj
    }

    fun saveAllData(loggerObj: CopyOnWriteArrayList<LoggerObj>) {
        try {
            Paper.book("logs").write(LOGGER_KEY, loggerObj)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun deleteData() {
        updateLogSend()
        Paper.book("logs").delete(LOGGER_KEY)
    }

    fun updateLogSend() {
        Paper.book("logs").write(LAST_LOGGER_UPLOAD, System.currentTimeMillis())
    }

    fun getLastUploadedTime() : Long {
        return Paper.book("logs").read(LAST_LOGGER_UPLOAD, -1)
    }

    fun apiRequest(endPoint: String, message: String) {
        val logger: LoggerObj = LoggerObj(Date(), endPoint, message)
        saveData(logger)
    }

    fun apiResponse(endPoint: String, message: String) {
        var data = message
        if (TextUtils.isEmpty(message))
            data = "Api sucess"
        val logger: LoggerObj = LoggerObj(Date(), endPoint, data)
        saveData(logger)
    }

    fun apiFailed(endPoint: String, message: String) {
        val logger: LoggerObj = LoggerObj(Date(), endPoint, message)
        saveData(logger)
    }

    fun fayeConnected(fayeUrl: String) {
        val logger: LoggerObj = LoggerObj(Date(), fayeUrl, "Faye connecting...")
        saveData(logger)
    }

    fun fayeSubscribed(channelID: String) {
        val logger: LoggerObj = LoggerObj(Date(), "", "Faye subscribe: $channelID")
        saveData(logger)
    }

    fun fayeUnsubscribed(channelID: String) {
        val logger: LoggerObj = LoggerObj(Date(), "", "Faye unsubscribe: $channelID")
        saveData(logger)
    }

    fun fayeDisconnected() {
        val logger: LoggerObj = LoggerObj(Date(), "", "Faye Disconnecting...")
        saveData(logger)
    }

    fun fayeError() {
        val logger: LoggerObj = LoggerObj(Date(), "", "Error in faye connection")
        saveData(logger)
    }

    fun setFileUploading(flag: Boolean) {
        fileUploading = flag
        if(!flag && tempLoggerObj?.size>0) {
            loggerObj.addAll(tempLoggerObj)
            tempLoggerObj.clear()
        }
    }

}