package com.hippoagent.utils.filePicker;


import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.core.content.FileProvider;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.Utils;

import java.io.*;
import java.net.URLConnection;
import java.nio.channels.FileChannel;

/**
 * Created by gurmail on 17/01/19.
 *
 * @author gurmail
 */
public class FileManager implements FuguAppConstant {
    private static final String TAG = FileManager.class.getSimpleName();
    private static FileManager instance;
    private FileManager() {

    }

    public static FileManager getInstance() {
        if(instance == null) {
            synchronized (FileManager.class) {
                if(instance == null) {
                    instance = new FileManager();
                }
            }
        }
        return instance;
    }

    public String getLocalPath(String fileName, String folderType) {
        try {
            String localName = Utils.getDirectoryPath(folderType) + File.separator + fileName;
            File file = new File(localName);//.getParentFile();
            if(file.exists() && file.isFile()) {
                return file.getPath();
            }
            return "";
        } catch (Exception e) {
            return "";
        }
    }

    long maxSize = 15 *1024*1024;
    public void copyFile(String sourceUrl, String folderType, FileuploadModel fileuploadModel, FileCopyListener fileCopyListener) throws IOException {
        String localName = fileuploadModel.getFileName();
        //localName = Utils.getFileName(localName, fileuploadModel.getMuid());

        File sourceFile = new File(sourceUrl);
        if(!sourceFile.exists() && !sourceFile.isFile()) {
            fileCopyListener.onError();
            return;
        }
        try {
            maxSize = MyApplication.getInstance().getUserData().getMaxFileSize();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(folderType.equalsIgnoreCase(FOLDER_TYPE.get(DocumentType.FILE.toString())) && sourceFile.length() > maxSize) {
            fileCopyListener.largeFileSize();
            return;
        } else if(!folderType.equalsIgnoreCase(FOLDER_TYPE.get(DocumentType.VIDEO.toString())) && sourceFile.length() > maxSize) {
            fileCopyListener.largeFileSize();
            return;
        } else if(!folderType.equalsIgnoreCase(FOLDER_TYPE.get(DocumentType.AUDIO.toString())) && sourceFile.length() > maxSize) {
            fileCopyListener.largeFileSize();
            return;
        } else if(!folderType.equalsIgnoreCase(FOLDER_TYPE.get(DocumentType.IMAGE.toString())) && sourceFile.length() > maxSize) {
            fileCopyListener.largeFileSize();
            return;
        }
        File destFile = new File(Utils.getDirectoryPath(folderType), localName);

        if(sourceUrl.equalsIgnoreCase(Utils.getDirectoryPath(folderType)+"/"+localName)) {
            if(fileCopyListener != null) {
                fileuploadModel.setFilePath(destFile.getPath());
                fileCopyListener.onCopingFile(true, fileuploadModel);
            }
            return;
        }

        if (!destFile.getParentFile().exists())
            destFile.getParentFile().mkdirs();

        if (!destFile.exists()) {
            destFile.createNewFile();
        }

        FileChannel source = null;
        FileChannel destination = null;

        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0, source.size());
        } finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }

        if(fileCopyListener != null) {
            fileuploadModel.setFilePath(destFile.getPath());
            fileCopyListener.onCopingFile(true, fileuploadModel);
        }

    }

    public void openFileInDevice(Context context, String localPath, FileCopyListener fileCopyListener) {
        MimeTypeMap myMime = MimeTypeMap.getSingleton();
        Intent newIntent = new Intent(Intent.ACTION_VIEW);
        String mimeType = myMime.getMimeTypeFromExtension(Utils.getExtension(localPath));
        if(TextUtils.isEmpty(mimeType))
            mimeType =  URLConnection.guessContentTypeFromName(localPath);
        Uri uri = FileProvider.getUriForFile(context, CommonData.getProvider(), new File(localPath));
        newIntent.setDataAndType(uri, mimeType);
        newIntent.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION | Intent.FLAG_ACTIVITY_CLEAR_TOP);
        newIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        newIntent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
        newIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        try {
            context.startActivity(newIntent);
        } catch (Exception e) {
            if(fileCopyListener != null) {
                fileCopyListener.onError();

            } else {
                Toast.makeText(context, context.getString(R.string.no_handler), Toast.LENGTH_LONG).show();
            }
        }
    }

    public interface FileCopyListener {
        void onCopingFile(boolean flag, FileuploadModel fileuploadModel);
        void largeFileSize();
        void onError();
    }


}
