package com.hippoagent.retrofit;

import android.text.TextUtils;

import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoConfig;
import com.hippoagent.MyApplication;
import com.hippoagent.model.user_details.DeviceDetails;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import okhttp3.MediaType;
import okhttp3.RequestBody;

import static com.hippoagent.utils.Constants.ANDROID_USER;
import static com.hippoagent.utils.Constants.APP_SOURCE_TYPE;
import static com.hippoagent.utils.Constants.APP_VERSION;
import static com.hippoagent.utils.Constants.DEVICE_DETAILS;
import static com.hippoagent.utils.Constants.DEVICE_ID;
import static com.hippoagent.utils.Constants.DEVICE_TYPE;


/**
 * Created by cl-macmini-33 on 03/10/16.
 */

public class MultipartParams {
    HashMap<String, RequestBody> map = new HashMap<>();
    Gson gson = new GsonBuilder().create();

    private MultipartParams(Builder builder) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new DeviceDetails(MyApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
        } catch (Exception e) {
            //e.printStackTrace();
        }

        try {
            deviceID = MyApplication.getInstance().getDeviceId();
        } catch (Exception e) {

        }


        builder.map.put(APP_SOURCE_TYPE, RetrofitUtils.getRequestBodyFromString(String.valueOf(2)));
        builder.map.put(APP_VERSION, RetrofitUtils.getRequestBodyFromString(String.valueOf(HippoConfig.getInstance().getAttributes().getVersionCode())));
        builder.map.put(DEVICE_TYPE, RetrofitUtils.getRequestBodyFromString(String.valueOf(ANDROID_USER)));
        if(deviceDetailsJson != null)
            builder.map.put(DEVICE_DETAILS, RetrofitUtils.getRequestBodyFromString(gson.toJson(deviceDetailsJson)));
        if(!TextUtils.isEmpty(deviceID))
            builder.map.put(DEVICE_ID, RetrofitUtils.getRequestBodyFromString(deviceID));


        if(HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
            builder.map.put("reference_secret_key", RetrofitUtils.getRequestBodyFromString(HippoConfig.getInstance().getAttributes().getAppKey()));
        }

        this.map = builder.map;

    }

    public HashMap<String, RequestBody> getMap() {
        return map;
    }


    public static class Builder {
        HashMap<String, RequestBody> map = new HashMap<>();

        public Builder() {
        }

        public Builder add(String key, Object value) {

            if (value == null || String.valueOf(value).isEmpty())
                return this;
            map.put(key, RetrofitUtils.getRequestBodyFromString(String.valueOf(value)));
            return this;
        }

        //for single file
        public Builder addFile(String key, File mFile) {
            if (mFile == null)
                return this;

            map.put(key + "\"; filename=\"" + mFile.getName(), RequestBody.create(MediaType.parse(RetrofitUtils.getMimeType(mFile)), mFile));
            return this;
        }

        // for multiple file with same key
        public Builder addArrayOfFiles(String key, ArrayList<File> mFileArrayList) {
            if (mFileArrayList == null || mFileArrayList.size() == 0)
                return this;

            for (int i = 0; i < mFileArrayList.size(); i++)
                if (mFileArrayList.get(i) != null)
                    map.put(key + "\"; filename=\"" + mFileArrayList.get(i).getName(), RequestBody.create(MediaType.parse(RetrofitUtils.getMimeType(mFileArrayList.get(i))), mFileArrayList.get(i)));
            return this;
        }


        public MultipartParams build() {
            return new MultipartParams(this);
        }
    }
}

