package com.hippoagent.retrofit;

import android.text.TextUtils;

import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoConfig;
import com.hippoagent.MyApplication;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import java.util.HashMap;

import static com.hippoagent.utils.Constants.ANDROID_USER;
import static com.hippoagent.utils.Constants.APP_SOURCE_TYPE;
import static com.hippoagent.utils.Constants.APP_VERSION;
import static com.hippoagent.utils.Constants.DEVICE_DETAILS;
import static com.hippoagent.utils.Constants.DEVICE_ID;
import static com.hippoagent.utils.Constants.DEVICE_TYPE;

/**
 * Created by gurmail on 21/12/18.
 *
 * @author gurmail
 */

public class CommonParamsObj {
    HashMap<String, Object> map = new HashMap<>();
    Gson gson = new GsonBuilder().create();


    private CommonParamsObj(Builder builder) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new DeviceDetails(MyApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
            Log.e("TAG", ""+gson.toJson(deviceDetailsJson));
        } catch (Exception e) {
            //e.printStackTrace();
        }

        try {
            deviceID = MyApplication.getInstance().getDeviceId();
        } catch (Exception e) {

        }


        builder.map.put(APP_SOURCE_TYPE, String.valueOf(2));
        builder.map.put(APP_VERSION, String.valueOf(HippoConfig.getInstance().getAttributes().getVersionCode()));
        builder.map.put(DEVICE_TYPE, String.valueOf(ANDROID_USER));
        if(deviceDetailsJson != null)
            builder.map.put(DEVICE_DETAILS, gson.toJson(deviceDetailsJson));
        if(!TextUtils.isEmpty(deviceID))
            builder.map.put(DEVICE_ID, deviceID);

        if(HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
            builder.map.put("reference_secret_key", RetrofitUtils.getRequestBodyFromString(HippoConfig.getInstance().getAttributes().getAppKey()));
        }

        this.map = builder.map;

    }

    public HashMap<String, Object> getMap() {
        return map;
    }


    public static class Builder {
        HashMap<String, Object> map = new HashMap<>();

        public Builder() {
        }

        public Builder addAccessToken(String key, String value) {
            map.put(key, value);
            return this;
        }

        public Builder add(String key, Object value) {
            if(key.equalsIgnoreCase(Constants.ACCESS_TOKEN)) {
                addAccessToken(key, MyApplication.getInstance().getUserData().getAccessToken());
            } else {
                map.put(key, String.valueOf(value));
            }
            return this;
        }

        public Builder addAll(HashMap<String, Object> objectHashMap) {
            map.putAll(objectHashMap);
            return this;
        }

        public CommonParamsObj build() {
            return new CommonParamsObj(this);
        }
    }
}
