package com.hippoagent.retrofit;


import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.BroadcastResponse;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.model.ChatMembersModel;
import com.hippoagent.model.Continent.Continent;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.FuguGetConversationsResponse;
import com.hippoagent.model.FuguGetMessageParams;
import com.hippoagent.model.FuguGetMessageResponse;
import com.hippoagent.model.FuguUploadImageResponse;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.GetChannelsResponse;
import com.hippoagent.model.GetConversationResponse;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.MakePayment;
import com.hippoagent.model.Message;
import com.hippoagent.model.TagsToChannel;
import com.hippoagent.model.onBoard.EditInfoRequest;
import com.hippoagent.model.onBoard.UserConfig;
import com.hippoagent.model.UserInfoModel;
import com.hippoagent.model.add_deal.AddDeal;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.model.assigne_tag.AssignTagResponse;
import com.hippoagent.model.conversation_search.ConversationSearchResponse;
import com.hippoagent.model.createConversation.CreateConversation;
import com.hippoagent.model.create_tag.CreateTagResponse;
import com.hippoagent.model.get_all_bots.GetAllBots;
import com.hippoagent.model.get_deal_info.GetDealInfo;
import com.hippoagent.model.gettags.GetTagsResponse;
import com.hippoagent.model.graph.AnalyticsResponse;
import com.hippoagent.model.payment.EditPaymentRequest;
import com.hippoagent.model.payment.GetPaymentLinks;
import com.hippoagent.model.payment.PaymentModel;
import com.hippoagent.model.payment.SavedPlanResponse;
import com.hippoagent.model.response_modals.GiffyResponse;
import com.hippoagent.model.update_deal.UpdateDeal;
import com.hippoagent.model.user_detail.EditUserDetails;
import com.hippoagent.model.user_details.UserDetailsResponse;
import com.hippoagent.utils.Constants;

import java.util.Map;

import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

import static com.hippoagent.datastructure.FuguAppConstant.APP_VERSION;
import static com.hippoagent.datastructure.FuguAppConstant.DEVICE_TYPE;

/**
 * ApiInterface
 */
public interface ApiInterface {

    @POST("/api/conversation/getMessages")
    Call<FuguGetMessageResponse> getMessages(@Body FuguGetMessageParams obj);

    @FormUrlEncoded
    @POST("/api/conversation/getConversations")
    Call<FuguGetConversationsResponse> getConversations(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/v1/agentLogin")
    Call<LoginResponse> login(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/business/signUp")
    Call<LoginResponse> signup(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/resetPasswordRequest")
    Call<LoginResponse> forgotPassword(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/agentLogout")
    Call<LoginResponse> logout(@FieldMap Map<String, String> map);

    @GET("/requestCountryCodeGeoIP2")
    Call<Continent> getContinent();

    @FormUrlEncoded
    @POST("/api/conversation/v2/getConversations")
    Call<GetConversationResponse> getConversation(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/conversation/markConversation")
    Call<GetConversationResponse> markConversation(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/assignAgent")
    Call<GetConversationResponse> assignAgent(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/getAgents")
    Call<GetAgentsResponse> getAgents(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/channel/getChannels")
    Call<GetChannelsResponse> getChannels(@FieldMap Map<String, String> map);

    @Multipart
    @POST("/api/conversation/uploadFile")
    Call<FuguUploadImageResponse> uploadFile(@PartMap Map<String, RequestBody> map);

    @Multipart
    @POST("/api/conversation/uploadFile")
    Call<FuguUploadImageResponse> uploadFile(@Header(Constants.ACCESS_TOKEN) String appSecretKey, @Header(DEVICE_TYPE) int deviceType, @Header(APP_VERSION) int appVersion, @Part MultipartBody.Part file, @PartMap Map<String, RequestBody> map);

    @FormUrlEncoded
    @POST("/api/business/getCannedMessages")
    Call<CannedMessageResponse> getCannedMessages(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/tags/getChannelTags")
    Call<GetAgentsResponse> getChannelTags(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/analyticsv2/getData")
    Call<AnalyticsResponse> getHeatChatAnalytics(@FieldMap Map<String, String> map);

    @Multipart
    @POST("login_user")
    Call<AnalyticsResponse> loginParam(@Part("email") RequestBody email, @Part("password") RequestBody pass);

    @FormUrlEncoded
    @POST("api/users/getUserDetails")
    Call<UserDetailsResponse> getUserDetails(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/getInfo")
    Call<AgentProfileDetails> getAgentInfo(@FieldMap Map<String, String> map);

    @Multipart
    @POST("/api/agent/editInfo")
    Call<EditProfileResponse> editAgentInfo(@PartMap Map<String, RequestBody> map);

    @FormUrlEncoded
    @POST("/api/agent/changePassword")
    Call<AgentProfileDetails> changePassword(@FieldMap Map<String, String> map);

    @GET("http://api.giphy.com/v1/gifs/search")
    Call<GiffyResponse> getGiffs(@Query("q") String searchText, @Query("api_key") String apiKey, @Query("limit") int limit);

    @FormUrlEncoded
    @POST("/api/bulbul/getDealInfo")
    Call<GetDealInfo> getDealInfo(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/bulbul/addDeal")
    Call<AddDeal> addDealToBulbul(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/bulbul/updateDeal")
    Call<UpdateDeal> updateDeal(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/users/editUserDetails")
    Call<EditUserDetails> editUserDetails(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/conversation/createConversation")
    Call<CreateConversation> createConversation(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/tags/assignTagsToChannel")
    Call<AssignTagResponse> assignTags(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/tags/createTags")
    Call<CreateTagResponse> createTag(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/tags/getTags")
    Call<GetTagsResponse> getTags(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/editConfiguration")
    Call<GetTagsResponse> setTnCStatus(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/agent/getAllBotActions")
    Call<GetAllBots> getBotOptions(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("api/v2/conversation/search")
    Call<ConversationSearchResponse> conversationSearch(@FieldMap Map<String, String> map);

    @GET("/requestCountryCodeGeoIP2")
    Call<UserInfoModel> getUserInfo();

    @FormUrlEncoded
    @POST("api/broadcast/getBroadcastList")
    Call<BroadcastResponse> getBroadcastList(@FieldMap Map<String, String> stringMap);

    @GET("/api/broadcast/broadcastStatus")
    Call<BroadcastResponse> broadcastStatus(@QueryMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/chat/getMembers")
    Call<ChatMembersModel> getChatMembers(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/billing/getProperties")
    Call<PaymentModel> getPayemtAgent(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/billing/startAgentPlan")
    Call<PaymentModel> uploadCardToken(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/conversation/sendMessage")
    Call<PaymentModel> sendReply(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/server/logException")
    Call<CommonResponse> sendError(@FieldMap Map<String, String> map);

    @POST("/api/tags/v2/assignTagsToChannel")
    Call<CommonResponse> updateTagsToChannel(@Body TagsToChannel tags);

    @FormUrlEncoded
    @POST("/api/conversation/editMessage")
    Call<Message> editMessage(@FieldMap Map<String, String> map);

    @FormUrlEncoded
    @POST("/api/conversation/getChannelJourney")
    Call<CommonResponse> channelJourney(@FieldMap Map<String, String> map);

    @GET("/api/apps/getConfig")
    Call<UserConfig> getUserConfig(@QueryMap Map<String, String> map);

    @POST("/api/payment/sendPaymentUrl")
    Call<CommonResponse> createPaymentLink(@Body MakePayment makePayment);

    @FormUrlEncoded
    @POST("/api/agent/agentSignup")
    Call<LoginResponse> agentSignup(@FieldMap Map<String, String> map);

    @POST("/api/agent/editInfo")
    Call<LoginResponse> editInfo(@Body EditInfoRequest map);

    @POST("/api/agent/getPaymentPlans")
    Call<SavedPlanResponse> getPaymentLinks(@Body GetPaymentLinks paymentLinks);

    @POST("/api/agent/editPaymentPlans")
    Call<SavedPlanResponse> editPaymentLinks(@Body EditPaymentRequest paymentLinks);


    @FormUrlEncoded
    @POST("/api/conversation/updateConferenceCall")
    Call<CommonResponse> updateConferenceCall(@Header(FuguAppConstant.DEVICE_TYPE) int deviceType, @Header(FuguAppConstant.APP_VERSION) int appVersion, @FieldMap Map<String, String> inviteDetails);

}
