package com.hippoagent.receiver;

import android.app.Application;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;

import com.hippoagent.callback.OnCloseListener;
import com.hippoagent.callback.OnInitializedListener;
import com.hippoagent.utils.Log;

/**
 * Created by gurmail on 05/06/18.
 *
 * @author gurmail
 */

public class NetworkManager implements OnCloseListener, OnInitializedListener {
    private static final String LOG_TAG = NetworkManager.class.getSimpleName();
    private final FuguNetworkStateReceiver connectivityReceiver;
    private final ConnectivityManager connectivityManager;

    private static NetworkManager instance;
    private Application application;

    public static NetworkManager getInstance(Application application) {
        if (instance == null) {
            instance = new NetworkManager(application);
        }

        return instance;
    }

    private NetworkManager(Application application) {
        this.application = application;
        //HippoConfig application = HippoConfig.getInstance();
        connectivityReceiver = new FuguNetworkStateReceiver();
        connectivityManager = (ConnectivityManager) application.getSystemService(Context.CONNECTIVITY_SERVICE);
    }

    @Override
    public void onInitialized() {
        Log.i(LOG_TAG, "onInitialized");
        IntentFilter filter = new IntentFilter();
        filter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        application.registerReceiver(connectivityReceiver, filter);
    }

    @Override
    public void onClose() {
        try {
            Log.i(LOG_TAG, "connectivityReceiver unregistered");
            application.unregisterReceiver(connectivityReceiver);
        } catch (IllegalArgumentException e) {
            Log.e(LOG_TAG, e.toString());
        }
    }

}
