package com.hippoagent.model.onBoard;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Created by gurmail on 2019-10-10.
 *
 * @author gurmail
 */
public class UserConfig {
    @SerializedName("statusCode")
    @Expose
    private Integer statusCode;
    @SerializedName("message")
    @Expose
    private String message;
    @SerializedName("data")
    @Expose
    private Data data;

    public Integer getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public class Data {
        @SerializedName("signup_enabled")
        @Expose
        private int signupEnabled;
        @SerializedName("terms_and_condition")
        @Expose
        private String termsAndCondition;
        @SerializedName("privacy_policy")
        @Expose
        private String privacyPolicy;
        @SerializedName("business_properties")
        @Expose
        private BusinessProperties businessProperties;
        @SerializedName("templates")
        @Expose
        private List<CustomField> templates = null;

        public Integer getSignupEnabled() {
            return signupEnabled;
        }

        public void setSignupEnabled(Integer signupEnabled) {
            this.signupEnabled = signupEnabled;
        }


        public void setTermsAndCondition(String termsAndCondition) {
            this.termsAndCondition = termsAndCondition;
        }


        public void setPrivacyPolicy(String privacyPolicy) {
            this.privacyPolicy = privacyPolicy;
        }

        public BusinessProperties getBusinessProperties() {
            return businessProperties;
        }

        public void setBusinessProperties(BusinessProperties businessProperties) {
            this.businessProperties = businessProperties;
        }

        public List<CustomField> getTemplates() {
            return templates;
        }

        public void setTemplates(List<CustomField> templates) {
            this.templates = templates;
        }

        public boolean isSignupEnabled() {
            try {
                return signupEnabled == 1;
            } catch (Exception e) {
                return false;
            }
        }

        public String getTermsAndCondition() {
            return termsAndCondition;
        }

        public String getPrivacyPolicy() {
            return privacyPolicy;
        }
    }

    public class BusinessProperties {

        @SerializedName("whitelabel_enabled")
        @Expose
        private String whitelabelEnabled;
        @SerializedName("whitelabeled_show_widget")
        @Expose
        private String whitelabeledShowWidget;
        @SerializedName("whitelabeled_logo_url")
        @Expose
        private String whitelabeledLogoUrl;
        @SerializedName("whitelabeled_fav_url")
        @Expose
        private String whitelabeledFavUrl;
        @SerializedName("whitelabeled_terms_n_condition")
        @Expose
        private String whitelabeledTermsNCondition;
        @SerializedName("whitelabeled_privacy")
        @Expose
        private String whitelabeledPrivacy;
        @SerializedName("whitelabeled_tab_title")
        @Expose
        private String whitelabeledTabTitle;
        @SerializedName("whitelabeled_widget_app_key")
        @Expose
        private String whitelabeledWidgetAppKey;
        @SerializedName("whitelabeled_widget_tags")
        @Expose
        private String whitelabeledWidgetTags;
        @SerializedName("whitelabeled_header_title")
        @Expose
        private String whitelabeledHeaderTitle;
        @SerializedName("whitelabeled_domain")
        @Expose
        private String whitelabeledDomain;
        @SerializedName("website_theme")
        @Expose
        private String websiteTheme;
        @SerializedName("is_consultant_signup_allowed")
        @Expose
        private int isConsultantSignupAllowed;
        @SerializedName("is_consultant_verification_required")
        @Expose
        private String isConsultantVerificationRequired;
        @SerializedName("consultant_termed_as")
        @Expose
        private String registerAs;

        public String getWhitelabelEnabled() {
            return whitelabelEnabled;
        }

        public void setWhitelabelEnabled(String whitelabelEnabled) {
            this.whitelabelEnabled = whitelabelEnabled;
        }

        public String getWhitelabeledShowWidget() {
            return whitelabeledShowWidget;
        }

        public void setWhitelabeledShowWidget(String whitelabeledShowWidget) {
            this.whitelabeledShowWidget = whitelabeledShowWidget;
        }

        public String getWhitelabeledLogoUrl() {
            return whitelabeledLogoUrl;
        }

        public void setWhitelabeledLogoUrl(String whitelabeledLogoUrl) {
            this.whitelabeledLogoUrl = whitelabeledLogoUrl;
        }

        public String getWhitelabeledFavUrl() {
            return whitelabeledFavUrl;
        }

        public void setWhitelabeledFavUrl(String whitelabeledFavUrl) {
            this.whitelabeledFavUrl = whitelabeledFavUrl;
        }

        public String getWhitelabeledTermsNCondition() {
            return whitelabeledTermsNCondition;
        }

        public void setWhitelabeledTermsNCondition(String whitelabeledTermsNCondition) {
            this.whitelabeledTermsNCondition = whitelabeledTermsNCondition;
        }

        public String getWhitelabeledPrivacy() {
            return whitelabeledPrivacy;
        }

        public void setWhitelabeledPrivacy(String whitelabeledPrivacy) {
            this.whitelabeledPrivacy = whitelabeledPrivacy;
        }

        public String getWhitelabeledTabTitle() {
            return whitelabeledTabTitle;
        }

        public void setWhitelabeledTabTitle(String whitelabeledTabTitle) {
            this.whitelabeledTabTitle = whitelabeledTabTitle;
        }

        public String getWhitelabeledWidgetAppKey() {
            return whitelabeledWidgetAppKey;
        }

        public void setWhitelabeledWidgetAppKey(String whitelabeledWidgetAppKey) {
            this.whitelabeledWidgetAppKey = whitelabeledWidgetAppKey;
        }

        public String getWhitelabeledWidgetTags() {
            return whitelabeledWidgetTags;
        }

        public void setWhitelabeledWidgetTags(String whitelabeledWidgetTags) {
            this.whitelabeledWidgetTags = whitelabeledWidgetTags;
        }

        public String getWhitelabeledHeaderTitle() {
            return whitelabeledHeaderTitle;
        }

        public void setWhitelabeledHeaderTitle(String whitelabeledHeaderTitle) {
            this.whitelabeledHeaderTitle = whitelabeledHeaderTitle;
        }

        public String getWhitelabeledDomain() {
            return whitelabeledDomain;
        }

        public void setWhitelabeledDomain(String whitelabeledDomain) {
            this.whitelabeledDomain = whitelabeledDomain;
        }

        public String getWebsiteTheme() {
            return websiteTheme;
        }

        public void setWebsiteTheme(String websiteTheme) {
            this.websiteTheme = websiteTheme;
        }

        public int getIsConsultantSignupAllowed() {
            return isConsultantSignupAllowed;
        }

        public void setIsConsultantSignupAllowed(int isConsultantSignupAllowed) {
            this.isConsultantSignupAllowed = isConsultantSignupAllowed;
        }

        public String getIsConsultantVerificationRequired() {
            return isConsultantVerificationRequired;
        }

        public void setIsConsultantVerificationRequired(String isConsultantVerificationRequired) {
            this.isConsultantVerificationRequired = isConsultantVerificationRequired;
        }

        public String getRegisterAs() {
            return registerAs;
        }

        public void setRegisterAs(String registerAs) {
            this.registerAs = registerAs;
        }
    }
}
