package com.hippoagent.model.LoginResponse;

import android.os.Parcel;
import android.os.Parcelable;

import com.hippoagent.model.AnalyticsDatum;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

public class UserData implements Parcelable {

    @SerializedName("user_properties")
    @Expose
    private UserProperties userProperties;
    @SerializedName("expiry_info")
    @Expose
    private ExpiryInfo expiryInfo;
    @SerializedName("access_token")
    @Expose
    private String accessToken;
    @SerializedName("app_secret_key")
    @Expose
    private String appSecretKey;
    @SerializedName("business_name")
    @Expose
    private String businessName;
    @SerializedName("user_id")
    @Expose
    private Integer userId;
    @SerializedName("business_id")
    @Expose
    private Integer businessId;
    @SerializedName("user_name")
    @Expose
    private String userName;
    @SerializedName("full_name")
    @Expose
    private String fullName;
    @SerializedName("email")
    @Expose
    private String email;
    @SerializedName("phone_number")
    @Expose
    private String phoneNumber;
    @SerializedName("user_channel")
    @Expose
    private String userChannel;
    @SerializedName("tags")
    @Expose
    private List<Tag> tags = null;
    @SerializedName("channel_filter")
    @Expose
    private List<ChannelFilter> channelFilter = null;
    @SerializedName("user_image")
    @Expose
    private String userImage;
    @SerializedName("agent_type")
    @Expose
    private Integer agentType;
    @SerializedName("online_status")
    @Expose
    private String onlineStatus;
    @SerializedName("business_property")
    @Expose
    private BusinessProperty businessProperty;
    @SerializedName("billing_plan")
    @Expose
    private Boolean billingPlan;
    @SerializedName("is_boarding_complete")
    @Expose
    private Integer isBoardingComplete;
    @SerializedName("is_boarding_skip")
    @Expose
    private Integer isBoardingSkip;
    @SerializedName("is_video_call_enabled")
    @Expose
    private Integer isVideoCallEnabled;
    @SerializedName("is_audio_call_enabled")
    @Expose
    private Integer isAudioCallEnabled;
    @SerializedName("version")
    @Expose
    private Version version;
    @SerializedName("terms_and_condition")
    @Expose
    private Integer termsAndCondition;
    @SerializedName("agent_onboarding_completed")
    @Expose
    private Integer agentOnboardingComplete;
    @SerializedName("line_before_feedback")
    @Expose
    private String lineBeforeFeedback;
    @SerializedName("line_after_feedback_1")
    @Expose
    private String lineAfterFeedback1;
    @SerializedName("max_file_size")
    @Expose
    private Long maxFileSize;
    @SerializedName("line_after_feedback_2")
    @Expose
    private String lineAfterFeedback2;
    @SerializedName("en_user_id")
    @Expose
    private String enUserId;
    @SerializedName("kato_analytics_options")
    @Expose
    private List<AnalyticsDatum> analyticsListData = null;
    @SerializedName("incomplete_template")
    @Expose
    private Integer incompleteTemplate;
    @SerializedName("is_verified")
    @Expose
    private Integer isVerified;

    public List<AnalyticsDatum> getAnalyticsListData() {
        return analyticsListData;
    }

    public void setAnalyticsListData(List<AnalyticsDatum> analyticsListData) {
        this.analyticsListData = analyticsListData;
    }

    public Long getMaxFileSize() {
        return maxFileSize;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public String getLineBeforeFeedback() {
        return lineBeforeFeedback;
    }

    public void setLineBeforeFeedback(String lineBeforeFeedback) {
        this.lineBeforeFeedback = lineBeforeFeedback;
    }

    public String getLineAfterFeedback1() {
        return lineAfterFeedback1;
    }

    public void setLineAfterFeedback1(String lineAfterFeedback1) {
        this.lineAfterFeedback1 = lineAfterFeedback1;
    }

    public String getLineAfterFeedback2() {
        return lineAfterFeedback2;
    }

    public void setLineAfterFeedback2(String lineAfterFeedback2) {
        this.lineAfterFeedback2 = lineAfterFeedback2;
    }

    public String getEnUserId() {
        return enUserId;
    }

    public void setEnUserId(String enUserId) {
        this.enUserId = enUserId;
    }

    public UserData() {
    }

    public ExpiryInfo getExpiryInfo() {
        return expiryInfo;
    }

    public void setExpiryInfo(ExpiryInfo expiryInfo) {
        this.expiryInfo = expiryInfo;
    }

    public UserProperties getUserProperties() {
        return userProperties;
    }

    public void setUserProperties(UserProperties userProperties) {
        this.userProperties = userProperties;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAppSecretKey() {
        return appSecretKey;
    }

    public void setAppSecretKey(String appSecretKey) {
        this.appSecretKey = appSecretKey;
    }

    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Integer getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Integer businessId) {
        this.businessId = businessId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getUserChannel() {
        return userChannel;
    }

    public void setUserChannel(String userChannel) {
        this.userChannel = userChannel;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<ChannelFilter> getChannelFilter() {
        return channelFilter;
    }

    public void setChannelFilter(List<ChannelFilter> channelFilter) {
        this.channelFilter = channelFilter;
    }

    public String getUserImage() {
        return userImage;
    }

    public void setUserImage(String userImage) {
        this.userImage = userImage;
    }

    public Integer getAgentType() {
        return agentType;
    }

    public void setAgentType(Integer agentType) {
        this.agentType = agentType;
    }

    public String getOnlineStatus() {
        return onlineStatus;
    }

    public void setOnlineStatus(String onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public BusinessProperty getBusinessProperty() {
        return businessProperty;
    }

    public void setBusinessProperty(BusinessProperty businessProperty) {
        this.businessProperty = businessProperty;
    }

    public Boolean getBillingPlan() {
        return billingPlan;
    }

    public void setBillingPlan(Boolean billingPlan) {
        this.billingPlan = billingPlan;
    }

    public Integer getIsBoardingComplete() {
        return isBoardingComplete;
    }

    public void setIsBoardingComplete(Integer isBoardingComplete) {
        this.isBoardingComplete = isBoardingComplete;
    }

    public Integer getIsBoardingSkip() {
        return isBoardingSkip;
    }

    public void setIsBoardingSkip(Integer isBoardingSkip) {
        this.isBoardingSkip = isBoardingSkip;
    }

    public Version getVersion() {
        return version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isTermsAndConditionReq() {
        return termsAndCondition != 1;
    }

    public void setTermsAndCondition(int termsAndCondition) {
        this.termsAndCondition = termsAndCondition;
    }

    public Integer getAgentOnboardingComplete() {
        return agentOnboardingComplete;
    }

    public void setAgentOnboardingComplete(Integer agentOnboardingComplete) {
        this.agentOnboardingComplete = agentOnboardingComplete;
    }

    public boolean isAgentOnboardingCompleted() {
        try {
            return agentOnboardingComplete != null && agentOnboardingComplete != 0;
        } catch (Exception e) {
            return false;
        }
    }


    public boolean isVideoCallEnabled() {
        try {
            return isVideoCallEnabled == 1;
        } catch (Exception e) {
            return false;
        }
    }

    public void setIsVideoCallEnabled(Integer isVideoCallEnabled) {
        this.isVideoCallEnabled = isVideoCallEnabled;
    }

    public boolean isAudioCallEnabled() {
        try {
            return isAudioCallEnabled == 1;
        } catch (Exception e) {
            return false;
        }
    }

    public void setisAudioCallEnabled(Integer isAudioCallEnabled) {
        this.isAudioCallEnabled = isAudioCallEnabled;
    }

    public boolean isIncompleteTemplate() {
        try {
            return incompleteTemplate == 1;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setIncompleteTemplate(Integer incompleteTemplate) {
        this.incompleteTemplate = incompleteTemplate;
    }

    public boolean isVerified() {
        try {
            return isVerified == 1;
        } catch (Exception e) {
            return true;
        }
    }

    public void setIsVerified(Integer isVerified) {
        this.isVerified = isVerified;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.userProperties, flags);
        dest.writeParcelable(this.expiryInfo, flags);
        dest.writeString(this.accessToken);
        dest.writeString(this.appSecretKey);
        dest.writeString(this.businessName);
        dest.writeValue(this.userId);
        dest.writeValue(this.businessId);
        dest.writeString(this.userName);
        dest.writeString(this.fullName);
        dest.writeString(this.email);
        dest.writeString(this.phoneNumber);
        dest.writeString(this.userChannel);
        dest.writeTypedList(this.tags);
        dest.writeTypedList(this.channelFilter);
        dest.writeString(this.userImage);
        dest.writeValue(this.agentType);
        dest.writeString(this.onlineStatus);
        dest.writeParcelable(this.businessProperty, flags);
        dest.writeValue(this.billingPlan);
        dest.writeValue(this.isBoardingComplete);
        dest.writeValue(this.isBoardingSkip);
        dest.writeValue(this.isVideoCallEnabled);
        dest.writeParcelable(this.version, flags);
        dest.writeValue(this.termsAndCondition);
        dest.writeValue(this.agentOnboardingComplete);
        dest.writeString(this.lineBeforeFeedback);
        dest.writeString(this.lineAfterFeedback1);
        dest.writeString(this.lineAfterFeedback2);
        dest.writeString(this.enUserId);
        dest.writeTypedList(this.analyticsListData);
    }

    protected UserData(Parcel in) {
        this.userProperties = in.readParcelable(UserProperties.class.getClassLoader());
        this.expiryInfo = in.readParcelable(ExpiryInfo.class.getClassLoader());
        this.accessToken = in.readString();
        this.appSecretKey = in.readString();
        this.businessName = in.readString();
        this.userId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.businessId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.userName = in.readString();
        this.fullName = in.readString();
        this.email = in.readString();
        this.phoneNumber = in.readString();
        this.userChannel = in.readString();
        this.tags = in.createTypedArrayList(Tag.CREATOR);
        this.channelFilter = in.createTypedArrayList(ChannelFilter.CREATOR);
        this.userImage = in.readString();
        this.agentType = (Integer) in.readValue(Integer.class.getClassLoader());
        this.onlineStatus = in.readString();
        this.businessProperty = in.readParcelable(BusinessProperty.class.getClassLoader());
        this.billingPlan = (Boolean) in.readValue(Boolean.class.getClassLoader());
        this.isBoardingComplete = (Integer) in.readValue(Integer.class.getClassLoader());
        this.isBoardingSkip = (Integer) in.readValue(Integer.class.getClassLoader());
        this.isVideoCallEnabled = (Integer) in.readValue(Integer.class.getClassLoader());
        this.version = in.readParcelable(Version.class.getClassLoader());
        this.termsAndCondition = (Integer) in.readValue(Integer.class.getClassLoader());
        this.agentOnboardingComplete = (Integer) in.readValue(Integer.class.getClassLoader());
        this.lineBeforeFeedback = in.readString();
        this.lineAfterFeedback1 = in.readString();
        this.lineAfterFeedback2 = in.readString();
        this.enUserId = in.readString();
//        this.analyticsListData = in.createTypedArrayList(AnalyticsDatum.CREATOR);

    }

    public static final Creator<UserData> CREATOR = new Creator<UserData>() {
        @Override
        public UserData createFromParcel(Parcel source) {
            return new UserData(source);
        }

        @Override
        public UserData[] newArray(int size) {
            return new UserData[size];
        }
    };
}
