package com.hippoagent.model.LoginResponse;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 24/04/19.
 *
 * @author gurmail
 */
public class ExpiryInfo implements Parcelable {

    @SerializedName("message")
    @Expose
    private String message;
    @SerializedName("expiry_date")
    @Expose
    private String expiryDate;
    @SerializedName("keep_showing")
    @Expose
    private Boolean keepShowing;
    @SerializedName("allow_card_detail")
    @Expose
    private Boolean allowCardDetail;
    @SerializedName("ask_card_details_only")
    @Expose
    private Integer askCardDetails;

    public final static Parcelable.Creator<ExpiryInfo> CREATOR = new Creator<ExpiryInfo>() {


        @SuppressWarnings({ "unchecked" })
        public ExpiryInfo createFromParcel(Parcel in) {
            return new ExpiryInfo(in);
        }

        public ExpiryInfo[] newArray(int size) {
            return (new ExpiryInfo[size]);
        }

    };

    protected ExpiryInfo(Parcel in) {
        this.message = ((String) in.readValue((String.class.getClassLoader())));
        this.expiryDate = ((String) in.readValue((String.class.getClassLoader())));
        this.keepShowing = ((Boolean) in.readValue((Boolean.class.getClassLoader())));
        this.allowCardDetail = ((Boolean) in.readValue((Boolean.class.getClassLoader())));
        this.askCardDetails = (Integer) in.readValue(Integer.class.getClassLoader());
    }

    public ExpiryInfo() {
    }

    public boolean isAskCardDetails() {
        return askCardDetails != null && askCardDetails == 1;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Boolean getKeepShowing() {
        return keepShowing;
    }

    public void setKeepShowing(Boolean keepShowing) {
        this.keepShowing = keepShowing;
    }

    public Boolean getAllowCardDetail() {
        return allowCardDetail;
    }

    public void setAllowCardDetail(Boolean allowCardDetail) {
        this.allowCardDetail = allowCardDetail;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(message);
        dest.writeValue(expiryDate);
        dest.writeValue(keepShowing);
        dest.writeValue(allowCardDetail);
        dest.writeValue(this.askCardDetails);
    }

    public int describeContents() {
        return 0;
    }

}