package com.hippoagent.fragments;


import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import androidx.fragment.app.Fragment;
import androidx.appcompat.widget.AppCompatImageView;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.OnResume;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.SwitchButton;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.UniqueIMEIID;
import com.google.gson.Gson;
import com.squareup.otto.Subscribe;


import io.paperdb.Paper;

/**
 * A simple {@link Fragment} subclass.
 */
public class ViewProfileFragment extends BaseFragment implements View.OnClickListener {
    private SwitchButton switchOnline;
    private TextView tvAgentName, logout, changePassword, broadcastChat, savedPlan, account;
    private ImageView ivUserImage;
    private AgentProfileDetails agentProfileDetails;
    private AppCompatImageView ivEdit;
    private TextView tvAgentStatus;
    //private View viewStatus;
    // TODO: 2019-12-30

    private CollapsingToolbarLayout collapsingToolbarLayout;
    private LinearLayout llToolbar;
    private AppBarLayout mAppBarLayout;


    public ViewProfileFragment() {
        // Required empty public constructor
    }

    public static ViewProfileFragment newInstance() {
        ViewProfileFragment fragment = new ViewProfileFragment();
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_view_profile, container, false);
        initViews(view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    private void initViews(View view) {
        tvAgentStatus = (TextView) view.findViewById(R.id.tvAgentStatus);
        tvAgentName = (TextView) view.findViewById(R.id.tvAgentName);
        switchOnline = view.findViewById(R.id.switchOnline);
        ivUserImage = view.findViewById(R.id.ivUserImage);
        changePassword = view.findViewById(R.id.changePassword);

        collapsingToolbarLayout = view.findViewById(R.id.collapsing_toolbar);
        llToolbar = view.findViewById(R.id.llToolbar);
        mAppBarLayout = view.findViewById(R.id.appbar);
        collapsingToolbarLayout.setTitle("");

        changePassword.setOnClickListener(this);
        broadcastChat = view.findViewById(R.id.broadcastChat);
        broadcastChat.setOnClickListener(this);
        savedPlan = view.findViewById(R.id.savedPlan);
        savedPlan.setOnClickListener(this);
        ivEdit = view.findViewById(R.id.ivEdit);
        ivEdit.setOnClickListener(this);
        logout = view.findViewById(R.id.logout);
        logout.setOnClickListener(this);
        account = view.findViewById(R.id.account);
        account.setOnClickListener(this);

        savedPlan.setVisibility(View.GONE);
        try {
            if(MyApplication.getInstance().getUserData().getAgentType().intValue() == 11) {
                broadcastChat.setVisibility(View.GONE);
            }
            if(MyApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed())
                savedPlan.setVisibility(View.VISIBLE);
        } catch (Exception e) {
            e.printStackTrace();
        }


        llToolbar.setVisibility(View.GONE);
        mAppBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener() {
            int scrollRange = -1;
            boolean isShow = false;
            @Override
            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (scrollRange == -1) {
                    scrollRange = appBarLayout.getTotalScrollRange();
                }
                if (scrollRange + verticalOffset == 0) {
                    isShow = true;
                    llToolbar.setVisibility(View.VISIBLE);
                } else if (isShow) {
                    isShow = false;
                    llToolbar.setVisibility(View.GONE);
                }
            }
        });

        setAgentData();
        switchOnline.setOnCheckedChangeListener(new SwitchButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(SwitchButton compoundButton, boolean b) {
                if (true) {
                    if (isNetworkAvailable()) {
                        setAgentOnlineStatus();
                        //switchOnline.getTrackDrawable().setColorFilter(ContextCompat.getColor(getActivity(), b ? R.color.tag_color : R.color.overlay_yellow_95), PorterDuff.Mode.SRC_IN);
                    } else {
                        Toast.makeText(getActivity(), getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                        if (b) {
                            switchOnline.updateStatus(false);
                        } else {
                            switchOnline.updateStatus(true);
                        }
                    }
                }
            }
        });
        if (MyApplication.getInstance().getUserData().getOnlineStatus().equals(FuguAppConstant.AVAILABLE)) {
            switchOnline.updateStatus(true);
            tvAgentStatus.setText(R.string.available);
        } else if (MyApplication.getInstance().getUserData().getOnlineStatus().equals(FuguAppConstant.AWAY)) {
            switchOnline.updateStatus(false);
            tvAgentStatus.setText(R.string.away);
        } else {
            switchOnline.updateStatus(false);
            tvAgentStatus.setText(R.string.offline);
        }

    }

    @Subscribe
    public void onFragmentEvent(FragmentEvent fragmentEvent) {
        if(fragmentEvent.fragmentType != 2)
            return;
        switch (fragmentEvent.dataType) {
            case 1:
                boolean flag = (boolean) fragmentEvent.object;
                if(flag) {
                    // Available
                    switchOnline.updateStatus(true);
                    updateStatus();
                } else {
                    // Away
                    switchOnline.updateStatus(false);
                    updateStatus();
                }
                break;
            case 2:
                setAgentData();
            default:

                break;
        }
    }

    private void updateStatus() {
        if (MyApplication.getInstance().getUserData().getOnlineStatus().equals(FuguAppConstant.AVAILABLE)) {
            //switchOnline.updateStatus(true);
            tvAgentStatus.setText(R.string.available);
        } else if (MyApplication.getInstance().getUserData().getOnlineStatus().equals(FuguAppConstant.AWAY)) {
            //switchOnline.updateStatus(false);
            tvAgentStatus.setText(R.string.away);
        } else {
            //switchOnline.updateStatus(false);
            tvAgentStatus.setText(R.string.offline);
        }
    }

    private void setAgentOnlineStatus() {
        MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
        MultipartParams multipartParams;
        multipartParams = multipartBuilder
                .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().getUserData().getAccessToken())
                .add(Constants.EN_USER_ID, MyApplication.getInstance().getUserData().getEnUserId())
                .add(Constants.AGENT_TYPE, String.valueOf(MyApplication.getInstance().getUserData().getAgentType()))
                .add(Constants.BUSINESS_ID, String.valueOf(MyApplication.getInstance().getUserData().getBusinessId()))
                .add("device_id", UniqueIMEIID.getUniqueIMEIId(getActivity()))
                .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                .add(Constants.ONLINE_STATUS, switchOnline.isChecked() ? FuguAppConstant.AVAILABLE : FuguAppConstant.AWAY).build();

        String value = new Gson().toJson(multipartParams.getMap());
        Logger.INSTANCE.apiRequest("/api/agent/editInfo", value);

        RestClient.getApiInterface().editAgentInfo(multipartParams.getMap())
                .enqueue(new ResponseResolver<EditProfileResponse>(getActivity(), true, false) {
                    @Override
                    public void success(EditProfileResponse editProfileResponse) {
                        Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                        try {
                            if (switchOnline.isChecked()) {
                                MyApplication.getInstance().getUserData().setOnlineStatus(FuguAppConstant.AVAILABLE);
                                //MyApplication.getInstance().trackEvent(GAEvents.PRO_SCREEN, GAEvents.STATUS_CLICKED, "status_available");
                                BusProvider.getInstance().post(new FragmentEvent(1, 1, true));
                            } else {
                                MyApplication.getInstance().getUserData().setOnlineStatus(FuguAppConstant.AWAY);
                                //MyApplication.getInstance().trackEvent(GAEvents.PRO_SCREEN, GAEvents.STATUS_CLICKED, "status_away");
                                BusProvider.getInstance().post(new FragmentEvent(1, 1, false));
                            }
                            updateStatus();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                        Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                        switchOnline.updateStatus(!switchOnline.isChecked());
                    }

                });
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.tvEditProfile) {//MyApplication.getInstance().trackEvent(PRO_SCREEN, EDIT_BTN_CLICKED, "edit_profile_clicked");
            EditProfileFragment editProfileFragment = new EditProfileFragment();
            Bundle bundle = new Bundle();
            bundle.putParcelable("agentData", agentProfileDetails);
            editProfileFragment.setArguments(bundle);
            //((ProfileActivity) getActivity()).setClickBool(true, false);
            getActivity().getSupportFragmentManager().beginTransaction()
                    .setCustomAnimations(
                            R.anim.anim_slide_in_left, R.anim.anim_slide_out_left,
                            R.anim.anim_slide_in_right, R.anim.anim_slide_out_right)
                    .add(R.id.llContainer, editProfileFragment, EditProfileFragment.class.getName())
                    .commit();
        } else if (id == R.id.changePassword) {//MyApplication.getInstance().trackEvent(PRO_SCREEN, CHANGE_PASS_BTN, "change_password_clicked");
            //((ProfileActivity) getActivity()).setClickBool(true, true);
//                getActivity().getSupportFragmentManager().beginTransaction()
//                        .setCustomAnimations(
//                                R.anim.anim_slide_in_left, R.anim.anim_slide_out_left,
//                                R.anim.anim_slide_in_right, R.anim.anim_slide_out_right)
//                        .add(R.id.llContainer, ChangePasswordFragment.newInstance(), ChangePasswordFragment.class.getName())
//                        .commit();

            Intent profile = new Intent(getActivity(), ProfileActivityName.class);
            profile.putExtra("fragment_type", 1);
            startActivity(profile);
        } else if (id == R.id.broadcastChat) {
            startActivity(new Intent(getActivity(), BroadcastListActivity.class));
        } else if (id == R.id.savedPlan) {
            Intent planIntent = new Intent(getActivity(), PlansActivity.class);
            startActivity(planIntent);
        } else if (id == R.id.ivEdit) {
            Intent profileEdit = new Intent(getActivity(), ProfileActivityName.class);
            profileEdit.putExtra("isEditable", true);
            startActivity(profileEdit);
        } else if (id == R.id.account) {
            startActivity(new Intent(getActivity(), ProfileActivityName.class));
        } else if (id == R.id.logout) {
            performLogout();
        }
    }

    private void setAgentData() {

        try {
            agentProfileDetails = MyApplication.getInstance().getAgentProfileDetails();
            tvAgentName.setText(agentProfileDetails.getData().getFullName());
            Log.e("TAG", "URL = "+agentProfileDetails.getData().getUserImage());
            LoadImageFile.getInstance().loadImage(getActivity(), agentProfileDetails.getData().getUserImage(), ivUserImage);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onActivityResume(OnResume onResume) {
        setAgentData();
    }

    @Override
    public void onResume() {
        super.onResume();

    }

    private void performLogout() {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton(getActivity(), "", getResources().getString(R.string.logout_message)
                , getResources().getString(R.string.logout_caps)
                , getResources().getString(R.string.cancel), new DialogPop.Callback() {
                    @Override
                    public void onPositiveClick() {
                        apiLogout();
                    }

                    @Override
                    public void onNegativeClick() {

                    }
                });
    }

    private void apiLogout() {
        if (isNetworkAvailable()) {
            Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().getUserData().getAccessToken())
                    .add(Constants.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(getActivity()))
                    .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                    .build();
            Logger.INSTANCE.apiRequest("/api/agent/agentLogout", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().logout(commonParams.getMap())
                    .enqueue(new ResponseResolver<LoginResponse>(getActivity(), true, true) {
                        @Override
                        public void success(LoginResponse loginResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/agentLogout", "");
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
                                    MyApplication.getInstance().logout(getActivity());
                                }
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/agent/agentLogout", e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/agentLogout", error.getMessage());
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(getActivity(), getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }


}
