package com.hippoagent.fragments;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.databinding.FragmentTypeBinding;
import com.hippoagent.model.Filter;

import java.util.ArrayList;

import static androidx.databinding.DataBindingUtil.inflate;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class TypeFragment extends Fragment {

    private static final String TAG = TypeFragment.class.getSimpleName();
    private FragmentTypeBinding fragmentBinding;
    public ArrayList<Filter> chatType = new ArrayList<>();
    private FilterActivity activity;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
         fragmentBinding = inflate(inflater, R.layout.fragment_type,
                container, false);
        View view = fragmentBinding.getRoot();
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = (FilterActivity) getActivity();
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        chatType = activity.getFilterModel().getTypeArrayList();

        fragmentBinding.cbMyChat.setChecked(chatType.get(0).getChecked());
        fragmentBinding.cbUnassigned.setChecked(chatType.get(1).getChecked());
        fragmentBinding.cbTagged.setChecked(chatType.get(2).getChecked());

        if(activity.isAllChat()) {
            fragmentBinding.cbMyChat.setVisibility(View.GONE);
            fragmentBinding.cbTagged.setVisibility(View.GONE);
        }

        fragmentBinding.cbMyChat.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(compoundButton.isPressed()) {
                    chatType.get(0).setChecked(b);
                }
            }
        });
        fragmentBinding.cbUnassigned.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(compoundButton.isPressed()) {
                    chatType.get(1).setChecked(b);
                }
            }
        });
        fragmentBinding.cbTagged.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(compoundButton.isPressed()) {
                    chatType.get(2).setChecked(b);
                }
            }
        });

    }
}
