package com.hippoagent.fragments;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.PeopleAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.conversation_search.ConversationSearchResponse;
import com.hippoagent.model.conversation_search.User;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.HashMap;

import static androidx.databinding.DataBindingUtil.inflate;
import static com.hippoagent.utils.SearchViewNetworkQueryHelper.SearchCallbacks;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class PeopleFragment extends Fragment implements SearchCallbacks, PeopleAdapter.PeopleClickListener {

    private static final String TAG = PeopleFragment.class.getSimpleName();
    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private PeopleAdapter peopleAdapter;
    public ArrayList<User> peopleSearched = new ArrayList<>();
    private FragmentPeopleBinding fragmentBinding;
    private FilterActivity activity;

    private Integer totalUser = 0;
    private static final String endIndex = "10";

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        fragmentBinding = inflate(inflater, R.layout.fragment_people,
                container, false);
        View view = fragmentBinding.getRoot();
        initView();
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(fragmentBinding.searchView, this);
        mSearchNetworkQueryHelper.setSuggestCountThreshold(3);
        mSearchNetworkQueryHelper.setSuggestWaitThreshold(400);

        peopleAdapter = new PeopleAdapter(peopleSearched, this);
        fragmentBinding.searchList.setAdapter(peopleAdapter);
    }

    private void initView() {
        FilterModel filterModel = activity.getFilterModel();
        if(!TextUtils.isEmpty(filterModel.getSelectedPeople())) {
            fragmentBinding.rlSelectedPeople.setVisibility(View.VISIBLE);
            fragmentBinding.tvSelectedPeople.setText(filterModel.getSelectedPeople());
        }

        fragmentBinding.noDataFound.setText("No user found.");
        fragmentBinding.ibRemoveSelectedPeople.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activity.resetFilter();
            }
        });
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = (FilterActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
    }

    @Override
    public void showLoader() {

    }

    @Override
    public void performQuery(String query) {
        fragmentBinding.progressBarSearch.setVisibility(View.VISIBLE);
        fragmentBinding.progressBarSearch.spin();
        getSearchedPeople(query, "0", endIndex, true, false);
    }

    @Override
    public void showAllData() {
        peopleSearched.clear();
        peopleAdapter.setData(peopleSearched, totalUser == null ? 0 : totalUser);

        fragmentBinding.noDataFound.setVisibility(View.GONE);
        fragmentBinding.searchList.setVisibility(View.VISIBLE);

        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
    }

    private void getSearchedPeople(String query, String startIndex, String endIndex, final boolean isClearData, final boolean showLoading) {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("search_text", query);
        params.put("is_my_chat", activity.isAllChat() ? "0" : "1");
        params.put("channel_start", "0");
        params.put("channel_end", "0");
        params.put("user_start", startIndex);
        params.put("user_end", endIndex);

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("api/v2/conversation/search", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().conversationSearch(commonParams.getMap())
                .enqueue(new ResponseResolver<ConversationSearchResponse>(getActivity(), showLoading, true) {
                    @Override
                    public void success(ConversationSearchResponse conversationSearchResponse) {
                        Logger.INSTANCE.apiResponse("api/v2/conversation/search", "");
                        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
                        if (isClearData)
                            peopleSearched.clear();

                        peopleSearched.addAll(conversationSearchResponse.getData().getUsers());
                        totalUser = conversationSearchResponse.getData().getTotalUsers();
                        peopleAdapter.setData(peopleSearched, totalUser == null ? 0 : totalUser);
                        if(peopleSearched.size() == 0) {
                            fragmentBinding.noDataFound.setVisibility(View.VISIBLE);
                            fragmentBinding.searchList.setVisibility(View.GONE);
                        } else {
                            fragmentBinding.noDataFound.setVisibility(View.GONE);
                            fragmentBinding.searchList.setVisibility(View.VISIBLE);
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("api/v2/conversation/search", error.getMessage());
                        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
                    }

                });
    }

    @Override
    public void onItemClick(User datum) {
        activity.getFilterModel().setSelectedPeopleUserId(datum.getUserId().toString());
        activity.getFilterModel().setSelectedPeople(TextUtils.isEmpty(datum.getEmail()) ? datum.getFullName() : datum.getEmail());
        activity.getFilterModel().setViewType(1);

        activity.getFilterModel().setSearchCustomName("");
        activity.getFilterModel().setSearchCustomLabel(-1);
        activity.getFilterModel().setConversation(null);

        for (int i = 0; i < activity.getFilterModel().getChannelList().size(); i++) {
            activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }

        for (int i = 0; i < activity.getFilterModel().getLabelsList().size(); i++) {
            activity.getFilterModel().getLabelsList().get(i).setChecked(false);
        }

        for (int i = 0; i < activity.getFilterModel().getTypeArrayList().size(); i++) {
            activity.getFilterModel().getTypeArrayList().get(i).setChecked(false);
        }

        activity.getFilterModel().getStatusArrayList().get(0).setChecked(true);
        activity.getFilterModel().getStatusArrayList().get(1).setChecked(false);

        activity.applyFilterData();
    }

    @Override
    public void onNewChatClick(Conversation conversation) {
        activity.getFilterModel().setViewType(2);
        activity.getFilterModel().setConversation(conversation);

        activity.getFilterModel().setSelectedPeopleUserId("-1");
        activity.getFilterModel().setSelectedPeople("");

        activity.getFilterModel().setSearchCustomName("");
        activity.getFilterModel().setSearchCustomLabel(-1);

        for (int i = 0; i < activity.getFilterModel().getChannelList().size(); i++) {
            activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }

        for (int i = 0; i < activity.getFilterModel().getLabelsList().size(); i++) {
            activity.getFilterModel().getLabelsList().get(i).setChecked(false);
        }

        for (int i = 0; i < activity.getFilterModel().getTypeArrayList().size(); i++) {
            activity.getFilterModel().getTypeArrayList().get(i).setChecked(false);
        }

        activity.getFilterModel().getStatusArrayList().get(0).setChecked(true);
        activity.getFilterModel().getStatusArrayList().get(1).setChecked(false);


        activity.applyFilterData();
    }

    @Override
    public void onLoadMoreClick() {
        String startIndex = Integer.toString(peopleSearched.size());
        getSearchedPeople(fragmentBinding.searchView.getText().toString().trim(), startIndex, endIndex, false, true);
    }
}
