package com.hippoagent.fragments

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.activities.DatabaseLogs
import com.hippoagent.model.FilePath
import java.io.File

/**
 * Created by gurmail on 21/05/19.
 * @author gurmail
 */
class LoggerFragment : androidx.fragment.app.Fragment() {

    var activity: DatabaseLogs? = null
    private var KEY = "/logs"
    private val fileName = "${File.separator}logs.txt"
    private var fileInfo = ArrayList<FilePath>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            if(arguments!!.getInt("type", 1) == 1) {
                KEY = "/logs"
            } else {
                KEY = "/io.paperdb"
            }
        }

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.conversation_fragment, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        fetchLogger()
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        activity = context as DatabaseLogs?
    }

    override fun onDetach() {
        super.onDetach()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)

    }

    fun fetchLogger() {
        val path: String = activity?.getFilesDir()!!.path + KEY
        val folder = File(path)
        val listOfFiles = folder.listFiles()

        fileInfo.clear()
        for (i in listOfFiles!!.indices) {
            if (listOfFiles[i].isFile) {
                fileInfo.add(FilePath(path, listOfFiles[i].name, 0))
                //println("File " + listOfFiles[i].name)
            } else if (listOfFiles[i].isDirectory) {
                println("Directory " + listOfFiles[i].name)
            }
        }

        fileInfo.let {

        }

    }


}