package com.hippoagent.fragments;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.LabelsAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.model.Filter;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;

import java.util.ArrayList;

import static androidx.databinding.DataBindingUtil.inflate;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class LablesFragment extends Fragment implements SearchViewNetworkQueryHelper.SearchCallbacks {

    private static final String TAG = LablesFragment.class.getSimpleName();
    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private FragmentPeopleBinding fragmentBinding;

    private ArrayList<Filter> tagsArrayList = new ArrayList<>();
    private ArrayList<Filter> tempTagsArrayList = new ArrayList<>();
    private LabelsAdapter labelsAdapter;

    private FilterActivity activity;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        fragmentBinding = inflate(inflater, R.layout.fragment_people,
                container, false);
        View view = fragmentBinding.getRoot();

        tagsArrayList.addAll(activity.getFilterModel().getLabelsList());
        tempTagsArrayList.addAll(tagsArrayList);

        labelsAdapter = new LabelsAdapter(tagsArrayList);
        fragmentBinding.searchList.setAdapter(labelsAdapter);


        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(fragmentBinding.searchView, this);
        mSearchNetworkQueryHelper.setSuggestCountThreshold(2);
        mSearchNetworkQueryHelper.setSuggestWaitThreshold(100);

        /*tagsArrayList.addAll(activity.getFilterModel().getLabelsList());
        tempTagsArrayList.addAll(tagsArrayList);

        labelsAdapter = new LabelsAdapter(tagsArrayList);
        fragmentBinding.searchList.setAdapter(labelsAdapter);*/
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = (FilterActivity) getActivity();
    }


    @Override
    public void showLoader() {

    }

    @Override
    public void performQuery(String query) {
        tempTagsArrayList.clear();
        for (Filter filter : tagsArrayList) {
            if (filter.getName().toLowerCase().contains(query.toLowerCase())) {
                tempTagsArrayList.add(filter);
            }
        }
        labelsAdapter.setData(tempTagsArrayList);

        if(tempTagsArrayList.size() == 0) {
            fragmentBinding.noDataFound.setVisibility(View.VISIBLE);
            fragmentBinding.searchList.setVisibility(View.GONE);
        } else {
            fragmentBinding.noDataFound.setVisibility(View.GONE);
            fragmentBinding.searchList.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void showAllData() {
        labelsAdapter.setData(tagsArrayList);

        fragmentBinding.noDataFound.setVisibility(View.GONE);
        fragmentBinding.searchList.setVisibility(View.VISIBLE);
    }
}
