package com.hippoagent.fragments

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.PorterDuff
import android.graphics.Typeface
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.os.Bundle
import android.os.Handler
import com.google.android.material.tabs.TabLayout
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CompoundButton
import android.widget.RelativeLayout
import android.widget.TextView
import android.widget.Toast
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.activities.FilterActivity
import com.hippoagent.datastructure.AgentType
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.MessageMode
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.eventbus.FilterEvent
import com.hippoagent.eventbus.FragmentEvent
import com.hippoagent.helper.ConversationApiHelper
import com.hippoagent.model.EditProfileResponse
import com.hippoagent.model.FilterModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.MultipartParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.GAEvents
import com.hippoagent.utils.UniqueIMEIID
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.fragment_web_pager.*

/**
 * Created by gurmail on 2019-12-29.
 * @author gurmail
 */
class HomePagerFragment: androidx.fragment.app.Fragment(), androidx.viewpager.widget.ViewPager.OnPageChangeListener {

    companion object {
        fun newInstance() = HomePagerFragment()
    }

    override fun onPageScrollStateChanged(position: Int) {

    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
        var title = ""
        when (position) {
            0 -> {
                title = "My Chats"
                filter.visibility = View.VISIBLE
                isAllChatClicked = false
                if(isMyChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            1 -> {
                title = "All Chats"
                filter.visibility = View.VISIBLE
                isAllChatClicked = true
                if(isAllChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            2 -> {
                title = "P2P Chats"
                filter.visibility = View.GONE
                isAllChatClicked = false
            }
        }
        tvUserName2.text = title
    }

    override fun onPageSelected(position: Int) {

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_web_pager, container, false)
    }

    var itemCount: Int = 1
    private var isAllChatClicked = false
    private var isMyChatFilter = false
    private var isAllChatFilter = false

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        tvUserName2.text = "My Chats"

        try {
            try {
                if (!MyApplication.getInstance().userData.businessProperty.hideAllChatTab() || MyApplication.getInstance().userData.agentType == AgentType.ADMIN.getOrdinal()) {
                    itemCount += 1
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }

            if (MyApplication.getInstance().userData.businessProperty.p2pEnabled != null && MyApplication.getInstance().userData.businessProperty.p2pEnabled!!.toInt() == 1) {
                itemCount += 1
            }
        } catch (e: Exception) {

        }


        ConversationApiHelper().getAgentData()

        val adapter = SavedPager(childFragmentManager)
        pagerView.adapter = adapter
        pagerView.offscreenPageLimit = itemCount
        pagerView.setPagingEnabled(true)
        pagerView.addOnPageChangeListener(this)
        tabs.setupWithViewPager(pagerView)

        filter.visibility = View.VISIBLE
        switchOnline.visibility = View.VISIBLE


        if(itemCount < 2) {
            tabs.visibility = View.GONE
        }

        changeTabsFont()

        ConversationApiHelper().apiGetAgents()
        status()

        //setFilterAdapter()
        filter.setOnClickListener {

            var selectedData = Gson().toJson(myChatFilterModel)
            if(isAllChatClicked)
                selectedData = Gson().toJson(allChatFilterModel)


            //BusProvider.getInstance().post()

            val intent = Intent(activity, FilterActivity::class.java)
            intent.putExtra("filterData", selectedData)
            intent.putExtra("isAllChat", isAllChatClicked)
            startActivityForResult(intent, 200)
        }
    }

    private fun status() {
        switchOnline.setOnCheckedChangeListener { button, flag ->
            if(button.isPressed) {
                if (isNetworkAvailable()) {
                    setAgentOnlineStatus()
                } else {
                    Toast.makeText(activity, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
                    switchOnline.isChecked = !flag
                }
            }
        }
    }

    internal var activity: Activity? = null

    override fun onAttach(context: Context) {
        super.onAttach(context)
        if (context is Activity) {
            activity = context
        }
    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this)
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this)
    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onResume() {
        super.onResume()
        checkOnlineStatus()
    }

    inner class SavedPager(private val fm: androidx.fragment.app.FragmentManager): androidx.fragment.app.FragmentStatePagerAdapter(fm) {
        override fun getItem(position: Int): androidx.fragment.app.Fragment {
            val savedFragment = HomeFragment()
            val bundle = Bundle()
            val messageMod = MessageMode.OPEN_CHAT.getOrdinal()
            bundle.putInt("position", position)
            bundle.putInt("selectedMode", messageMod)
            bundle.putString("param2", "")

            savedFragment.arguments = bundle
            return savedFragment
        }

        override fun getPageTitle(position: Int): CharSequence? {
            var title: String? = null
            when (position) {
                0 -> title = "My Chats"
                1 -> title = "All Chats"
                2 -> title = "P2P Chats"
            }
            return title
        }

        override fun getCount(): Int {
            return itemCount
        }

    }

    private fun changeTabsFont() {
        try {
            val font = Typeface.createFromAsset(context?.assets, "fonts/TitilliumWeb-SemiBold")
            val vg = tabs.getChildAt(0) as ViewGroup
            val tabsCount = vg.childCount
            for (j in 0 until tabsCount)
            {
                val vgTab = vg.getChildAt(j) as ViewGroup
                val tabChildsCount = vgTab.childCount
                for (i in 0 until tabChildsCount)
                {
                    val tabViewChild = vgTab.getChildAt(i)
                    if (tabViewChild is TextView)
                    {
                        (tabViewChild as TextView).typeface = font
                    }
                }
            }
        } catch (e: Exception) {
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK) {
            when (requestCode) {
                200 -> {
                    val filterType: Int = if(isAllChatClicked) 1 else 0
                    Handler().postDelayed(Runnable {
                        BusProvider.getInstance().post(FilterEvent(filterType, data))
                    }, 50)


                    if(isAllChatClicked)
                        allChatFilterModel = Gson().fromJson(data!!.getStringExtra("filterData"), FilterModel::class.java)
                    else
                        myChatFilterModel = Gson().fromJson(data!!.getStringExtra("filterData"), FilterModel::class.java)

                    /*isFromFilter = true
                    filterModel = Gson().fromJson(data!!.getStringExtra("filterData"), FilterModel::class.java)

                    when (filterModel?.viewType) {
                        0 -> {
                            loadmore = true
                            selectedPeopleUserId = null
                            selectedPeople = null
                            applyFilter(filterModel!!)
                            filter.setImageResource(R.drawable.ic_filter_unslected)
                            try {
                                Handler().postDelayed({ isFromFilter = false }, 1000)
                            } catch (e: Exception) {

                            }

                        }
                        1 -> {
                            loadmore = true
                            selectPeopleItem()
                            filter.setImageResource(R.drawable.ic_filter)
                        }
                        2 -> {
                            loadmore = true
                            Handler().postDelayed({
                                val chatIntent = Intent(activity, FuguChatActivity::class.java)
                                chatIntent.putExtra(Constants.CONVERSATION, Gson().toJson(filterModel?.conversation, Conversation::class.java))
                                startActivityForResult(chatIntent, 100)
                                //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.CHAT_CLICKED, "conversation_clicked")
                                isFromFilter = false
                                filter.setImageResource(R.drawable.ic_filter_unslected)
                            }, 50)
                        }
                        else -> {
                            loadmore = true
                            applyFilter(filterModel!!)
                            filter.setImageResource(R.drawable.ic_filter)
                        }
                    }*/
                }
                else -> {
                }
            }
        }
    }

    /*private fun selectPeopleItem() {
        selectedPeopleUserId = null
        selectedPeopleUserId = filterModel?.selectedPeopleUserId
        var customLabel: String? = null
        if (filterModel?.searchCustomLabel!! > 0)
            customLabel = Integer.toString(filterModel?.searchCustomLabel!!)
        val filterType: Int = if(isAllChatClicked) 1 else 0
        BusProvider.getInstance().post(FilterEvent(filterType, selectedPeopleUserId, MyApplication.getInstance().userData.userId.toString(),
                getStatusFilter(), getTypeFilter(), getLabelsFilter(), 0, false, true, true, getChannelFilter(), customLabel, filterModel))
        selectedPeople = null
        selectedPeople = filterModel?.selectedPeople
    }

    private fun applyFilter(filterModel: FilterModel) {
        var customLabel: String? = null
        if (filterModel.searchCustomLabel > 0)
            customLabel = Integer.toString(filterModel.searchCustomLabel)

        var searchUserId = MyApplication.getInstance().userData.userId.toString()
        if (!TextUtils.isEmpty(selectedPeopleUserId))
            searchUserId = selectedPeopleUserId!!

        val filterType: Int = if(isAllChatClicked) 1 else 0

        Handler().postDelayed(Runnable {
            BusProvider.getInstance().post(FilterEvent(filterType, searchUserId, MyApplication.getInstance().userData.userId.toString(),
                    getStatusFilter(), getTypeFilter(), getLabelsFilter(), 0, false, true, true, getChannelFilter(), customLabel, filterModel))
        }, 50)
    }*/

//    private var filterModel: FilterModel? = null

    private var myChatFilterModel: FilterModel? = null
    private var allChatFilterModel: FilterModel? = null


//    var isFromFilter: Boolean = false
//    var labels = ArrayList<Tag>()
//    var selectedPeople: String? = null
//    var selectedPeopleUserId: String? = null
//
//    var loadmore = true

    /*private fun setFilterAdapter() {

        isFromFilter = false
        labels = ArrayList<Tag>()
        labels = MyApplication.getInstance().userData.tags as ArrayList<Tag>

        filterModel = FilterModel()

        filterModel?.agentList = ArrayList()

        for (i in 0..1) {
            val filter = Filter()
            if (i == 0) {
                filter.id = 1
                filter.name = "Open Chats"
                filter.checked = true
            } else {
                filter.id = 2
                filter.name = "Closed Chats"
                filter.checked = false
            }
            filterModel?.statusArrayList?.add(filter)
        }


        for (i in 0..2) {
            val filter = Filter()
            if (i == 0) {
                filter.id = 1
                filter.name = "My Chats"
                filter.checked = false
            } else if (i == 1) {
                filter.id = 2
                filter.name = "Unassigned"
                filter.checked = false
            } else {
                filter.id = 3
                filter.name = "Tagged"
                filter.checked = false
            }
            filterModel?.typeArrayList?.add(filter)
        }


        //labelView
        for (i in labels.indices) {
            val filter = Filter()
            filter.id = labels[i].tagId!!
            filter.name = labels[i].tagName
            filter.checked = false
            filterModel?.labelsList?.add(filter)
        }

        val channelFilters = ArrayList<ChannelFilter>()
        channelFilters.addAll(MyApplication.getInstance().userData.channelFilter)

        for (i in channelFilters.indices) {
            val filter = Filter()
            filter.id = channelFilters[i].id!!
            filter.name = channelFilters[i].name
            filter.checked = false
            filterModel?.channelList?.add(filter)
        }

        filterModel?.selectedPeople = ""
        filterModel?.selectedPeopleUserId = ""

        filterModel?.searchCustomName = ""
        filterModel?.searchCustomLabel = -1
        try {
            //TODO: 2019-12-30
            //getHomeFragment().filerIcon.setIcon(activity?.let { ContextCompat.getDrawable(it, R.drawable.ic_filter_unslected) })
        } catch (e: Exception) {

        }

    }*/

    private fun isNetworkAvailable(): Boolean {
        val cm = activity!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        var networkInfo: NetworkInfo? = null
        if (cm != null) {
            networkInfo = cm.activeNetworkInfo
        }
        return networkInfo != null && networkInfo.isConnected
    }

    @Subscribe
    fun onFragmentEvent(fragmentEvent: FragmentEvent) {
        if (fragmentEvent.fragmentType != 1)
            return
        when (fragmentEvent.dataType) {
            1 -> {
                checkOnlineStatus()
                val flag = fragmentEvent.`object` as Boolean
                if (flag) {
                    // Available

                } else {
                    // Away

                }
            }
            2 -> {
                myChatFilterModel = fragmentEvent.`object` as FilterModel?
            }
            3 -> {
                allChatFilterModel = fragmentEvent.`object` as FilterModel?
            }
            4 -> {
                isMyChatFilter = fragmentEvent.`object` as Boolean
                if(!isAllChatClicked && isMyChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            5 -> {
                isAllChatFilter = fragmentEvent.`object` as Boolean
                if(isAllChatClicked && isAllChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            else -> {
            }
        }
    }

    private fun checkOnlineStatus() {
        try {
            switchOnline.updateStatus(MyApplication.getInstance().userData.onlineStatus == FuguAppConstant.AVAILABLE)
        } catch (e: Exception) {
            e.printStackTrace()
            getActivity()!!.runOnUiThread {
                switchOnline.updateStatus(MyApplication.getInstance().userData.onlineStatus == FuguAppConstant.AVAILABLE)
            }
        }

    }

    private fun setAgentOnlineStatus() {
        val multipartBuilder = MultipartParams.Builder()
        val multipartParams: MultipartParams
        multipartParams = multipartBuilder
                .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().userData.accessToken)
                .add(Constants.EN_USER_ID, MyApplication.getInstance().userData.enUserId)
                .add(Constants.AGENT_TYPE, MyApplication.getInstance().userData.agentType.toString())
                .add(Constants.BUSINESS_ID, MyApplication.getInstance().userData.businessId.toString())
                .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                .add("device_id", UniqueIMEIID.getUniqueIMEIId(activity))
                .add(Constants.ONLINE_STATUS, if (switchOnline.isChecked) FuguAppConstant.AVAILABLE else FuguAppConstant.AWAY).build()

        val value = Gson().toJson(multipartParams.map)
        Logger.apiRequest("/api/agent/editInfo", value)

        RestClient.getApiInterface().editAgentInfo(multipartParams.map)
                .enqueue(object : ResponseResolver<EditProfileResponse>(activity, false, true) {
                    override fun success(editProfileResponse: EditProfileResponse) {
                        Logger.apiResponse("/api/agent/editInfo", "")
                        if (switchOnline.isChecked) {
                            MyApplication.getInstance().userData.onlineStatus = FuguAppConstant.AVAILABLE
                            //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.STATUS_CLICKED, "status_available_home")
                            MyApplication.getInstance().userData.onlineStatus = FuguAppConstant.AVAILABLE
                            BusProvider.getInstance().post(FragmentEvent(2, 1, true))
                        } else {
                            MyApplication.getInstance().userData.onlineStatus = FuguAppConstant.AWAY
                            BusProvider.getInstance().post(FragmentEvent(2, 1, false))
                        }
                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("/api/agent/editInfo", error.message)
                        Toast.makeText(activity, error.message, Toast.LENGTH_SHORT).show()
                        checkOnlineStatus()
                    }

                })
    }

    /*private var statusIntArray = intArrayOf(MessageMode.OPEN_CHAT.getOrdinal())
    private var typeIntArray = intArrayOf(ConversationMode.DEFAULT.getOrdinal())
    private var labelsIntArray = intArrayOf()
    private var channelsIntArray = intArrayOf()

    private fun getStatusFilter(): IntArray {
        val statusArrayList = ArrayList<Int>()
        if (filterModel?.statusArrayList!![0].checked) {
            statusArrayList.add(MessageMode.OPEN_CHAT.getOrdinal())
        }
        if (filterModel?.statusArrayList!![1].checked) {
            statusArrayList.add(MessageMode.CLOSED_CHAT.getOrdinal())
        }
        statusArrayList.run {
            if (filterModel?.statusArrayList!![0].checked) {
            statusArrayList.add(MessageMode.OPEN_CHAT.getOrdinal())
        }
            if (filterModel?.statusArrayList!![1].checked) {
            statusArrayList.add(MessageMode.CLOSED_CHAT.getOrdinal())
        }
            sort()
        }
        statusIntArray = IntArray(statusArrayList.size)
        for (i in statusIntArray.indices) {
            statusIntArray[i] = statusArrayList[i]
        }
        return statusIntArray
    }

    private fun getTypeFilter(): IntArray {
        val typeArrayList = ArrayList<Int>()
        if (isFromFilter) {
            for (i in 0 until filterModel?.typeArrayList!!.size) {
                if (filterModel?.typeArrayList!![i].checked) {
                    typeArrayList.add(filterModel?.typeArrayList!![i].id)
                }
            }
            if (typeArrayList.size == 0) {
                if (isAllChatClicked) {
                    typeArrayList.add(ConversationMode.ALL.getOrdinal())
                } else {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal())
                }
            }
        } else {
            if (isAllChatClicked) {
                typeArrayList.add(ConversationMode.ALL.getOrdinal())
            } else {
                for (i in 0 until filterModel?.typeArrayList!!.size) {
                    if (filterModel?.typeArrayList!![i].checked) {
                        typeArrayList.add(filterModel?.typeArrayList!![i].id)
                    }
                }
                if (typeArrayList.size == 0) {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal())
                }
            }
        }
        typeArrayList.run {
            if (isFromFilter) {
            for (i in 0 until filterModel?.typeArrayList!!.size) {
                if (filterModel?.typeArrayList!![i].checked) {
                    typeArrayList.add(filterModel?.typeArrayList!![i].id)
                }
            }
            if (typeArrayList.size == 0) {
                if (isAllChatClicked) {
                    typeArrayList.add(ConversationMode.ALL.getOrdinal())
                } else {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal())
                }
            }
        } else {
            if (isAllChatClicked) {
                typeArrayList.add(ConversationMode.ALL.getOrdinal())
            } else {
                for (i in 0 until filterModel?.typeArrayList!!.size) {
                    if (filterModel?.typeArrayList!![i].checked) {
                        typeArrayList.add(filterModel?.typeArrayList!![i].id)
                    }
                }
                if (typeArrayList.size == 0) {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal())
                }
            }
        }
            sort()
        }
        typeIntArray = IntArray(typeArrayList.size)
        for (i in typeIntArray.indices) {
            typeIntArray[i] = typeArrayList[i]
        }
        return typeIntArray
    }

    private fun getLabelsFilter(): IntArray {
        val labelsList = ArrayList<Int>()
        for (i in 0 until filterModel?.labelsList!!.size) {
            if (filterModel?.labelsList!![i].checked) {
                labelsList.add(filterModel?.labelsList!![i].id)
            }
        }
        labelsList.run {
            for (i in 0 until filterModel?.labelsList!!.size) {
            if (filterModel?.labelsList!![i].checked) {
                labelsList.add(filterModel?.labelsList!![i].id)
            }
        }
            sort()
        }
        labelsIntArray = IntArray(labelsList.size)
        for (i in labelsIntArray.indices) {
            labelsIntArray[i] = labelsList[i]
        }
        return labelsIntArray
    }

    private fun getChannelFilter(): IntArray {
        val channelsList = ArrayList<Int>()
        for (i in 0 until filterModel?.channelList!!.size) {
            if (filterModel?.channelList!![i].checked) {
                channelsList.add(filterModel?.channelList!![i].id)
            }
        }
        channelsList.run {
            for (i in 0 until filterModel?.channelList!!.size) {
            if (filterModel?.channelList!![i].checked) {
                channelsList.add(filterModel?.channelList!![i].id)
            }
        }
            sort()
        }
        channelsIntArray = IntArray(channelsList.size)
        for (i in channelsIntArray.indices) {
            channelsIntArray[i] = channelsList[i]
        }
        return channelsIntArray
    }*/
}