package com.hippoagent.fragments

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.os.Bundle
import android.os.Handler
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import com.easyfilepicker.AppConstant
import com.hippoagent.BuildConfig
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.activities.FuguChatActivity
import com.hippoagent.adapters.ConversationChatAdapter
import com.hippoagent.callback.OnHistoryChannelListener
import com.hippoagent.datastructure.ApiResponseFlags
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.MessageMode
import com.hippoagent.datastructure.Overlay
import com.hippoagent.model.Conversation
import com.hippoagent.model.GetConversationResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParamsObj
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.DateUtils
import com.hippoagent.utils.Log
import com.hippoagent.utils.Utils
import com.hippoagent.utils.filelogger.Logger
import com.hippoagent.utils.loadingBox.LoadingBox
import com.google.gson.Gson
import faye.FuguAgentFayeClient
import kotlinx.android.synthetic.main.conversation_fragment.*
import kotlinx.android.synthetic.main.layout_no_conversation_found.*
import org.json.JSONObject
import java.util.*

/**
 * Created by gurmail on 15/05/19.
 * @author gurmail
 */
class HistoryFragment : androidx.fragment.app.Fragment(), ConversationChatAdapter.Callback,
        androidx.swiperefreshlayout.widget.SwipeRefreshLayout.OnRefreshListener, OnHistoryChannelListener {

    internal var lastMuid = ""
    override fun onReceivedMessage(fc: FuguAgentFayeClient, msg: String, channel: String) {
        val jsonObject = JSONObject(msg)
        try {
            Log.e("HistoryFragment", "Message received: = ******************** $msg")
            if (!TextUtils.isEmpty(lastMuid) && lastMuid.equals(jsonObject.optString("muid"), ignoreCase = true)) {
                Log.e("HistoryFragment", "********************")
                return
            } else {
                lastMuid = jsonObject.optString("muid")
            }

            if(jsonObject.optInt("notification_type") != 1)
                return

        } catch (e: Exception) {

        }





        var index : Int = conversationChatList.indexOf(Conversation(jsonObject.optInt("channel_id")))
        if(index != -1) {
            var conversation: Conversation = conversationChatList.get(index) as Conversation
            conversation.message = jsonObject.optString("message", "")
            conversation.agentId = jsonObject.optInt("agent_id", 0)
            conversation.last_sent_by_id = jsonObject.optInt("last_sent_by_id")
            conversation.last_sent_by_full_name = jsonObject.optString("last_sent_by_full_name")
            if (jsonObject.has("last_sent_by_user_type"))
                conversation.last_sent_by_user_type = jsonObject.optInt("last_sent_by_user_type", 2)

            if(jsonObject.has(FuguAppConstant.IS_BOT_IN_PROGRESS))
                conversation.setBotEnabled(jsonObject.optInt(FuguAppConstant.IS_BOT_IN_PROGRESS))

            conversation.lastUpdatedAt = jsonObject.optString("date_time", "")
//            if (jsonObject.optInt("last_sent_by_id", 0) != MyApplication.getInstance().userData.userId!!.toInt() && jsonObject.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
//                conversation.unreadCount = conversation.unreadCount!! + 1
//            }

            if (jsonObject.optInt("last_sent_by_id", -1) == MyApplication.getInstance().userData.userId!!.toInt()) {
                conversation.unreadCount = 0
            }
            try {
                val inRideTxt = jsonObject.optString("inride_text")
                val inRideTime = jsonObject.optInt("estimated_inride_secs", 0)

                if (inRideTime > 1) {
                    conversation.isUserOnline = true
                    conversation.inRideText = inRideTxt
                    conversation.endTime = DateUtils.getInstance().getRemainingTime(inRideTime)
                    conversation.inRideTime = inRideTime
                }
            } catch (e: Exception) {

            }

            lastMuid = jsonObject.optString("muid")

            var conversationList = ArrayList<Conversation>()

            for(conersation in conversationChatList) {
                if(conersation is Conversation) {
                    conversationList.add(conersation)
                }
            }

            conversationList.sortWith(Comparator { o1, o2 ->
                if (o1.lastUpdatedAt == null || o2.lastUpdatedAt == null)
                    0 else o2.lastUpdatedAt.compareTo(o1.lastUpdatedAt)
            })

            conversationChatList.clear()
            conversationChatList.addAll(conversationList)

            updateAdapter()
        }
    }

    private fun updateAdapter() {
        activity?.runOnUiThread {
            conversationChatAdapter!!.notifyDataSetChanged()
        }

    }

    internal var activity: Activity? = null
    val defaultPageSize = 20
    private var pageEnd = 0
    var channelId: Int = 0
    var searchUserId: Int = 0
    var layoutManager: androidx.recyclerview.widget.LinearLayoutManager? = null
    private var pastVisiblesItems: Int = 0
    private var visibleItemCount:Int = 0
    private var totalItemCount:Int = 0
    var loadmore: Boolean = true;
    private var isApiInProgress: Boolean = false
    private val conversationChatList = ArrayList<Any>()
    private var conversationChatAdapter: ConversationChatAdapter? = null
    var isDeleted : Boolean = false
    private var conversation: Conversation? = null
    var srLayout: androidx.swiperefreshlayout.widget.SwipeRefreshLayout? = null
    var rvAll: androidx.recyclerview.widget.RecyclerView? = null
    var llNoConversation: LinearLayout? = null
    var title: TextView? = null
    var reasions: TextView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            conversation = Gson().fromJson<Conversation>(arguments?.getString(Constants.CONVERSATION), Conversation::class.java)
            channelId = conversation?.channelId!!
            searchUserId = conversation?.userId!!
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.conversation_fragment, container, false)

    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        srLayout = view.findViewById(R.id.srLayout)
        rvAll = view.findViewById(R.id.rvAll)
        llNoConversation = view.findViewById(R.id.llNoConversation)
        title = view.findViewById(R.id.title)
        reasions = view.findViewById(R.id.reasions)


        srLayout?.setOnRefreshListener(this)
        srLayout?.setColorSchemeResources(R.color.white)
        srLayout?.setProgressBackgroundColorSchemeResource(R.color.colorPrimary)
        srLayout?.setSize(androidx.swiperefreshlayout.widget.SwipeRefreshLayout.DEFAULT)

        conversationChatAdapter = ConversationChatAdapter(conversationChatList, activity, this, rvAll)
        layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        rvAll?.layoutManager = layoutManager
        rvAll?.adapter = conversationChatAdapter
        apiGetConversation(1, true)


        rvAll?.addOnScrollListener(object : androidx.recyclerview.widget.RecyclerView.OnScrollListener() {

            override fun onScrolled(recyclerView: androidx.recyclerview.widget.RecyclerView, dx: Int, dy: Int) {
                //To implement Pagination
                if (dy > 0) run {
                    visibleItemCount = layoutManager!!.getChildCount()
                    totalItemCount = layoutManager!!.getItemCount()
                    pastVisiblesItems = layoutManager!!.findFirstVisibleItemPosition()

                    if (isNetworkAvailable() && loadmore && !isApiInProgress) {
                        if (visibleItemCount + pastVisiblesItems >= totalItemCount) {
                            fetchNextPage()
                        }
                    }
                }
            }
        })
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        activity = context as Activity?
        MyApplication.getInstance().addUIListener(OnHistoryChannelListener::class.java, this)
    }


    override fun onDestroyView() {
        super.onDestroyView()
        MyApplication.getInstance().removeUIListener(OnHistoryChannelListener::class.java, this)
    }

    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onPause() {
        super.onPause()
    }

    fun fetchNextPage() {
        toggleProgressBarVisibility(true)
        var size = conversationChatList.size
        if(isDeleted)
            size = conversationChatList.size + 1
        apiGetConversation(size, false)
    }

    fun apiGetConversation(pStart: Int, showLoading: Boolean) {
        var pageStart = pStart
        if (isNetworkAvailable()) {

            isApiInProgress = true
            pageStart = if (pageStart > 0) pageStart else 1
            pageEnd = pageStart + defaultPageSize - 1

            val params = HashMap<String, Any>()
            params[Constants.ACCESS_TOKEN] = MyApplication.getInstance().userData.accessToken.toString()
            params[Constants.CHANNEL_STATUS] = "[1,2]"
            params[Constants.DEVICE_TYPE] = Constants.ANDROID
            params[Constants.APP_VERSION] = BuildConfig.VERSION_CODE
            params[Constants.PAGE_OFFSET] = pageStart
            params[Constants.ROW_COUNT] = pageEnd
            params["ignore_unread_count"] = 1
            params["fetch_all_chats"] = true
            params["search_user_id"] = searchUserId


            val paramsObj = CommonParamsObj.Builder()
                    .addAll(params)
                    .build()

            Logger.apiRequest("/api/conversation/v2/getConversations", Gson().toJson(paramsObj.map))

            RestClient.getApiInterface().getConversation(paramsObj.map)
                    .enqueue(object : ResponseResolver<GetConversationResponse>(activity, showLoading, false) {
                        override fun success(getConversationResponse: GetConversationResponse?) {
                            Logger.apiResponse("/api/conversation/v2/getConversations", "")
                            LoadingBox.showOn(activity)
                            try {
                                Log.e("Size of Array", getConversationResponse!!.data.conversation.size.toString() + "")
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.statusCode) {
                                    if (getConversationResponse.data.conversation.size < defaultPageSize) {
                                        loadmore = false
                                    }
                                    if(getConversationResponse.data?.conversation?.size!! > 0) {
                                        try {
                                            for (conversation in getConversationResponse.data.conversation) {
                                                if (conversation.inRideTime > 1) {
                                                    conversation.isUserOnline = true
                                                    conversation.endTime = DateUtils.getInstance().getRemainingTime(conversation.inRideTime)
                                                }
                                            }
                                        } catch (e: Exception) {

                                        }

                                        if(pageStart == 1)
                                            conversationChatList.clear()
                                        else
                                            toggleProgressBarVisibility(false)

                                        for(conversation in getConversationResponse.data.conversation) {
                                            conversationChatList.add(conversation)
                                        }


                                        isDeleted = conversationChatList.remove(Conversation(channelId))
                                        if(conversationChatList.size == 0) {
                                            llNoConversation?.visibility = View.VISIBLE
                                            title?.text = getString(R.string.no_previous_conversation_found)
                                            reasions?.text = getString(R.string.we_could_not_found_previous_conversation)
                                        } else {
                                            //conversationChatList.addAll(getConversationResponse.data.conversation)
                                            conversationChatAdapter!!.notifyDataSetChanged()
                                        }
                                    } else {
                                        llNoConversation?.visibility = View.VISIBLE
                                        title?.text = getString(R.string.no_previous_conversation_found)
                                        reasions?.text = getString(R.string.we_could_not_found_previous_conversation)
                                    }

                                }

                                LoadingBox.hide()
                            } catch (e: Exception) {
                                Logger.apiFailed("/api/conversation/v2/getConversations", e.localizedMessage)
                                e.printStackTrace()
                            }
                            isApiInProgress = false
                            srLayout?.isRefreshing = false

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/conversation/v2/getConversations", error.message)
                            Log.e("error", "error" + error.message)
                            LoadingBox.hide()
                            isApiInProgress = false
                            srLayout?.isRefreshing = false

                        }
                    })
        } else {
            srLayout?.isRefreshing = false
            Toast.makeText(activity, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }



    fun isNetworkAvailable(): Boolean {
        val cm = activity?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager?
        val networkInfo = cm!!.activeNetworkInfo
        return networkInfo != null && networkInfo.isConnected
    }

    override fun onClick(position: Int, conversation: Conversation?) {
        if (!Utils.preventMultipleClicks()) {
            return
        }
        val chatIntent = Intent(activity, FuguChatActivity::class.java)
        chatIntent.putExtra("btnHistory", false)
        chatIntent.putExtra(Constants.CONVERSATION, Gson().toJson(conversation, Conversation::class.java))
        startActivityForResult(chatIntent, 100)
    }

    override fun onRefresh() {
        if(!isNetworkAvailable()) {
            srLayout?.isRefreshing = false
            return
        }
        apiGetConversation(1, false)
    }

    private var progressBarItem: ConversationChatAdapter.ProgressBarItem? = null

    fun toggleProgressBarVisibility(isVisible: Boolean) {
        if (isVisible) {
            if (progressBarItem == null) {
                progressBarItem = ConversationChatAdapter.ProgressBarItem()
            }
            if (!conversationChatList.contains(progressBarItem!!)) {
                conversationChatList.add(progressBarItem!!)
                rvAll?.post { conversationChatAdapter?.notifyItemInserted(conversationChatList.size - 1) }
            }
        } else {
            if (progressBarItem != null && conversationChatList.contains(progressBarItem!!)) {
                conversationChatList.remove(progressBarItem!!)
                conversationChatAdapter?.notifyItemRemoved(conversationChatList.size - 1)
            }
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        Log.v("onActivityResult", "enter")
        if (requestCode == 100) {
            if (resultCode == MessageMode.OPEN_CHAT.getOrdinal()) {
                val channelId = Integer.parseInt(data!!.extras!!.getString(Constants.CHANNEL_ID)!!)
                setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode)
            } else if (resultCode == MessageMode.CLOSED_CHAT.getOrdinal()) {
                val channelId = Integer.parseInt(data!!.extras!!.getString(Constants.CHANNEL_ID)!!)
                setOverlayTransition(channelId, MessageMode.CLOSED_CHAT.getOrdinal(), resultCode)
            } else if (resultCode == Overlay.ASSIGNMENT.getOrdinal()) {
                val channelId = Integer.parseInt(data!!.extras!!.getString(Constants.CHANNEL_ID)!!)
                setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode)
            }
        }
    }

    private fun setOverlayTransition(channelId: Int, messageMode: Int, resultCode: Int) {
        var success = false
        var overlayConversation: Conversation? = null
        for (i in conversationChatList.indices) {
            if (conversationChatList.get(i) is Conversation) {
                val conversation1 = conversationChatList.get(i) as Conversation
                overlayConversation = conversation1
                if (conversation1.channelId == channelId) {
                    success = true
                    if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                        conversation1.status = messageMode
                    }
                    conversation1.overlay = resultCode
                    break
                }
            }
        }
        if (success) {
            conversationChatAdapter?.notifyDataSetChanged()
            removeOverlay(overlayConversation)
        }
    }

    private val handler = Handler()
    private val OVERLAY_TIME = 1000

    private fun removeOverlay(conversation: Conversation?) {
        handler.postDelayed({
            activity?.runOnUiThread {
                if (conversation != null) {
                    conversation.overlay = Overlay.DEFAULT.getOrdinal()
                    conversationChatAdapter?.notifyDataSetChanged()
                }
            }
        }, OVERLAY_TIME.toLong())
    }

}

