package com.hippoagent.fragments

import android.content.Context
import android.graphics.Color
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import android.text.Spannable
import android.text.TextUtils
import android.text.style.RelativeSizeSpan
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.hippoagent.R
import com.hippoagent.activities.FilterActivity
import com.hippoagent.adapters.DateAdapter
import com.hippoagent.callback.OnAnayticsListener
import com.hippoagent.utils.DateUtils
import com.hippoagent.utils.Log
import com.github.florent37.singledateandtimepicker.dialog.DoubleDateAndTimePickerDialog
import com.github.florent37.singledateandtimepicker.dialog.SingleDateAndTimePickerDialog
import kotlinx.android.synthetic.main.fragment_datefilter.*
import org.joda.time.DateTime
import org.joda.time.DateTimeZone
import org.joda.time.Days
import org.joda.time.LocalDate
import java.text.SimpleDateFormat
import java.util.*



/**
 * Created by gurmail on 2019-08-20.
 * @author gurmail
 */
class DateFragment : androidx.fragment.app.Fragment(), OnAnayticsListener {

    var activity: FilterActivity? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_datefilter, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        activity = getActivity() as FilterActivity?

        val adapter = DateAdapter(activity?.dateList!!, this)
        search_list.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity, androidx.recyclerview.widget.LinearLayoutManager.VERTICAL, false)
        search_list.adapter = adapter

        fromtxt.setOnClickListener {
            showSingleDateTime(activity!!, 1)
        }

        totxt.setOnClickListener {
            showSingleDateTime(activity!!, 2)
        }

        if(activity?.filterModel?.datePos == 5) {
            customLayout.visibility = View.VISIBLE
            fromtxt.text = "From: ${activity?.filterModel?.fromText!!}"
            totxt.text = "To: ${activity?.filterModel?.toText!!}"
            activity?.filterModel?.isValidDate = true
            start?.time = DateUtils.utcToLocalTZ(activity?.filterModel?.fromDate)
            end?.time = DateUtils.utcToLocalTZ(activity?.filterModel?.toDate)

        } else {
            activity?.filterModel?.toDate = DateUtils.getInstance().convertToUTC(end?.time, false)
            activity?.toDate = activity?.filterModel?.toDate
            activity?.filterModel?.toText = DateUtils.getFormattedDate(end?.time, "d MMM, yyyy h:mm a")
            totxt.text = "To: "+activity?.filterModel?.toText

            start?.set(Calendar.HOUR, (-1 * 24 * 30))
            activity?.fromDate = "From: "+DateUtils.getFormattedDate(start?.time, "d MMM, yyyy h:mm a")
            fromtxt.text = activity?.fromDate
            activity?.filterModel?.fromDate = DateUtils.getInstance().convertToUTC(start?.time, true)

            activity?.filterModel?.isValidDate = true
        }
    }


    override fun onResume() {
        super.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    override fun onClick(pos: Int, title: String, name: String) {
        Log.d("TAG", "name = $name")
        customLayout.visibility = View.GONE
        val isSelected: Boolean = activity?.dateList!![pos].isSelected
        if(!isSelected) {
            activity?.filterModel?.isHasDateFilter = false
            activity?.filterModel?.datePos = 0
            activity?.filterModel?.isHasDateFilter = false
            activity?.filterModel?.fromDate = ""
            activity?.filterModel?.toDate = ""
            return
        }
        activity?.filterModel?.datePos = activity?.dateList!![pos].id
        activity?.filterModel?.isHasDateFilter = true
        when(pos) {
            0 -> {
                val date = DateUtils.getInstance().convertToUTC(DateTime.now(DateTimeZone.getDefault()).toDate(), true)
                activity?.filterModel?.fromDate = date
                activity?.filterModel?.isValidDate = true
            }
            1 -> {
                val date = DateUtils.getInstance().convertToUTC(DateTime.now(DateTimeZone.getDefault()).minusDays(1).toDate(), true)
                activity?.filterModel?.fromDate = date
                activity?.filterModel?.toDate = DateUtils.getInstance().convertToUTC(DateTime.now(DateTimeZone.getDefault()).toDate(), true)
                activity?.filterModel?.isValidDate = true
            }
            2 -> {
                val date = DateUtils.getInstance().convertToUTC(DateTime.now(DateTimeZone.getDefault()).minusDays(6).toDate(), true)
                activity?.filterModel?.fromDate = date
                activity?.filterModel?.isValidDate = true
            }
            3 -> {
                val date = DateUtils.getInstance().convertToUTC(DateTime.now(DateTimeZone.getDefault()).minusDays(29).toDate(), true)
                activity?.filterModel?.fromDate = date
                activity?.filterModel?.isValidDate = true
            }
            4 -> {
                customLayout.visibility = View.VISIBLE
            }
        }
    }

    private var start: Calendar? = Calendar.getInstance()
    private var end: Calendar? = Calendar.getInstance()
    private val dateFormatter = SimpleDateFormat("d MMM yy")

    private fun showSingleDateTime(context: Context, type: Int) {
        val builder = SingleDateAndTimePickerDialog.Builder(context)
                .title("Date time picker")
                .curved()
                .bottomSheet()
                .setDayFormatter(dateFormatter)
                .listener {
                    when(type) {
                        1 ->  {
                            start?.time = it
                            activity?.filterModel?.fromDate = DateUtils.getInstance().convertToUTC(it, false)
                            activity?.fromDate = DateUtils.getFormattedDate(it, "d MMM, yyyy h:mm a");
                            activity?.filterModel?.fromText = activity?.fromDate
                            fromtxt.text = "From: ${activity?.filterModel?.fromText!!}"
                            activity?.filterModel?.isValidDate = true
                            Log.e("TAG", "From date = "+ activity?.toDate)
                            Log.e("TAG", "From UTC date = "+ activity?.filterModel?.fromDate)

                            if(!start?.time!!.before(end?.time)) {
                                activity?.filterModel?.isValidDate = false
                                Log.e("TAG", "Start date before End date")
                                Log.e("TAG", "Start date = "+ start?.time)
                                Log.e("TAG", "End date = "+ end?.time)
                            }

                        }
                        2 -> {
                            end?.time = it
                            activity?.filterModel?.toDate = DateUtils.getInstance().convertToUTC(it, false)
                            activity?.toDate = DateUtils.getFormattedDate(it, "d MMM, yyyy h:mm a");
                            activity?.filterModel?.toText = activity?.toDate
                            totxt.text = "To: ${activity?.filterModel?.toText!!}"
                            Log.e("TAG", "From date = "+ activity?.toDate)
                            Log.e("TAG", "From UTC date = "+ activity?.filterModel?.toDate)


                        }
                    }
                }

        if(type == 1) {
            builder.minDateRange(DateTime.now(DateTimeZone.getDefault()).minusDays(60).toDate())
            builder.defaultDate(start?.time)
            //builder.maxDateRange(end?.time)
            builder.maxDateRange(DateTime.now(DateTimeZone.getDefault()).toDate())
        } else {
            builder.minDateRange(start?.time)
            builder.defaultDate(end?.time)
            builder.maxDateRange(DateTime.now(DateTimeZone.getDefault()).toDate())
        }
        builder.minutesStep(1)
        builder.display()
    }

}