package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.adapters.ConversationChatAdapter;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.GAEvents;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.recylerviewAnimation.FadeInLeftAnimator;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by ankit on 29/05/17.
 */

public class ConversationFragment extends Fragment implements SwipeRefreshLayout.OnRefreshListener {

    private View root;
    private SwipeRefreshLayout srLayout;
    private RecyclerView rvAll;
    private ConversationChatAdapter conversationChatAdapter;
    private ArrayList<Object> conversationsList = new ArrayList<>();
    LinearLayoutManager layoutManager;
    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private LinearLayout llNoConversation;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;
    private Activity activity;
    private int chatType = MessageType.MY_CHAT.getOrdinal();

    public ConversationFragment() {
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(getArguments() != null) {
            chatType = getArguments().getInt("chat_type", 0);
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        root = inflater.inflate(R.layout.conversation_fragment, container, false);
        return root;
    }

    public RecyclerView getRvAll() {
        return rvAll;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Activity){
            activity=(Activity) context;
        }
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        srLayout = (SwipeRefreshLayout) view.findViewById(R.id.srLayout);
        srLayout.setOnRefreshListener(this);
        srLayout.setColorSchemeResources(R.color.white);
        srLayout.setProgressBackgroundColorSchemeResource(R.color.colorPrimary);
        srLayout.setSize(SwipeRefreshLayout.DEFAULT);
        llNoConversation = (LinearLayout) root.findViewById(R.id.llNoConversation);
        rvAll = (RecyclerView) view.findViewById(R.id.rvAll);
        layoutManager = new LinearLayoutManager(activity);
        rvAll.setLayoutManager(layoutManager);
        rvAll.setItemAnimator(new FadeInLeftAnimator());
        rvAll.getItemAnimator().setAddDuration(500);
        rvAll.getItemAnimator().setRemoveDuration(500);
        rvAll.setHasFixedSize(false);

        conversationChatAdapter = new ConversationChatAdapter(conversationsList, activity, new ConversationChatAdapter.Callback() {
            @Override
            public void onClick(int position, Conversation conversation) {
                if(!Utils.preventMultipleClicks()) {
                    return;
                }
                Intent chatIntent = new Intent(activity, FuguChatActivity.class);

                if(chatType == MessageType.P2P_CHAT.getOrdinal()) {
                    chatIntent.putExtra("is_p2p_chat", true);
                } else {
                    chatIntent.putExtra("is_p2p_chat", false);
                }
                chatIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                startActivityForResult(chatIntent, 100);
                //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.CHAT_CLICKED, "conversation_clicked");
            }
        }, rvAll);
        rvAll.setAdapter(conversationChatAdapter);


        // TODO: 2019-12-30
        /*if (((MainActivity) activity).getHomeFragment().isGetConversationApiHit() && conversationsList.size() == 0) {
            llNoConversation.setVisibility(View.VISIBLE);
            ((MainActivity)activity).dlgProgress.setVisibility(View.GONE);
        } else {
            llNoConversation.setVisibility(View.GONE);
        }*/

        rvAll.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                Log.v("scroll state ", "changed");
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                //To implement Pagination
                // TODO: 2019-12-30
                /*if (dy > 0) {
                    //((MainActivity) activity).getRlFilterToolTip().setVisibility(View.GONE);
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (((MainActivity) activity).isNetworkAvailable() && ((MainActivity) activity).getHomeFragment().hasPagination &&
                            !((MainActivity) activity).getHomeFragment().isPagingApiInProgress()) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            try {
                                if(((MainActivity) getActivity()) != null && ((MainActivity) getActivity()).loadmore)
                                    fetchNextPage();
                            } catch (Exception e) {
                                fetchNextPage();
                            }
                        }
                    }
                } else {
                    if (((MainActivity) activity).getSnackbar() != null && layoutManager.findFirstVisibleItemPosition() == 1) {
                        ((MainActivity) activity).getSnackbar().dismiss();
                    }
                }*/
            }
        });
    }

    public LinearLayoutManager getLayoutManager() {
        return layoutManager;
    }


    public void setConversationChatCount(Conversation conversationCount) throws Exception {

    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.v("onActivityResult", "enter");
        if (requestCode == 100) {
            if (resultCode == MessageMode.OPEN_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString(Constants.CHANNEL_ID));
                setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == MessageMode.CLOSED_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString(Constants.CHANNEL_ID));
                setOverlayTransition(channelId, MessageMode.CLOSED_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == Overlay.ASSIGNMENT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString(Constants.CHANNEL_ID));
                setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            }
        }
    }

    private void setOverlayTransition(int channelId, int messageMode, int resultCode) {
        boolean success = false;
        int pos = -1;
        Conversation overlayConversation = null;
        for (int i = 0; i < conversationsList.size(); i++) {
            if (conversationsList.get(i) instanceof Conversation) {
                Conversation conversation1 = (Conversation) conversationsList.get(i);
                overlayConversation = conversation1;
                if (conversation1.getChannelId().equals(channelId)) {
                    pos = i;
                    success = true;
                    if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                        conversation1.setStatus(messageMode);
                    }
                    conversation1.setOverlay(resultCode);
                    break;
                }
            }
        }
        if (success) {
            conversationChatAdapter.notifyDataSetChanged();
            // TODO: 2019-12-30
            /*if (((MainActivity) activity).getStatusIntArray().length == 2
                    && resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                removeOverlay(overlayConversation);
            } else if(((MainActivity) activity).isAllChatClicked()) {
                removeOverlay(overlayConversation);
            } else {
                removeConversation(channelId);
            }*/
        }
    }

    int position = -1;

    public void removeConversation(final int channelId) {
        position = -1;
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                try {
                    if(activity == null)
                        activity = getActivity();
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            // TODO: 2019-12-30
                            //if (((MainActivity) activity).getHomeFragment().getConversationChatList().size() > 0) {
                            if(conversationsList.size()>0) {
                                for (int i = 0; i < conversationsList.size(); i++) {
                                    if (channelId == ((Conversation) conversationsList.get(i)).getChannelId()) {
                                        position = i;
                                        break;
                                    }
                                }
                            }
                            if (position != -1) {
                                try {
                                    // TODO: 2019-12-30
                                    //((MainActivity) activity).getHomeFragment().getConversationChatList().remove(position);
                                    conversationsList.remove(position);
                                    conversationChatAdapter.notifyItemRemoved(position);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            setLlNoConversation();
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, OVERLAY_TIME);

    }

    private void removeOverlay(final Conversation conversation) {
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            conversationChatAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, OVERLAY_TIME);
    }

    public LinearLayout getLlNoConversation() {
        return llNoConversation;
    }

    public SwipeRefreshLayout getSrLayout() {
        return srLayout;
    }

    private void fetchNextPage() {
        // TODO: 2019-12-30
        /*((MainActivity) activity).getHomeFragment().setPagingApiInProgress(true);
        toggleProgressBarVisibility(true);
        int pageStart = conversationsList.size();
        if (conversationsList.contains(progressBarItem)) {
            pageStart = conversationsList.size();
        }
        ((MainActivity) activity).getHomeFragment().isApiInProgress = false;
        if(((MainActivity) activity).selectedPeople==null && !((MainActivity) activity).isFromFilter){
            ((MainActivity) activity).getHomeFragment().apiGetConversation(String.valueOf(MyApplication.getInstance().getUserData().getUserId()),
                    ((MainActivity) activity).getStatusIntArray()
                    , ((MainActivity) activity).getTypeIntArray(), ((MainActivity) activity).getLabelsIntArray(), pageStart, true, false,true);
        } else {
            String customLabel = null;
            if(((MainActivity) activity).getFilterModel().getSearchCustomLabel()>0)
                customLabel = Integer.toString(((MainActivity) activity).getFilterModel().getSearchCustomLabel());

            ((MainActivity) activity).getHomeFragment().apiGetConversation(((MainActivity) activity).selectedPeopleUserId,
                    String.valueOf(MyApplication.getInstance().getUserData().getUserId()),((MainActivity) activity).getStatusIntArray()
                    ,((MainActivity) activity).getTypeIntArray(), ((MainActivity) activity).getLabelsIntArray(),
                    pageStart, true, false,true, ((MainActivity) activity).getChannelFilter(), customLabel, ((MainActivity) activity).getFilterModel());
        }*/

    }

    private ConversationChatAdapter.ProgressBarItem progressBarItem;

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (progressBarItem == null) {
                progressBarItem = new ConversationChatAdapter.ProgressBarItem();
            }
            if (!conversationsList.contains(progressBarItem)) {
                conversationsList.add(progressBarItem);
                rvAll.post(new Runnable() {
                    public void run() {
                        conversationChatAdapter.notifyItemInserted(conversationsList.size() - 1);
                    }
                });
            }
        } else {
            if (progressBarItem != null && conversationsList.contains(progressBarItem)) {
                conversationsList.remove(progressBarItem);
                conversationChatAdapter.notifyItemRemoved(conversationsList.size() - 1);
            }
        }
    }

    public ConversationChatAdapter getConversationChatAdapter() {
        return conversationChatAdapter;
    }

    public ArrayList<Object> getConversationList() {
        return conversationsList;
    }

    private ArrayList<Object> getAdapterList(List<Conversation> allChatDetailList) {
        if (conversationsList == null) {
            conversationsList = new ArrayList<>();
        }
        conversationsList.clear();

        if (allChatDetailList != null && allChatDetailList.size() > 0) {
            conversationsList.addAll(allChatDetailList);
        }
        return conversationsList;
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination) {
        setConversationChatData(allChatData, isPagination, true);
    }
    public void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination, final boolean soundRefresh) {
        if (!isPagination) {
            conversationsList.clear();
        }
        /*try {
            // TODO: 2019-12-30
            if(((MainActivity) activity).notifiacrionClicked) {
                Integer channelId = ((MainActivity) activity).conversation.getChannelId();
                ((MainActivity) activity).notifiacrionClicked = false;
                for(int i = 0;i<allChatData.size();i++) {
                    if(channelId.intValue() == allChatData.get(i).getChannelId().intValue()) {
                        allChatData.get(i).setUnreadCount(0);
                        break;
                    }
                }
            }
        } catch (Exception e) {

        }*/

        conversationsList.addAll(allChatData);

        if (getView() != null && conversationChatAdapter != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    conversationChatAdapter.notifyDataSetChanged();
                }
            });
        }
        setLlNoConversation();
        // TODO: 2019-12-30
        /*try {
            if(soundRefresh && ((MainActivity) activity).getHomeFragment() != null)
                ((MainActivity) activity).getHomeFragment().checkBKSound(-1);
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    public void setLlNoConversation() {
        if (llNoConversation != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (conversationsList.size() == 0) {
                        llNoConversation.setVisibility(View.VISIBLE);
                        // TODO: 2019-12-30
                        //((MainActivity)activity).dlgProgress.setVisibility(View.GONE);
                    } else {
                        llNoConversation.setVisibility(View.GONE);
                    }
                }
            });
        }
    }

    @Override
    public void onRefresh() {
        if(!isNetworkAvailable()) {
            getSrLayout().setRefreshing(false);
            return;
        }
        // TODO: 2019-12-30

        //BusProvider.getInstance().post(new );
        /*((MainActivity) getActivity()).loadmore = true;
        if(((MainActivity) activity).selectedPeople == null && !((MainActivity) activity).isFromFilter){
            ((MainActivity) activity).getHomeFragment().apiGetConversation(String.valueOf(MyApplication.getInstance().getUserData().getUserId()),
                    ((MainActivity) activity).getStatusIntArray()
                    ,((MainActivity) activity).getTypeIntArray(), ((MainActivity) activity).getLabelsIntArray(), 1, false, false,true);
            //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.PULL_DOWN_TO_REFRESH, "pull_to_refresh");
        } else {
            String customLabel = null;
            if(((MainActivity) activity).getFilterModel().getSearchCustomLabel()>0)
                customLabel = Integer.toString(((MainActivity) activity).getFilterModel().getSearchCustomLabel());
            ((MainActivity) activity).getHomeFragment().apiGetConversation(((MainActivity) activity).selectedPeopleUserId,
                    String.valueOf(MyApplication.getInstance().getUserData().getUserId()),((MainActivity) activity).getStatusIntArray()
                    ,((MainActivity) activity).getTypeIntArray(), ((MainActivity) activity).getLabelsIntArray(),
                    1, false, false,true, ((MainActivity) activity).getChannelFilter(), customLabel, ((MainActivity) activity).getFilterModel());
            //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.PULL_DOWN_TO_REFRESH, "pull_to_refresh");
        }*/
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getActivity().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}
