package com.hippoagent.fragments;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.LabelsAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.model.Filter;
import com.hippoagent.model.conversation_search.ConversationSearchResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.HashMap;

import static androidx.databinding.DataBindingUtil.inflate;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class ChannelFragment extends Fragment implements SearchViewNetworkQueryHelper.SearchCallbacks, LabelsAdapter.LabelInterface {

    private static final String TAG = ChannelFragment.class.getSimpleName();
    private FilterActivity activity;

    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private FragmentPeopleBinding fragmentBinding;
    private ArrayList<Filter> channelArrayList = new ArrayList<>();
    private ArrayList<Filter> serverChannelArrayList = new ArrayList<>();
    private ArrayList<Filter> tempChannelArrayList = new ArrayList<>();

    private LabelsAdapter labelsAdapter;
    private Integer totalChannels = 0;
    String endIndex = Integer.toString(10);

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        fragmentBinding = inflate(inflater, R.layout.fragment_people,
                container, false);
        View view = fragmentBinding.getRoot();
        activity = (FilterActivity) getActivity();
        channelArrayList.addAll(activity.getFilterModel().getChannelList());
        tempChannelArrayList.addAll(channelArrayList);

        labelsAdapter = new LabelsAdapter(tempChannelArrayList, this);
        fragmentBinding.searchList.setAdapter(labelsAdapter);

        fragmentBinding.ibRemoveSelectedPeople.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activity.resetFilter();
            }
        });
        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(fragmentBinding.searchView, this);
        mSearchNetworkQueryHelper.setSuggestCountThreshold(3);
        mSearchNetworkQueryHelper.setSuggestWaitThreshold(0);

    }

    @Override
    public void showLoader() {

    }

    @Override
    public void performQuery(String query) {
        activity.setButtonVisibility(View.GONE);
        fragmentBinding.progressBarSearch.setVisibility(View.VISIBLE);
        fragmentBinding.progressBarSearch.spin();
        getSearchedChannel(query, "0", endIndex, true, false);
    }

    @Override
    public void showAllData() {
        tempChannelArrayList.clear();
        tempChannelArrayList.addAll(channelArrayList);
        labelsAdapter.setData(tempChannelArrayList, false, totalChannels);
        activity.setButtonVisibility(View.VISIBLE);

        fragmentBinding.noDataFound.setVisibility(View.GONE);
        fragmentBinding.searchList.setVisibility(View.VISIBLE);

        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
    }

    private void getSearchedChannel(final String query, String startIndex, String endIndex, final boolean isClearData, final boolean showLoading) {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("search_text", query);
        params.put("is_my_chat", activity.isAllChat() ? "0" : "1");
        params.put("channel_start", Integer.toString(serverChannelArrayList.size()));
        params.put("channel_end", endIndex);
        params.put("user_start", "0");
        params.put("user_end", "0");

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("api/v2/conversation/search", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().conversationSearch(commonParams.getMap())
                .enqueue(new ResponseResolver<ConversationSearchResponse>(getActivity(), showLoading, true) {
                    @Override
                    public void success(ConversationSearchResponse conversationSearchResponse) {
                        Logger.INSTANCE.apiResponse("api/v2/conversation/search", "");
                        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
                        if (isClearData) {
                            serverChannelArrayList.clear();
                        }
                        totalChannels = conversationSearchResponse.getData().getTotalChannels();
                        for (int i = 0; i < conversationSearchResponse.getData().getChannels().size(); i++) {
                            Filter filter = new Filter();
                            filter.setId(conversationSearchResponse.getData().getChannels().get(i).getChannelId());
                            filter.setName(conversationSearchResponse.getData().getChannels().get(i).getCustomLabel());
                            filter.setChecked(false);
                            filter.setServer(true);

                            serverChannelArrayList.add(filter);
                        }

                        tempChannelArrayList.clear();
                        tempChannelArrayList.addAll(serverChannelArrayList);
                        for (Filter filter : channelArrayList) {
                            if (filter.getName().toLowerCase().contains(query.toLowerCase())) {
                                tempChannelArrayList.add(filter);
                            }
                        }

                        labelsAdapter.setData(tempChannelArrayList, true, totalChannels);
                        if(tempChannelArrayList.size() == 0) {
                            fragmentBinding.noDataFound.setVisibility(View.VISIBLE);
                            fragmentBinding.searchList.setVisibility(View.GONE);
                        } else {
                            fragmentBinding.noDataFound.setVisibility(View.GONE);
                            fragmentBinding.searchList.setVisibility(View.VISIBLE);
                        }

                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("api/v2/conversation/search", error.getMessage());
                        fragmentBinding.progressBarSearch.setVisibility(View.GONE);
                    }

                });
    }

    @Override
    public void onLoadMoreClick() {
        String startIndex = Integer.toString(tempChannelArrayList.size());
        getSearchedChannel(fragmentBinding.searchView.getText().toString().trim(), startIndex, endIndex, false, true);
    }

    @Override
    public void onSingleItemClick(Filter filter, int position) {
        for(int i=0;i<activity.getFilterModel().getChannelList().size();i++) {
            activity.getFilterModel().getChannelList().get(i).setChecked(false);
        }
        activity.getFilterModel().setSearchCustomLabel(-1);
        activity.getFilterModel().setSearchCustomName("");
        if(filter.isServer()) {
            activity.getFilterModel().setSearchCustomLabel(filter.getId());
            activity.getFilterModel().setSearchCustomName(filter.getName());
            activity.getFilterModel().setViewType(3);
        } else {
            int index = activity.getFilterModel().getChannelList().indexOf(filter);
            activity.getFilterModel().getChannelList().get(index).setChecked(true);
            activity.getFilterModel().setViewType(3);
        }

        activity.applyFilterData();
    }

    @Override
    public void removeCustomFilter() {

    }
}
