package com.hippoagent.fragments;


import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.appcompat.widget.Toolbar;
import android.text.InputType;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.ProfileActivity;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.ValidateClass;
import com.google.gson.Gson;

import java.util.HashMap;

import static com.hippoagent.appData.AppManager.USER_ONBOARD_VALUE;
import static com.hippoagent.utils.GAEvents.CHANGE_PASS_SCREEN;
import static com.hippoagent.utils.GAEvents.CHANGE_SAVE_BTN;
import static com.hippoagent.utils.GAEvents.CONF_PASS;
import static com.hippoagent.utils.GAEvents.EDIT_NEW_PASS;
import static com.hippoagent.utils.GAEvents.EDIT_OLD_PASS;

/**
 * A simple {@link Fragment} subclass.
 */
public class ChangePasswordFragment extends Fragment implements View.OnClickListener {
    private EditText etPassword, etConfirmPassword, etOldPassword;
    private Button btnSave;
    private ImageView ivEyePass, ivEyeConfPass, ivOldEyePass;
    private boolean isEyePress = false, isConfEyePress = false, isOldEyePress = false;
    private RelativeLayout rlParent;
    private int userOnBoardingValue = 0;
    private LinearLayout llOldPass;
    private View oldlineView;

    private Toolbar toolbar;

    public ChangePasswordFragment() {
        // Required empty public constructor
    }

    public static ChangePasswordFragment newInstance() {
        ChangePasswordFragment fragment = new ChangePasswordFragment();
        return fragment;
    }

    public static ChangePasswordFragment newInstance(int userOnBoardingValue) {
        ChangePasswordFragment fragment = new ChangePasswordFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(USER_ONBOARD_VALUE, userOnBoardingValue);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            userOnBoardingValue = getArguments().getInt(USER_ONBOARD_VALUE, 0);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_change_password, container, false);
        initView(view);
        return view;
    }

    private void initView(View view) {
        toolbar = view.findViewById(R.id.toolbar);
        if(getActivity() instanceof ProfileActivityName) {
            ((ProfileActivityName) getActivity()).setSupportActionBar(toolbar);
            ((ProfileActivityName) getActivity()).setToolbar(toolbar, getResources().getString(R.string.change_password));
            toolbar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ((ProfileActivityName) getActivity()).onBackPressed();
                }
            });
        } else {
            ((ProfileActivity) getActivity()).setSupportActionBar(toolbar);
            ((ProfileActivity) getActivity()).setToolbar(toolbar, getResources().getString(R.string.change_password));
            toolbar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ((ProfileActivity) getActivity()).onBackPressed();
                }
            });
        }

        etPassword = (EditText) view.findViewById(R.id.etPassword);
        etConfirmPassword = (EditText) view.findViewById(R.id.etConfirmPassword);
        etOldPassword = (EditText) view.findViewById(R.id.etOldPassword);
        oldlineView = view.findViewById(R.id.oldlineView);

        llOldPass = (LinearLayout) view.findViewById(R.id.llOldPass);
        if (userOnBoardingValue != 0) {
            llOldPass.setVisibility(View.GONE);
            oldlineView.setVisibility(View.GONE);
        }

        btnSave = (Button) view.findViewById(R.id.btnSave);
        btnSave.setOnClickListener(this);

        ivEyePass = (ImageView) view.findViewById(R.id.ivEyePass);
        ivEyePass.setOnClickListener(this);
        ivEyeConfPass = (ImageView) view.findViewById(R.id.ivEyeConfPass);
        ivEyeConfPass.setOnClickListener(this);
        ivOldEyePass = (ImageView) view.findViewById(R.id.ivOldEyePass);
        ivOldEyePass.setOnClickListener(this);

        rlParent = (RelativeLayout) view.findViewById(R.id.rlParent);

        etConfirmPassword.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_DONE) {
                    ValidateClass validateClass = new ValidateClass(getActivity());
                    if (userOnBoardingValue == 0) {
                        validateClass.genericEmpty(etOldPassword, getString(R.string.old_pass_empty_msg));
                        validateClass.checkPassword(etOldPassword);
                    }

                    if (validateClass.genericEmpty(etPassword, getString(R.string.new_pass_empty_msg))
                            && validateClass.genericEmpty(etConfirmPassword, getString(R.string.conf_pass_empty_msg))
                            && validateClass.checkPassword(etPassword)
                            && validateClass.passwordMatch(etPassword, etConfirmPassword)) {
                        if (etPassword.getText().toString().equals(etOldPassword.getText().toString())) {
                            Toast.makeText(getActivity(), getResources().getString(R.string.same_pass_err), Toast.LENGTH_SHORT).show();
                        } else {
                            changePassApi();
                        }
                    }
                    return true;
                } else {
                    return false;
                }
            }
        });
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btnSave) {//MyApplication.getInstance().trackEvent(CHANGE_PASS_SCREEN, CHANGE_SAVE_BTN, "save_button_clicked");
            getActivity().getWindow().getDecorView().clearFocus();
            ValidateClass validateClass = new ValidateClass(getActivity());
            if (userOnBoardingValue == 0) {
                validateClass.genericEmpty(etOldPassword, getString(R.string.old_pass_empty_msg));
                validateClass.checkPassword(etOldPassword);
            }

            if (validateClass.checkPassword(etPassword) && validateClass.passwordMatch(etPassword, etConfirmPassword)) {
                if (etPassword.getText().toString().equals(etOldPassword.getText().toString())) {
                    Toast.makeText(getActivity(), getResources().getString(R.string.same_pass_err), Toast.LENGTH_SHORT).show();
                } else {
                    changePassApi();
                }
            }
        } else if (id == R.id.ivOldEyePass) {
            if (isOldEyePress) {
                ivOldEyePass.setImageResource(R.drawable.agent_ic_eye_inactive);
                etOldPassword.setInputType(InputType.TYPE_CLASS_TEXT |
                        InputType.TYPE_TEXT_VARIATION_PASSWORD);
                isOldEyePress = false;
            } else {
                ivOldEyePass.setImageResource(R.drawable.agent_ic_eye_active);
                etOldPassword.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
                isOldEyePress = true;
            }
            etOldPassword.setSelection(etOldPassword.getText().length());
        } else if (id == R.id.ivEyePass) {
            if (isEyePress) {
                ivEyePass.setImageResource(R.drawable.agent_ic_eye_inactive);
                etPassword.setInputType(InputType.TYPE_CLASS_TEXT |
                        InputType.TYPE_TEXT_VARIATION_PASSWORD);
                isEyePress = false;
            } else {
                ivEyePass.setImageResource(R.drawable.agent_ic_eye_active);
                etPassword.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
                isEyePress = true;
            }
            etPassword.setSelection(etPassword.getText().length());
        } else if (id == R.id.ivEyeConfPass) {
            if (isConfEyePress) {
                ivEyeConfPass.setImageResource(R.drawable.agent_ic_eye_inactive);
                etConfirmPassword.setInputType(InputType.TYPE_CLASS_TEXT |
                        InputType.TYPE_TEXT_VARIATION_PASSWORD);
                isConfEyePress = false;
            } else {
                ivEyeConfPass.setImageResource(R.drawable.agent_ic_eye_active);
                etConfirmPassword.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
                isConfEyePress = true;
            }
            etConfirmPassword.setSelection(etConfirmPassword.getText().length());
        } else if (id == R.id.inputOldPassword) {//setFocus(etOldPassword);
            //MyApplication.getInstance().trackEvent(CHANGE_PASS_SCREEN, EDIT_OLD_PASS, "old_password_entered");
        } else if (id == R.id.inputPassword) {//setFocus(etPassword);
            //MyApplication.getInstance().trackEvent(CHANGE_PASS_SCREEN, EDIT_NEW_PASS, "new_password_entered");
        } else if (id == R.id.inputConfirmPassword) {//setFocus(etConfirmPassword);
            //MyApplication.getInstance().trackEvent(CHANGE_PASS_SCREEN, CONF_PASS, "confirm_password_entered");
        }
    }

    private void changePassApi() {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put(Constants.NEW_PASSWORD, etPassword.getText().toString());
        if (userOnBoardingValue == 0)
            params.put(Constants.OLD_PASSWORD, etOldPassword.getText().toString());

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("api/agent/changePassword", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().changePassword(commonParams.getMap())
                .enqueue(new ResponseResolver<AgentProfileDetails>(getActivity(), true, true) {
                    @Override
                    public void success(AgentProfileDetails editProfileResponse) {
                        Logger.INSTANCE.apiResponse("api/agent/changePassword", "");
                        if (userOnBoardingValue != 0) {
                            if(getActivity() instanceof ProfileActivityName)
                                ((ProfileActivityName) getActivity()).afterAgentOnBoard();
                            else
                                getActivity().onBackPressed();
                        } else {
                            Toast.makeText(getActivity(), getResources().getString(R.string.pass_save_succ), Toast.LENGTH_SHORT).show();
                            getActivity().onBackPressed();
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("api/agent/changePassword", error.getMessage());
                        Toast.makeText(getActivity(), error.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        // Checks whether a hardware keyboard is available
        if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_NO) {
        } else if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_YES) {
            getActivity().getWindow().getDecorView().clearFocus();
        }
    }
}
