package com.hippoagent.fragments

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.activities.BroadcastDetailsActivity
import com.hippoagent.adapters.BroadcastListAdapter
import com.hippoagent.adapters.OnItemClickListener
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.BroadCastObjectModel
import com.hippoagent.model.BroadcastResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson
import kotlinx.android.synthetic.main.fragment_list.*
import kotlinx.android.synthetic.main.fragment_pager.*
import java.util.ArrayList

/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class BroadcastListFragment: androidx.fragment.app.Fragment(), FuguAppConstant, OnItemClickListener {

    override fun onClickItem(position: Int) {
        val intent = Intent(activity, BroadcastDetailsActivity::class.java)
        val objectModel = objectModels?.get(position)
        intent.putExtra("objectModel", objectModel)
        startActivity(intent)
    }

    companion object {
        fun newInstance() = BroadcastListFragment()
    }

    private var listAdapter: BroadcastListAdapter? = null
    private var objectModels: ArrayList<BroadCastObjectModel>? = ArrayList()

    private var pastVisiblesItems: Int = 0
    private var visibleItemCount:Int = 0
    private var totalItemCount:Int = 0
    private var hasMorePages: Boolean = false
    private var isPagingApiInProgress: Boolean = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_list, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        listAdapter = BroadcastListAdapter(recyclerView, this)
        val layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        layoutManager.orientation = androidx.recyclerview.widget.LinearLayoutManager.VERTICAL
        recyclerView.layoutManager = layoutManager


        recyclerView.adapter = listAdapter
        getBroadcastData(0)

        recyclerView.addOnScrollListener(object : androidx.recyclerview.widget.RecyclerView.OnScrollListener() {

            override fun onScrolled(recyclerView: androidx.recyclerview.widget.RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (dy > 0) {
                    visibleItemCount = layoutManager.childCount
                    totalItemCount = layoutManager.itemCount
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition()

                    if (!isPagingApiInProgress && hasMorePages) {
                        if (visibleItemCount + pastVisiblesItems >= totalItemCount) {
                            getBroadcastData(objectModels?.size!!)
                        }
                    }
                }
            }
        })
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)

    }

    override fun onDestroyView() {
        super.onDestroyView()
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    private fun getBroadcastData(offset: Int) {
        if (offset != 0) {
            isPagingApiInProgress = true
            listAdapter?.showPaginationProgressBar(true, true)
        }
        val commonParams = CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().userData.accessToken)
                .add("page_offset", offset)
                .build()
        Logger.apiRequest("api/broadcast/getBroadcastList", Gson().toJson(commonParams.map))
        RestClient.getApiInterface().getBroadcastList(commonParams.map).enqueue(object : ResponseResolver<BroadcastResponse>(activity, offset == 0, false) {
            override fun success(broadCastObjectModel: BroadcastResponse) {
                Logger.apiResponse("api/broadcast/getBroadcastList", "")
                if (offset != 0) {
                    isPagingApiInProgress = false
                    listAdapter?.showPaginationProgressBar(false, true)
                }

                if (objectModels == null)
                    objectModels = ArrayList()

                if (offset == 0)
                    objectModels?.clear()

                objectModels?.addAll(broadCastObjectModel.data.broadcastedChannels)

                listAdapter?.setData(objectModels)
                hasMorePages = broadCastObjectModel.data.broadcastedChannels.size == broadCastObjectModel.data.pageSize
                if (offset == 0 && broadCastObjectModel.data.broadcastedChannels == null || broadCastObjectModel.data.broadcastedChannels.size == 0) {
                    llNoConversation.visibility = View.VISIBLE
                } else {
                    llNoConversation.visibility = View.GONE
                }
            }

            override fun failure(error: APIError) {
                Logger.apiFailed("api/broadcast/getBroadcastList", error.message)
            }
        })
    }
}