package com.hippoagent.fragments;

import android.content.DialogInterface;
import android.os.Bundle;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.Message;
import com.hippoagent.utils.DateUtils;

import java.util.Date;


/**
 * Created by gurmail on 2019-08-06.
 *
 * @author gurmail
 */
public class BottomSheetMsgFragment extends BottomSheetDialogFragment implements FuguAppConstant, View.OnClickListener {
    private LinearLayout copy, react, reply, delete, email, star, edit, forward;
    private FuguChatActivity fuguChatActivity;
    private int position;
    private String Muid;
    private int messsagetype;
    private boolean IsSelf;
    private int MessageStatus;
    private String SentAtUtc;
    private TextView tvDelete;
    private TextView tvStar;
    private Boolean isReplied;

    public BottomSheetMsgFragment() {

    }

    public static BottomSheetMsgFragment newInstance(int pos, Message message, boolean isSelf, boolean isReplied) {
        BottomSheetMsgFragment frag = new BottomSheetMsgFragment();
        Bundle args = new Bundle();
        frag.setArguments(args);
        frag.setPostion(pos);
        frag.setMuid(message.getMuid());
        frag.setIsSelf(isSelf);
        frag.setMessageType(message.getOriginalMessageType());
        frag.setMessageStatus(message.getMessageStatus());
        frag.setSentAtUtc(message.getSentAtUtc());
        frag.setReplied(isReplied);
        return frag;
    }

    private void setReplied(boolean isReplied) {
        this.isReplied = isReplied;
    }

    private void setSentAtUtc(String sentAtUtc) {
        SentAtUtc = sentAtUtc;
    }

    private void setMessageStatus(int messsageStatus) {
        MessageStatus = messsageStatus;
    }

    private void setIsSelf(boolean isSelf) {
        IsSelf = isSelf;
    }

    private void setMessageType(int messageType) {
        messsagetype = messageType;
    }

    private void setMuid(String muid) {
        Muid = muid;
    }

    private void setPostion(int pos) {
        position = pos;
    }

    @Override
    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.message_bottom_sheet, container, false);
        fuguChatActivity = (FuguChatActivity) getActivity();
        copy = view.findViewById(R.id.copy);
        react = view.findViewById(R.id.react);
        reply = view.findViewById(R.id.reply);
        delete = view.findViewById(R.id.delete);
        email = view.findViewById(R.id.email);
        edit = view.findViewById(R.id.edit);
        forward = view.findViewById(R.id.forward);

        star = view.findViewById(R.id.star);
        tvDelete = view.findViewById(R.id.tvDelete);
        tvStar = view.findViewById(R.id.tvStar);
//        if (messsagetype == 1) {
//            copy.setVisibility(View.VISIBLE);
//        } else {
//            copy.setVisibility(View.GONE);
//        }
        String localDate = DateUtils.getFormattedDate(new Date());
        int newTime = DateUtils.getTimeInMinutes(DateUtils.getInstance().convertToUTC(localDate));
        int oldTime = DateUtils.getTimeInMinutes(SentAtUtc);


        int editableDuration = MyApplication.getInstance().getUserData().getBusinessProperty().getMaxEditMessageTime();

        if(IsSelf && messsagetype == 1 && editableDuration > -1 && (editableDuration == 0 || (Math.abs(newTime - oldTime)) < editableDuration/60)) {
            edit.setVisibility(View.VISIBLE);
        } else {
            edit.setVisibility(View.GONE);
        }

        copy.setOnClickListener(this);
        reply.setOnClickListener(this);
        react.setOnClickListener(this);
        delete.setOnClickListener(this);
        email.setOnClickListener(this);
        star.setOnClickListener(this);
        edit.setOnClickListener(this);
        forward.setOnClickListener(this);
        return view;
    }

    @Override
    public void onClick(View v) {
        dismiss();
        int id = v.getId();
        if (id == R.id.react) {/*if (fuguChatActivity.isNetworkConnected()) {
                    fuguChatActivity.openDialog(Muid);
                } else {
                    new AlertDialog.Builder(fuguChatActivity)
                            .setMessage("Please check your Internet connection and try again.")
                            .setPositiveButton("ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {

                                }
                            }).show();
                }*/
        } else if (id == R.id.reply) {/*if (fuguChatActivity.isNetworkConnected()) {
                    fuguChatActivity.openThread(position);
                } else {
                    new AlertDialog.Builder(fuguChatActivity)
                            .setMessage("Please check your Internet connection and try again.")
                            .setPositiveButton("ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {

                                }
                            }).show();
                }*/
        } else if (id == R.id.edit) {
            fuguChatActivity.editText(position);
        } else if (id == R.id.copy) {
            fuguChatActivity.copyText(position, isReplied);
            Toast.makeText(getActivity(), "Copied to Clipboard", Toast.LENGTH_SHORT).show();
        } else if (id == R.id.email) {//fuguChatActivity.sendEmail();
        } else if (id == R.id.star) {//fuguChatActivity.starMessage(position, Muid, isStarred, location);
        } else if (id == R.id.forward) {//fuguChatActivity.forwardMessage(position, Muid);
        } else if (id == R.id.delete) {/*if (fuguChatActivity.isNetworkConnected() || !(MessageStatus == MESSAGE_SENT || MessageStatus == MESSAGE_DELIVERED || MessageStatus == MESSAGE_READ)) {
                    new AlertDialog.Builder(fuguChatActivity)
                            .setMessage("Are you sure you want to delete this message.")
                            .setPositiveButton("Delete for everyone", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    fuguChatActivity.deleteMessage(position, Muid, MessageStatus);
                                }
                            }).setNegativeButton("No", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {

                        }
                    }).show();

                } else {
                    new AlertDialog.Builder(fuguChatActivity)
                            .setMessage("Please check your Internet connection and try again.")
                            .setPositiveButton("ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {

                                }
                            }).show();
                }*/
        }
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        if (fuguChatActivity != null) {
            fuguChatActivity.setOnLongClickValue();
        }
        super.onCancel(dialog);
    }
}
