package com.hippoagent.fragments;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.adapters.OptionAdapter;
import com.hippoagent.callback.OptionSelectedCallback;
import com.hippoagent.model.get_all_bots.Bot;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by amit on 07/05/18.
 */

@SuppressLint("ValidFragment")
public class BottomSheetFragment extends BottomSheetDialogFragment implements OptionSelectedCallback {
    private RecyclerView rvOptions;
    private View mView;
    private Context mContext;
    private OptionAdapter optionAdapter;
    private Bot mBot;
    private List<Bot> bot = new ArrayList<>();

    public BottomSheetFragment(List<Bot> data) {
        this.bot = data;
    }

    @Override
    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        if(getArguments() != null) {
//            bot = new Gson().fromJson(getArguments().getString("data"), null);
//        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.bottom_sheet_bot_option, container, false);
        init(view);
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        mContext = context;
    }

    private void init(View rootView) {
        rvOptions = (RecyclerView) rootView.findViewById(R.id.rvOptions);

        LinearLayoutManager layoutManager = new LinearLayoutManager(mContext);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        rvOptions.setLayoutManager(layoutManager);
        optionAdapter = new OptionAdapter(mContext, this);
        rvOptions.setAdapter(optionAdapter);
        optionAdapter.setData(bot);
        rootView.findViewById(R.id.btnNex).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(mBot!=null) {
                    ((FuguChatActivity) getActivity()).sendFaye(mBot);
                }else{
                    Toast.makeText(mContext, "Plesae select a field", Toast.LENGTH_SHORT).show();
                }
            }
        }); rootView.findViewById(R.id.btnCancel).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ((FuguChatActivity) getActivity()).closeBottomSheet();
            }
        });
    }

    @Override
    public void optionSelected(Bot id) {
        mBot = id;
    }


}
