package com.hippoagent.fragments;


import android.os.Bundle;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.user_details.UserDetailsResponse;
import com.hippoagent.utils.DateUtils;

import static com.hippoagent.datastructure.FuguAppConstant.USER_DETAILS;

/**
 * A simple {@link Fragment} subclass.
 */
public class BasicInfoFragment extends Fragment {
    private UserDetailsResponse userDetailsResponse;
    private TextView tvFirstVisit,tvLastVisit;
    private View view;


    public BasicInfoFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.fragment_basic_info, container, false);
        init(view);
        Bundle bundle=getArguments();
        userDetailsResponse=bundle.getParcelable(USER_DETAILS);
        setUi();
        // Inflate the layout for this fragment
        return view;
    }

    private void init(View view){
        tvFirstVisit=(TextView) view.findViewById(R.id.tvFirstVisit);
        tvLastVisit=(TextView) view.findViewById(R.id.tvLastVisit);
    }

    private void setUi(){
        tvFirstVisit.setText(DateUtils.getInstance().getTimeToDisplay(userDetailsResponse.getData().get(0).getFirstSeen()));
        tvLastVisit.setText(DateUtils.getInstance().getTimeToDisplay(userDetailsResponse.getData().get(0).getLastSeen()));
    }
}
