package com.hippoagent.fragments

/**
 * Created by gurmail on 2019-12-31.
 * @author gurmail
 */
import android.app.Activity
import android.content.Intent
import android.os.Bundle
import androidx.annotation.Nullable
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.easyfilepicker.Constant
import com.easyfilepicker.activity.AudioPickActivity
import com.easyfilepicker.activity.ImagePickActivity
import com.easyfilepicker.activity.NormalFilePickActivity
import com.easyfilepicker.activity.VideoPickActivity
import com.hippoagent.R
import com.hippoagent.activities.FuguChatActivity


class AttachmentSheetFragment : BottomSheetDialogFragment(), View.OnClickListener {

    val chatActivity: FuguChatActivity? = null
    var llCamera: LinearLayout? = null
    var llGallery: LinearLayout? = null
    var llVideo: LinearLayout? = null
    var llAudio: LinearLayout? = null
    var llFiles: LinearLayout? = null

    override fun onClick(v: View?) {
        dismiss()
        (activity as FuguChatActivity).openScreenFromSheet(v?.id!!)
    }

    override fun onCreate(@Nullable savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    fun newInstance(): AttachmentSheetFragment {
        val frag = AttachmentSheetFragment()
        val args = Bundle()
        frag.arguments = args
        return frag
    }

    override fun getTheme(): Int = R.style.AppBottomSheetDialogTheme
    @Nullable
    override fun onCreateView(inflater: LayoutInflater, @Nullable container: ViewGroup?, @Nullable savedInstanceState: Bundle?): View? {
        BottomSheetDialog(requireContext(), theme)
        val view = inflater.inflate(R.layout.attachmnet_bottom_sheet, container, false)

        llCamera = view.findViewById(R.id.llCamera)
        llGallery = view.findViewById(R.id.llGallery)
        llAudio = view.findViewById(R.id.llAudio)
        llFiles = view.findViewById(R.id.llFiles)
        llVideo = view.findViewById(R.id.llVideo)

        llCamera?.setOnClickListener(this)
        llGallery?.setOnClickListener(this)
        llAudio?.setOnClickListener(this)
        llFiles?.setOnClickListener(this)
        llVideo?.setOnClickListener(this)

        return view

    }
}