package com.hippoagent.fragments

import android.content.Intent
import android.graphics.Bitmap
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import com.hippoagent.R
import com.hippoagent.utils.Log
import kotlinx.android.synthetic.main.fragment_webview.*
import android.content.Context.DOWNLOAD_SERVICE
import android.R.attr.mimeType
import android.app.DownloadManager
import android.webkit.URLUtil.guessFileName
import android.os.Environment.DIRECTORY_DOWNLOADS
import android.app.DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED
import android.os.Environment


/**
 * Created by gurmail on 18/06/19.
 * @author gurmail
 */
public class AnalyticsWebViewFragment : androidx.fragment.app.Fragment() {

    var url: String = ""
    private val ARG_URL = "url"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            url = arguments!!.getString(ARG_URL, "")
            position = arguments!!.getInt("position", 0)
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_webview, container, false)
    }

    internal var firstTimeFetch = true
    override fun setUserVisibleHint(visible: Boolean) {
        super.setUserVisibleHint(visible)
        if (visible) {
            if (position > 0 && firstTimeFetch) {
                firstTimeFetch = false
                loadUrl(url)
            }
        }
    }
    internal var position = 0

    private fun loadUrl(url: String) {
        webView.loadUrl(url)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val settings = webView.settings
        settings.domStorageEnabled = true
        settings.javaScriptEnabled = true
        pbWebPageLoader.setVisibility(View.VISIBLE)
        webView.webViewClient = WebViewClient()
        if(position == 0)
            webView.loadUrl(url)


        webView.setDownloadListener(object : DownloadListener {
            override fun onDownloadStart(url: String, userAgent: String,
                                         contentDisposition: String, mimeType: String,
                                         contentLength: Long) {
                /*try {
                    val request = DownloadManager.Request(Uri.parse(url))

                    request.setMimeType(mimeType)
                    //------------------------COOKIE!!------------------------
                    val cookies = CookieManager.getInstance().getCookie(url)
                    request.addRequestHeader("cookie", cookies)
                    //------------------------COOKIE!!------------------------
                    request.addRequestHeader("User-Agent", userAgent)
                    request.setDescription("Downloading file...")
                    request.setTitle(URLUtil.guessFileName(url, contentDisposition, mimeType))
                    request.allowScanningByMediaScanner()
                    request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)
                    request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, URLUtil.guessFileName(url, contentDisposition, mimeType))
                    val dm = activity?.getSystemService(DOWNLOAD_SERVICE) as DownloadManager
                    dm?.enqueue(request)
                } catch (e: Exception) {
                }*/
            }
        })


//        webView.setInitialScale(1)
//        webView.getSettings().loadWithOverviewMode = true
//        webView.getSettings().useWideViewPort = true

        webView.webViewClient = object : WebViewClient() {

            override fun onPageFinished(view: WebView, url: String) {
                super.onPageFinished(view, url)
                try {
                    if(pbWebPageLoader != null)
                        pbWebPageLoader.setVisibility(View.INVISIBLE)
                } catch (e: Exception) {
                }
            }

            override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
                //super.onPageStarted(view, url, favicon)
                //Toast.makeText(activity, "URL = "+url, Toast.LENGTH_LONG).show()
                Log.i("url", "url = $url")
            }

        }
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
    }
}