package com.hippoagent.fragments;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.AgentListModel;
import com.hippoagent.model.Filter;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-09-25.
 *
 * @author gurmail
 */
public class AgentsAdapter extends RecyclerView.Adapter<AgentsAdapter.ViewHolder> {

    public ArrayList<Filter> list = new ArrayList<>();
    public ArrayList<AgentListModel> agentListModels = new ArrayList<>();

    public AgentsAdapter(ArrayList<Filter> list, ArrayList<AgentListModel> agentListModels) {
        this.list = list;
        this.agentListModels = agentListModels;
    }

    public void setData(ArrayList<AgentListModel> agentListModels) {
        this.agentListModels = agentListModels;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.list_item_labels, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int pos) {
        holder.cbLabel.setText(agentListModels.get(pos).getName());
        holder.cbLabel.setChecked(agentListModels.get(pos).getBoolean());
    }

    @Override
    public int getItemCount() {
        return agentListModels.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        private CheckBox cbLabel;
        private TextView channel_view;

        public ViewHolder(final View itemView) {
            super(itemView);
            cbLabel = itemView.findViewById(R.id.cbLabel);
            channel_view = itemView.findViewById(R.id.channel_view);

            cbLabel.setVisibility(View.VISIBLE);
            channel_view.setVisibility(View.GONE);

            cbLabel.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (compoundButton.isPressed()) {
                        agentListModels.get(getAdapterPosition()).setBoolean(b);
                        int index = list.indexOf(new Filter(agentListModels.get(getAdapterPosition()).getUserId()));
                        if(index >-1) {
                            list.remove(index);
                        } else {
                            list.add(new Filter(agentListModels.get(getAdapterPosition()).getUserId()));
                        }
                    }

                }
            });
        }
    }
}
