package com.hippoagent.fragments

import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.fragment.app.Fragment
import com.hippoagent.BuildConfig
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.activities.PaymentViewActivity
import com.hippoagent.model.LoginResponse.UserData
import com.hippoagent.model.payment.ActiveAgent
import com.hippoagent.model.payment.PaymentModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.filelogger.Logger
import com.hippoagent.utils.Log
import com.hippoagent.utils.loadingBox.LoadingBox
import com.google.gson.Gson
import com.stripe.android.Stripe
import com.stripe.android.TokenCallback
import com.stripe.android.model.Card
import com.stripe.android.model.Token
import kotlinx.android.synthetic.main.fragment_add_card.*
import java.util.*

/**
 * Created by gurmail on 23/04/19.
 * @author gurmail
 */
class AddCardFragment : Fragment(), TokenCallback {

    override fun onSuccess(token: Token) {
        uploadTokenToServer(token)
        Log.v("TAG", "Token = " + Gson().toJson(token))
    }

    override fun onError(error: Exception) {
        LoadingBox.hide()
        Toast.makeText(context, error.localizedMessage, Toast.LENGTH_LONG).show();
    }

    var card: Card? = null
    var strip: Stripe? = null
    var agents: ArrayList<ActiveAgent>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            agents = arguments!!.getSerializable("agents") as ArrayList<ActiveAgent>?
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_add_card, container, false);
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        Log.e("TAG", "agents = "+Gson().toJson(agents))
        setTitle()
        strip = Stripe(context!!, BuildConfig.STRIPE_KEY)

        btnCard.setOnClickListener {
            card = card_multiline_widget.card
            if (card != null && card?.validateCard()!!) {
                LoadingBox.showOn(activity)
                strip?.createToken(card!!, this)
            }
        }
    }

    lateinit var pActivity: PaymentViewActivity

    fun setTitle() {
        try {
            pActivity = activity as PaymentViewActivity
            pActivity.updateTitle("Payment")
        } catch (e: Exception) {
        }
    }

    fun uploadTokenToServer(token: Token) {
        var revoked_invite_ids = intArrayOf()
        var disabled_agent_ids = intArrayOf()
        var count: Int = 0
        if(agents != null) {
            val agentIds = ArrayList<Int>()
            val inviteIds = ArrayList<Int>()
            for (agent: ActiveAgent in agents!!) {
                if(agent.status == 4) {
                    count = count.plus(1)
                    if(!agent.isChecked)
                        inviteIds.add(agent.inviteId)
                }
                else if(agent.status == 1) {
                    count = count.plus(1)
                    if(!agent.isChecked)
                        agentIds.add(agent.userId)
                }
            }

            if(inviteIds.size > 0) {
                Collections.sort(inviteIds)
                revoked_invite_ids = IntArray(inviteIds.size)
                for (i in inviteIds.indices) {
                    println(i)
                    revoked_invite_ids[i] = inviteIds.get(i)
                }
            }

            if(agentIds.size>0) {
                Collections.sort(agentIds)
                disabled_agent_ids = IntArray(agentIds.size)
                for (i in agentIds.indices) {
                    println(i)
                    disabled_agent_ids[i] = agentIds.get(i)
                }
            }
        }

        val params: CommonParams.Builder = CommonParams.Builder()
        params.add("access_token", MyApplication.getInstance().userData.accessToken)
        params.add("stripe_token", token.id)
        params.add("agent_count", count)

        if(disabled_agent_ids.size > 0)
            params.add("to_be_disabled_agent_ids", Arrays.toString(disabled_agent_ids))
        else
            params.add("to_be_disabled_agent_ids", "[]")

        if(revoked_invite_ids.size > 0)
            params.add("to_be_revoked_invite_ids", Arrays.toString(revoked_invite_ids))
        else
            params.add("to_be_revoked_invite_ids", "[]")

        val paramsMap: CommonParams = params.build()

        Logger.apiRequest("/api/billing/startAgentPlan", Gson().toJson(paramsMap.map))
        RestClient.getApiInterface().uploadCardToken(paramsMap.map)
                .enqueue(object : ResponseResolver<PaymentModel>(activity, false, true) {
                    override fun success(t: PaymentModel?) {
                        Logger.apiResponse("/api/billing/startAgentPlan", "")
                        LoadingBox.hide()
                        MyApplication.getInstance().userData.expiryInfo = null
                        val userData: UserData = MyApplication.getInstance().userData
                        userData.expiryInfo = null
                        MyApplication.getInstance().saveUserData(userData)
                        activity?.finish()
                    }

                    override fun failure(error: APIError) {
                        val errorMessage = if (!TextUtils.isEmpty(error.message)) error.message else "Something went wrong"
                        Logger.apiFailed("/api/billing/startAgentPlan", errorMessage)
                        LoadingBox.hide()
                    }

                })
    }


}