package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.Config;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoPaymentActivity;
import com.hippoagent.adapters.SavedPlanAdapter;
import com.hippoagent.callback.OnPlanListener;
import com.hippoagent.model.payment.GetPaymentLinks;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.model.payment.SavedPlanResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.google.gson.Gson;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-12-06.
 *
 * @author gurmail
 */
public class SavedPlanDialog {
    private Activity context;
    private Dialog dialog;

    public SavedPlanDialog(Activity context) {
        this.context = context;
    }


    public Dialog show() {
        try {
            dialog = new Dialog(context, R.style.AppTheme);
            dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogFade;
            dialog.setContentView(R.layout.dialog_show_agents);

            WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            final TextView tvTitle = dialog.findViewById(R.id.tvTitle);
            TextView tvSavedData = dialog.findViewById(R.id.tvSavedData);
            tvSavedData.setVisibility(View.GONE);
            tvTitle.setText(context.getResources().getString(R.string.saved_plan));
            ProgressBar pbLoadReply = dialog.findViewById(R.id.pbLoadReply);
            pbLoadReply.setVisibility(View.GONE);
            ImageView ivClose = dialog.findViewById(R.id.ivClose);
            ImageButton ibSearch =  dialog.findViewById(R.id.ibSearch);
            ibSearch.setVisibility(View.GONE);
            ivClose.setVisibility(View.GONE);

            ImageView backBtn = dialog.findViewById(R.id.backBtn);
            ImageView ivAddNew = dialog.findViewById(R.id.ivAddNew);

            ivAddNew.setVisibility(View.VISIBLE);
            backBtn.setVisibility(View.VISIBLE);

            backBtn.setOnClickListener(v -> dialog.dismiss());

            ivAddNew.setOnClickListener(v -> {
                Intent paymentIntent = new Intent(context, HippoPaymentActivity.class);
                context.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
                dialog.dismiss();
            });

            final RecyclerView rvAgents = dialog.findViewById(R.id.rvAgents);
            rvAgents.setLayoutManager(new LinearLayoutManager(context));
            rvAgents.setItemAnimator(new DefaultItemAnimator());
            rvAgents.setHasFixedSize(false);

            adapter = new SavedPlanAdapter(new OnPlanListener() {
                @Override
                public void onPlanClicked(int pos, @NotNull PlanData planData) {
                    Intent paymentIntent = new Intent(context, HippoPaymentActivity.class);
                    paymentIntent.putExtra("send_plan", true);
                    paymentIntent.putExtra("data", new Gson().toJson(planData));
                    context.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
                    dialog.dismiss();
                }

                @Override
                public void onDeleteClicked(int pos, @NotNull PlanData planData) {

                }
            }, true);

            ivClose.setOnClickListener(v -> dialog.dismiss());

            rvAgents.setAdapter(adapter);
            getSavedCard();

            dialog.show();

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dialog;
    }

    private SavedPlanAdapter adapter;
    private ArrayList<PlanData> plansList = new ArrayList<>();

    private void getSavedCard() {
        if (((FuguChatActivity) context).isNetworkAvailable()) {

            ArrayList<Integer> array = new ArrayList();
            array.add(1);
            GetPaymentLinks paymentLinks = new GetPaymentLinks(MyApplication.getInstance().getUserData().getAccessToken(),
                    0, array);

            RestClient.getApiInterface().getPaymentLinks(paymentLinks).enqueue(new ResponseResolver<SavedPlanResponse>(context, true, true) {
                @Override
                public void success(SavedPlanResponse savedPlanResponse) {
                    try {
                        plansList.addAll(savedPlanResponse.getData());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    adapter.setData(plansList);
                    if(plansList.size() == 0) {
                        Intent paymentIntent = new Intent(context, HippoPaymentActivity.class);
                        context.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
                        dialog.dismiss();
                    }
                }

                @Override
                public void failure(APIError error) {

                }
            });

        } else {
            Toast.makeText(context, context.getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }
}
