package com.hippoagent.dialogs

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.activities.FuguChatActivity
import com.hippoagent.model.Message
import com.hippoagent.model.get_deal_info.GetDealInfo
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Log
import com.hippoagent.utils.Utils
import com.google.gson.Gson
import kotlinx.android.synthetic.main.fragment_dealinfo.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject


/**
 * Created by gurmail on 2020-01-17.
 * @author gurmail
 */
class DealinfoFragment: androidx.fragment.app.DialogFragment() {

    var addDeal: Boolean = false
    lateinit var dealInfo: GetDealInfo
    lateinit var fuguActivity: FuguChatActivity

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        addDeal = arguments?.getBoolean("add_deal", false)!!
        if(arguments?.containsKey("dealInfo")!!)
            dealInfo = Gson().fromJson(arguments!!.getString("dealInfo"), GetDealInfo::class.java)

        setStyle(androidx.fragment.app.DialogFragment.STYLE_NORMAL, R.style.FullScreenDialogStyle);
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_dealinfo, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        my_toolbar.title = ""
        my_toolbar.setNavigationIcon(R.drawable.ic_close)

        if(addDeal) {
            tv_toolbar_name.text = activity?.getString(R.string.add_deal)!!
            tvSaveBtn.visibility = View.GONE
            apply_btn.visibility = View.VISIBLE
            addDealData()
        } else {
            tv_toolbar_name.text = activity?.getString(R.string.edit_deal)!!
            tvSaveBtn.visibility = View.VISIBLE
            apply_btn.visibility = View.GONE
            setDealData()
        }
        setHasOptionsMenu(true)

        apply_btn.setOnClickListener {

            if (etDealName.text.toString().isEmpty()) {
                Toast.makeText(activity, "*Please enter deal name", Toast.LENGTH_SHORT).show()
            } else if (etDealEmail.text.toString().isEmpty()) {
                Toast.makeText(activity, "*Please enter email", Toast.LENGTH_SHORT).show()
            } else if (!Utils.isValidEmail(etDealEmail.text.toString())) {
                Toast.makeText(activity, "*Please enter valid email", Toast.LENGTH_SHORT).show()
            } else if (etDealPhone.text.toString().isEmpty()) {
                Toast.makeText(activity, "*Please enter valid phone no", Toast.LENGTH_SHORT).show()
            } else {
                addDeal()
                fuguActivity.editUserDetails(false, etDealEmail.text.toString(), etDealPhone.text.toString())
            }
        }

    }

    private fun addDealData() {
        rlDeal.visibility = View.VISIBLE
        rlEmail.visibility = View.VISIBLE
        rlDealPhone.visibility = View.VISIBLE
        rlDealCompant.visibility = View.VISIBLE
        apply_btn.visibility = View.VISIBLE

        etDealName.isEnabled = true
        etDealName.isFocusableInTouchMode = true
        etDealEmail.isEnabled = true
        etDealEmail.isFocusableInTouchMode = true
        etDealPhone.isEnabled = true
        etDealPhone.isFocusableInTouchMode = true
        etDealCompany.isEnabled = true
        etDealCompany.isFocusableInTouchMode = true
    }

    private fun setDealData() {

        rlEmail.visibility = View.VISIBLE
        rlDealPhone.visibility = View.VISIBLE

        etDealEmail.isEnabled = true
        etDealEmail.isFocusableInTouchMode = true
        etDealPhone.isEnabled = true
        etDealPhone.isFocusableInTouchMode = true

        if (dealInfo != null && dealInfo.getData().data[0].contactInfo.size > 0) {
            if (dealInfo.data.data[0].contactInfo[0].email.size > 0) {
                if (!dealInfo.getData().getData().get(0).getContactInfo().get(0).getEmail().get(0).getEmail().isEmpty()) {
                    etDealEmail.setText(dealInfo.getData().getData().get(0).getContactInfo().get(0).getEmail().get(0).getEmail())
                }
            }
            if (dealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().size > 0) {
                if (!dealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().get(0).getPhone().isEmpty()) {
                    val customerPhone = dealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().get(0).getPhone()
                    etDealPhone.setText(customerPhone)
                }
            }

        }
//        etDealEmail.text = ""
//        etDealPhone.text = ""
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        fuguActivity = context as FuguChatActivity
    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onResume() {
        super.onResume()

    }

    private fun addDeal() {
        var contactInfo: JSONObject? = null
        var companyInfo: JSONObject? = null
        var messageData: JSONObject? = null
        var tagsArray: JSONArray? = null
        try {
            contactInfo = JSONObject()
            val email = JSONArray()
            val emailObj = JSONObject()
            emailObj.put("email", if (etDealEmail.text.toString().isEmpty()) "" else etDealEmail.text.toString())
            email.put(emailObj)

            val phone = JSONArray()
            val phoneObj = JSONObject()
            phoneObj.put("phone", if (etDealPhone.text.toString().isEmpty()) "" else etDealPhone.text.toString())
            phone.put(phoneObj)

            contactInfo.put("email", email)
            contactInfo.put("phone", phone)
            contactInfo.put("name", if (etDealName.text.toString().isEmpty()) "" else etDealName.text.toString())

            tagsArray = JSONArray()
            val tagObject = JSONObject()
            tagObject.put("tag_name", "chat lead")
            tagsArray.put(tagObject)

            companyInfo = JSONObject()
            companyInfo.put("name", if (etDealCompany.text.toString().isEmpty()) "" else etDealCompany.text.toString())

            messageData = JSONObject()
            val currentOrderItem: Message? = null
            messageData.put("message", "message")
        } catch (e: JSONException) {
            Log.e("JSONException of addDealToBulbul", e.message)
        }


        var assignTo = 0
        if (assign_checkbox.isChecked())
            assignTo = 1


        val commonParams = CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, if (MyApplication.getInstance().userData.accessToken == null) "" else MyApplication.getInstance().userData.accessToken)
                .add("contact_info", contactInfo)
                .add("tags", tagsArray)
                .add("deal_name", if (etDealName.text.toString().isEmpty()) "" else etDealName.text.toString())
                .add("created_by", MyApplication.getInstance().userData.fullName)
                .add("organization_data", companyInfo)
                .add("crm_type", MyApplication.getInstance().userData.businessProperty.crmIntegrationType)
                .add("assign_to_me", assignTo)

        fuguActivity.pushDealToBulbul(commonParams)
    }



}