package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.CannedMessageAdapter;
import com.hippoagent.adapters.ShowAgentsAdapter;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.Log;
import com.google.gson.Gson;

import java.util.ArrayList;

/**
 * Created by ankit on 29/06/17.
 */

public class CannedDialog {
    private Context context;
    private Callback callback;
    private Dialog dialog;
    private ProgressBar pbLoadReply;
    private CannedMessageAdapter cannedMessageAdapter;
    private ArrayList<CannedMessageResponse.Data> cannedList = new ArrayList<>();
    private ArrayList<CannedMessageResponse.Data> filteredCannedList;
    TextView tvSavedData;

    public CannedDialog(Context context, Callback callback) {
        this.context = context;
        this.callback = callback;
    }

    public Dialog show() {
        try {
            dialog = new Dialog(context, R.style.AppTheme);
            dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogBottomIn;
            dialog.setContentView(R.layout.dialog_show_agents);

            WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            ShowAgentsAdapter showAgentsAdapter;
            final TextView tvTitle = (TextView) dialog.findViewById(R.id.tvTitle);
            tvSavedData = (TextView) dialog.findViewById(R.id.tvSavedData);
            tvTitle.setText(context.getResources().getString(R.string.saved_replies));
            pbLoadReply = (ProgressBar) dialog.findViewById(R.id.pbLoadReply);
            pbLoadReply.setVisibility(View.VISIBLE);
            ImageView ivClose = (ImageView) dialog.findViewById(R.id.ivClose);
            //final ImageButton ibSearch = (ImageButton) dialog.findViewById(R.id.ibSearch);
            final EditText etSearch = (EditText) dialog.findViewById(R.id.etSearch);
            final RecyclerView rvAgents = (RecyclerView) dialog.findViewById(R.id.rvAgents);
            rvAgents.setLayoutManager(new LinearLayoutManager(context));
            rvAgents.setItemAnimator(new DefaultItemAnimator());
            rvAgents.setHasFixedSize(false);
            /*etSearch.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    etSearch.setFocusable(true);
                    return false;
                }
            });*/
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    filteredCannedList = new ArrayList<>();
                    for (int i = 0; i < cannedList.size(); i++) {
                        if (cannedList.get(i).getMessage().toLowerCase().contains(editable.toString().toLowerCase())||cannedList.get(i).getTitle().toLowerCase().contains(editable.toString().toLowerCase())) {
                            CannedMessageResponse.Data savedReplies = new CannedMessageResponse.Data();
                            savedReplies.setMessage(cannedList.get(i).getMessage());
                            savedReplies.setMessageId(cannedList.get(i).getMessageId());
                            savedReplies.setSku(cannedList.get(i).getSku());
                            savedReplies.setTitle(cannedList.get(i).getTitle());
                            filteredCannedList.add(savedReplies);
                        }
                    }
                    cannedMessageAdapter = new CannedMessageAdapter(context, filteredCannedList, new CannedMessageAdapter.Callback() {
                        @Override
                        public void onClick(int position, CannedMessageResponse.Data cannedMessage) {
                            dialog.dismiss();
                            callback.onClick(position, cannedMessage);
                        }
                    });

                    rvAgents.setAdapter(cannedMessageAdapter);
                }
            });
            /*ibSearch.setVisibility(View.VISIBLE);
            ibSearch.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    tvTitle.setVisibility(View.GONE);
                    ibSearch.setVisibility(View.GONE);
                    etSearch.setVisibility(View.VISIBLE);
                    new Handler().post(new Runnable() {
                        @Override
                        public void run() {
                            etSearch.requestFocus();
                            InputMethodManager input = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
                            input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                        }
                    });
                }
            });*/

            cannedMessageAdapter = new CannedMessageAdapter(context, cannedList, new CannedMessageAdapter.Callback() {
                @Override
                public void onClick(int position, CannedMessageResponse.Data cannedMessage) {
                    dialog.dismiss();
                    callback.onClick(position, cannedMessage);
                }
            });

            rvAgents.setAdapter(cannedMessageAdapter);
            ivClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(callback != null)
                        callback.onCancel();
                    /*if (etSearch.getVisibility() == View.VISIBLE) {
                        InputMethodManager input = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
                        input.toggleSoftInput(InputMethodManager.HIDE_IMPLICIT_ONLY, 0);
                        tvTitle.setVisibility(View.VISIBLE);
                        etSearch.setVisibility(View.GONE);
                        //ibSearch.setVisibility(View.VISIBLE);
                        etSearch.setText("");
                        return;
                    }*/
                    dialog.dismiss();
                }
            });

            dialog.show();

            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    apiGetCannedMessages();
                }
            }, 300);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dialog;
    }

    public interface Callback {
        void onClick(int pos, CannedMessageResponse.Data cannedMessage);
        void onCancel();
    }

    private void apiGetCannedMessages() {
        if (((FuguBaseActivity) context).isNetworkAvailable()) {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().getUserData().getAccessToken())
                    .build();
            Logger.INSTANCE.apiRequest("/api/business/getCannedMessages", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().getCannedMessages(commonParams.getMap())
                    .enqueue(new ResponseResolver<CannedMessageResponse>((Activity) context, false, true) {
                        @Override
                        public void success(CannedMessageResponse cannedMessageResponse) {
                            Logger.INSTANCE.apiResponse("/api/business/getCannedMessages","");
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == cannedMessageResponse.getStatuscode()) {
                                    cannedList.clear();
                                    cannedList.addAll(cannedMessageResponse.getData());
                                    pbLoadReply.setVisibility(View.GONE);
                                    cannedMessageAdapter.notifyDataSetChanged();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                Logger.INSTANCE.apiFailed("/api/business/getCannedMessages",e.getLocalizedMessage());
                            }
                            if (cannedList.size() < 1) {
                                tvSavedData.setVisibility(View.VISIBLE);
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/business/getCannedMessages",error.getMessage());
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(context, context.getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }
}
