package com.hippoagent.datastructure;

import android.os.Environment;

import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Bhavya Rattan on 10/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public interface FuguAppConstant {

    String CONFERENCING_TEST = "https://conference-dev.officechat.io";
    String CONFERENCING_LIVE = "https://conference.hippochat.io";
//    String CONFERENCING_LIVE = CONFERENCING_TEST;

    int FREE_TRIAL_EXPIRED = 402;
    int SESSION_EXPIRE = 403;
    int INVALID_VIDEO_CALL_CREDENTIALS = 413;
    String NOTIFICATION_INTENT = "notification_received";
    String FUGU_WEBSITE_URL = "https://fuguchat.com";
    String NETWORK_STATE_INTENT = "network_state_changed";
//    String LOCAL_FORM_MESSAGE = "local_form_data";
    String LOCAL_PUSH_NOTIFICATION = "local_push_notification";
    String FUGU_LISTENER_NULL = "fugu_listener_null";
    public String RECIEVER_AGENT_UPDATE = "com.fugu.agent.update";
    String NOTIFICATION_TYPE="notification_type";
    String USER_DETAILS="userDetails";
    String CUSTOM_ACTION = "custom_action";

    int READ_MESSAGE=6;
    int ASSIGN_CHAT=3;
    int AGENT_STATUS_CHANGED=11;
    int NEW_AGENT_ADDED=10;
    int DEFAULT_NOTIFICATION_TYPE=-1;
    int USER_MIGRATION = 7;
    int USER_ONLINE = 16;
    int DEFAULT_MESSAGE_INDEX = -1;
    int BOT_ENDED = 17;
    int IMAGE_MESSAGE = 10;
    int TEXT_MESSAGE = 1;
    int ASSIGNMENT_MESSAGE = 2;
    int PRIVATE_NOTE = 3;
    int FILE_MESSAGE = 11;
    int FEEDBACK_MESSAGE = 14;
    int BOT_TEXT_MESSAGE = 15;
    int BOT_BUTTON_MESSAGE = 16;
    int BOT_FORM_MESSAGE = 17;
    int VIDEO_CALL = 18;
    int ACTION_MESSAGE_NEW = 19;
    int USER_CONCENT_MESSAGE = 20;
    int USER_CONCENT_MESSAGE_LOCAL = 51;

    int VIDEO_CALL_VIEW = 1;
    int AUDIO_CALL_VIEW = 2;

    int CHANNEL_SUBSCRIBED = 1;
    int CHANNEL_UNSUBSCRIBED = 0;

    int STATUS_CHANNEL_CLOSED = 0;

    int TYPING_SHOW_MESSAGE = 0;
    int TYPING_STARTED = 1;
    int TYPING_STOPPED = 2;

    int MESSAGE_SENT = 1;
    int MESSAGE_DELIVERED = 2;
    int MESSAGE_READ = 3;
    int MESSAGE_UNSENT = 4;
    int MESSAGE_IMAGE_RETRY = 5;
    int MESSAGE_FILE_RETRY = 6;
    int MESSAGE_FILE_UPLOADED = 7;

    int PERMISSION_CONSTANT_CAMERA = 9;
    int PERMISSION_CONSTANT_GALLERY = 8;
    int PERMISSION_READ_FILE = 4;
    int PERMISSION_SAVE_BITMAP = 5;


    String IMAGE_DIRECTORY = Environment.getExternalStorageDirectory() + File.separator + "fugu" +
            File.separator + "picture";
    String CONVERSATION = "conversation";
    String SHOW_UPDATE="show_update";
    String UPDATE_TITLE="update_title";
    String UPDATE_LINK="update_link";
    String AGENT_NAME="agent_name";
    String AGENT_PIC="agent_pic";

    String OFFLINE="OFFLINE";
    String AVAILABLE="AVAILABLE";
    String AWAY="AWAY";

    String VIDEO_CALL_MODEL = "video_Call_model";
    String INIT_FULL_SCREEN_SERVICE = "init_full_screen_service";
    String CALL_STATUS = "call_status";
    String CHANNEL_ID = "channel_id";
    String CHANNEL_NAME = "channel_name";
    String MESSAGE_UNIQUE_ID = "muid";
    String VIDEO_CALL_TYPE = "video_call_type";
    String IS_SILENT = "is_silent";
    String TITLE = "title";
    String USER_ID = "user_id";
    String FULL_NAME = "full_name";
    String MESSAGE_TYPE = "message_type";
    String IS_TYPING = "is_typing";
    String DEVICE_ID = "device_id";
    String DEVICE_TYPE = "device_type";
    String APP_VERSION="app_version";
    String DEVICE_DETAILS = "device_details";
    int ANDROID_USER = 1;
    String VIDEO_CALL_INTENT = "hippo_video_call_intent";
    String VIDEO_CALL_HUNGUP = "hippo_video_call_hungup";
    String PEER_CHAT_PARAMS = "peer_chat_params";
    String IS_BOT_IN_PROGRESS = "is_bot_in_progress";


    String INVITE_LINK = "invite_link";
    String VIDEO_CONFERENCE_HUNGUP_INTENT = "video_conference_hungup_intent";
    String INCOMING_VIDEO_CONFERENCE = "incoming_video_conference";
    String ROOM_NAME = "room_name";
    String BASE_URL = "base_url";

    /**
     * The type of file being Saved
     */
//    enum FileType {
//
//        LOG_FILE("logs", ".log"),
//        IMAGE_FILE("snapshots", ""),
//        GENERAL_FILE("public", ".txt"),
//        PRIVATE_FILE("system", ".sys");
//
//        public final String extension;
//        public final String directory;
//
//        FileType(String relativePath, String extension) {
//            this.extension = extension;
//            this.directory = relativePath;
//        }
//    }

    public enum CallType {
        AUDIO("AUDIO"),
        VIDEO("VIDEO");

        public final String type;


        /**
         * @param type
         */
        CallType(final String type) {
            this.type = type;
        }

        /* (non-Javadoc)
         * @see java.lang.Enum#toString()
         */
        @Override
        public String toString() {
            return type;
        }
    }


    int RC_READ_EXTERNAL_STORAGE = 123;
    int RC_OPEN_CAMERA = 124;
    int OPEN_CAMERA_ADD_IMAGE = 514;
    int OPEN_GALLERY_ADD_IMAGE = 515;
    int SELECT_FILE = 516;
    int SELECT_AUDIO = 518;
    int SELECT_DOCUMENT = 517;
    int SELECT_VIDEO = 519;
    int SELECT_NONE = 600;


    String IMAGE_FOLDER = "image";
    String DOC_FOLDER = "file";
    String AUDIO_FOLDER = "audio";
    String VIDEO_FOLDER = "video";

    String BROADCAST_STATUS = "broadcast_status";
    final String KEY = "pref_upload_data";
    String HIPPO_FILE_UPLOAD = "HIPPO_FILE_UPLOAD";

    int MAX_HEIGHT = 250;
    int MAX_WIDTH = 250;
    int MAX_WIDTH_OUTER_SPIKED = 252;
    int MAX_WIDTH_OUTER = 255;

    int UPLOAD_FAILED = 0;
    int UPLOAD_IN_PROGRESS = 1;
    int UPLOAD_PAUSED = 2;
    int UPLOAD_COMPLETED = 3;

    String IMAGE_URL = "image_url";
    String THUMBNAIL_URL = "thumbnail_url";
    String USER_IMAGE = "user_image";

    // for file downloading
    String HIPPO_PROGRESS_INTENT = "hippo_progress_intent";
    String HIPPO_POSITION = "hippo_position";
    String HIPPO_PROGRESS = "hippo_progress";
    String HIPPO_STATUS_UPLOAD = "hippo_statusUpload";

    public enum DocumentType {
        IMAGE("image"),
        AUDIO("audio"),
        VIDEO("video"),
        FILE("file");

        public final String type;

        DocumentType(final String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return type;
        }
    }

    interface BroadCastStatus {
        int UPLOADED_SUCESSFULLY = 0;
        int UPLOADING_FAILED = 1;
        int PUBLISHED = 2;
        int MESSAGE_EXPIRED = 3;
        int CREATE_CHANNEL = 4;
    }

    String prefix = (HippoConfig.getInstance().getAttributes().getIsWhitelabel())? "" : "Hippo ";

    HashMap<String, String> FOLDER_TYPE = new HashMap<String, String>() {{
        put("audio", prefix+"Audio");
        put("video", prefix+"Hippo Video");
        put("file", prefix+"Documents");
        put("image", prefix+"Images");
    }};

    interface MimeTypeConstants {
        String MIME_TYPE_IMAGE_JPEG = "image/jpeg";
        String MIME_TYPE_IMAGE_JPG  = "image/pjpeg";
        String MIME_TYPE_IMAGE_PNG  = "image/png";
        String MIME_TYPE_PDF        = "application/pdf";
        String MIME_TYPE_CSV_1      = "text/csv";
        String MIME_TYPE_CSV_2      = "text/comma-separated-values";
        String MIME_TYPE_DOC        = "application/msword";
        String MIME_TYPE_DOCX       = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        String MIME_TYPE_PPT        = "application/vnd.ms-powerpoint";
        String MIME_TYPE_PPTX       = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        String MIME_TYPE_XLS        = "application/vnd.ms-excel";
        String MIME_TYPE_XLSX       = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        String MIME_TYPE_TXT        = "text/plain";
    }

    Map<String, String> MIME_TYPE_SET = new HashMap<String, String>() {{
        put(".doc", "application/msword");
        put(".ppt", "application/vnd.ms-powerpoint");
        put(".pdf", "application/pdf");
        put(".xls", "application/vnd.ms-excel");
        put(".zip", "application/x-wav");
        put(".rtf", "application/rtf");
        put(".wav", "audio/x-wav");
        put(".jpg", "image/jpeg");
        put(".csv", "text/csv");
        put(".apk", "application/vnd.android.package-archive");
        put(".3gp", "video/*");
        put("default", "*/*");
    }};

    HashMap<String, Integer> IMAGE_MAP = new HashMap<String, Integer>() {{
        put("txt", R.drawable.hippo_txt);
        put("pdf", R.drawable.hippo_pdf);
        put("csv", R.drawable.hippo_csv);
        put("doc", R.drawable.hippo_doc);
        put("docx", R.drawable.hippo_doc);
        put("ppt", R.drawable.hippo_ppt);
        put("pptx", R.drawable.hippo_ppt);
        put("xls", R.drawable.hippo_excel);
        put("xlsx", R.drawable.hippo_excel);
        put("apk", R.drawable.hippo_android);
        put("ipa", R.drawable.hippo_apple);
        put("zip", R.drawable.hippo_attachment);
        put("3gp", R.drawable.hippo_attachment);
        put("mp3", R.drawable.hippo_music);
        put("midi", R.drawable.hippo_music);
        put("mpeg", R.drawable.hippo_music);
        put("x-aiff", R.drawable.hippo_music);
        put("x-wav", R.drawable.hippo_music);
        put("webm", R.drawable.hippo_music);
        put("ogg", R.drawable.hippo_music);
        put("m4a", R.drawable.hippo_music);
        put("wav", R.drawable.hippo_music);

    }};
    HashMap<String, String> EXTENSION_MAP = new HashMap<String, String>() {{
        put("txt", ".txt");
        put("pdf", ".pdf");
        put("csv", ".csv");
        put("doc", ".doc");
        put("docx", ".doc");
        put("ppt", ".ppt");
        put("pptx", ".ppt");
        put("xls", ".xls");
        put("xlsx", ".xls");
        put("apk", ".apk");
        put("ipa", ".ipa");
        put("mp3", ".wav");
        put("3gp", ".3gp");
        put("midi", ".wav");
        put("mpeg", ".wav");
        put("x-aiff", ".wav");
        put("x-wav", ".wav");
        put("webm", ".wav");
        put("ogg", ".wav");
        put("m4a", ".wav");
        put("wav", ".wav");
        put("mpg", ".3gp");
        put("mpeg", ".3gp");
        put("mpe", ".3gp");
        put("mp4", ".3gp");
        put("avi", ".3gp");
    }};

    /**
     * The type of file being Saved
     */
    enum FileType {

        LOG_FILE("logs", ".log"),
        DOC_FILE("Fugu", ".doc"),
        DOCX_FILE("Fugu", ".docx"),
        TXT_FILE("Fugu", ".txt"),
        PPT_FILE("Fugu", ".ppt"),
        PPTX_FILE("Fugu", ".pptx"),
        IPA_FILE("Fugu", ".ipa"),
        XLS_FILE("Fugu", ".xls"),
        XLSX_FILE("Fugu", ".xlsx"),
        APK_FILE("Fugu", ".apk"),
        CSV_FILE("Fugu", ".csv"),
        IMAGE_FILE("Fugu", ".jpg"),
        GENERAL_FILE("Fugu", ".txt"),
        PDF_FILE("Fugu", ".pdf"),
        MP3_FILE("Fugu", ".mp3"),
        PRIVATE_FILE("system", ".sys"),
        TGP_FILE("Fugu", ".3gp"),
        MIDI_FILE("Fugu", ".midi"),
        MPEG_FILE("Fugu", ".mpeg"),
        XAIFF_FILE("Fugu", ".x-aiff"),
        XWAV_FILE("Fugu", ".x-wav"),
        WEBM_FILE("Fugu", ".webm"),
        OGG_FILE("Fugu", ".ogg"),
        M4A_FILE("Fugu", ".m4a"),
        WAV_FILE("Fugu", ".wav"),
        MP4_FILE("Fugu", ".mp4"),
        FLV_FILE("Fugu", ".flv"),
        MKV_FILE("Fugu", ".mkv"),
        MOV_FILE("Fugu", ".mov"),
        MPG_FILE("Fugu", ".mpg"),
        JPG_FILE("Fugu", ".jpg"),
        MTS_FILE("Fugu", ".mts"),
        TGPP_FILE("Fugu", ".3gpp");

        public final String extension;
        public final String directory;

        FileType(String relativePath, String extension) {
            this.extension = extension;
            this.directory = relativePath;
        }
    }

    HashMap<String, FileType> FILE_TYPE_MAP = new HashMap<String, FileType>() {{
        put("pdf", FileType.PDF_FILE);
        put("ppt", FileType.PPT_FILE);
        put("pptx", FileType.PPTX_FILE);
        put("xls", FileType.XLS_FILE);
        put("xlsx", FileType.XLSX_FILE);
        put("txt", FileType.TXT_FILE);
        put("csv", FileType.CSV_FILE);
        put("doc", FileType.DOC_FILE);
        put("docx", FileType.DOCX_FILE);
        put("apk", FileType.APK_FILE);
        put("ipa", FileType.IPA_FILE);
        put("default", FileType.IMAGE_FILE);
        put("mp4", FileType.MP4_FILE);
        put("flv", FileType.FLV_FILE);
        put("mkv", FileType.MKV_FILE);
        put("mov", FileType.MOV_FILE);

        put("3gp", FileType.TGP_FILE);
        put("mp3", FileType.MP3_FILE);
        put("midi", FileType.MIDI_FILE);
        put("mpeg", FileType.MPEG_FILE);
        put("x-aiff", FileType.XAIFF_FILE);
        put("mpeg", FileType.MPEG_FILE);
        put("x-wav", FileType.XWAV_FILE);
        put("webm", FileType.WEBM_FILE);
        put("ogg", FileType.OGG_FILE);
        put("m4a", FileType.M4A_FILE);
        put("wav", FileType.WAV_FILE);

        put("mov", FileType.MOV_FILE);
        put("3gpp", FileType.TGPP_FILE);
        put("mts", FileType.MTS_FILE);
        put("mpg", FileType.MPG_FILE);
        put("jpg", FileType.JPG_FILE);
    }};

    enum DownloadStatus {
        DOWNLOAD_FAILED(0),
        DOWNLOAD_IN_PROGRESS(1),
        DOWNLOAD_PAUSED(2),
        DOWNLOAD_COMPLETED(3);

        public final int downloadStatus;

        DownloadStatus(int downloadStatus) {
            this.downloadStatus = downloadStatus;
        }
    }

    enum JitsiCallType {
        START_CONFERENCE {
            @Override
            public String toString() {
                return "START_CONFERENCE";
            }
        },
        START_CONFERENCE_IOS {
            @Override
            public String toString() {
                return "START_CONFERENCE";
            }
        },
        READY_TO_CONNECT_CONFERENCE {
            @Override
            public String toString() {
                return "READY_TO_CONNECT_CONFERENCE";
            }
        },
        READY_TO_CONNECT_CONFERENCE_IOS {
            @Override
            public String toString() {
                return "READY_TO_CONNECT_CONFERENCE_IOS";
            }
        },
        HUNGUP_CONFERENCE {
            @Override
            public String toString() {
                return "HUNGUP_CONFERENCE";
            }
        },
        REJECT_CONFERENCE {
            @Override
            public String toString() {
                return "REJECT_CONFERENCE";
            }
        },
        USER_BUSY_CONFERENCE {
            @Override
            public String toString() {
                return "USER_BUSY_CONFERENCE";
            }
        },
        OFFER_CONFERENCE {
            @Override
            public String toString() {
                return "OFFER_CONFERENCE";
            }
        },
        ANSWER_CONFERENCE {
            @Override
            public String toString() {
                return "ANSWER_CONFERENCE";
            }
        }
    }

    enum FayeBusEvent {
        CONNECTED {
            @Override
            public String toString() {
                return "connected";
            }
        },
        DISCONNECTED {
            @Override
            public String toString() {
                return "disconnected";
            }
        },
        MESSAGE_RECEIVED {
            @Override
            public String toString() {
                return "message_received";
            }
        },
        ERROR {
            @Override
            public String toString() {
                return "error";
            }
        },
        PING {
            @Override
            public String toString() {
                return "ping";
            }
        }
    }

    enum Feedback {
        HELP {
            @Override
            public String toString() {
                return "HELP";
            }
        },
        AUDIO_CALL {
            @Override
            public String toString() {
                return "AUDIO_CALL";
            }
        },
        VIDEO_CALL {
            @Override
            public String toString() {
                return "VIDEO_CALL";
            }
        },
        VIDEO_CONFERENCE {
            @Override
            public String toString() {
                return "VIDEO_CONFERENCE";
            }
        }
    }
}
