package com.hippoagent.confcall

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.hippoagent.BuildConfig
import com.hippoagent.MyApplication
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.hippocall.CommonData
import com.hippoagent.hippocall.HippoCallConfig
import com.hippoagent.hippocall.WebRTCCallConstants
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.DEVICE_PAYLOAD
import com.hippoagent.utils.UniqueIMEIID
import org.json.JSONObject

class HungUpBroadcast : BroadcastReceiver() {
    override fun onReceive(context: Context?, intent: Intent?) {

        if (intent?.getStringExtra("action").equals("rejectCall")) {
            val startIntent = Intent(context, OngoingCallService::class.java)
            context?.stopService(startIntent)

            val userId = MyApplication.getInstance().userData.userId
            val devicePayload = JSONObject()
            try {
                devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context))
                devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
                devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
                devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context))
            } catch (e: Exception) {
                e.printStackTrace()
            }


            val startCallJson = JSONObject()
            startCallJson.put(FuguAppConstant.IS_SILENT, true)
            startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.REJECT_CONFERENCE.toString())
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, intent?.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L))
            startCallJson.put(WebRTCCallConstants.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            startCallJson.put(WebRTCCallConstants.MESSAGE_UNIQUE_ID, intent?.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID))
            startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, devicePayload)
            startCallJson.put(WebRTCCallConstants.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context))
            startCallJson.put(FuguAppConstant.INVITE_LINK, intent?.getStringExtra(FuguAppConstant.INVITE_LINK))

            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
            if (intent?.hasExtra(DEVICE_PAYLOAD)!!) {
                HippoCallConfig.getInstance().sendMessage(intent?.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L), startCallJson)
            }

            OngoingCallService.NotificationServiceState.isConferenceServiceRunning = false
            OngoingCallService.NotificationServiceState.isConferenceConnected = false
        } else if(intent?.getStringExtra("action").equals("hungupCall")) {
            try {
                val mIntent = Intent("CALL_HANGUP")
                LocalBroadcastManager.getInstance(context!!).sendBroadcast(mIntent)
            } catch (e: Exception) {
            }

            val startIntent = Intent(context, OngoingCallService::class.java)
            context?.stopService(startIntent)

            val userId = MyApplication.getInstance().userData.userId
            val devicePayload = JSONObject()
            try {
                devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context))
                devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
                devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
                devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(context))
            } catch (e: Exception) {
                e.printStackTrace()
            }


            val startCallJson = JSONObject()
            startCallJson.put(FuguAppConstant.IS_SILENT, true)
            startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.JitsiCallType.HUNGUP_CONFERENCE.toString())
            startCallJson.put(FuguAppConstant.USER_ID, userId)
            startCallJson.put(FuguAppConstant.CHANNEL_ID, intent?.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L))
            startCallJson.put(WebRTCCallConstants.MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
            startCallJson.put(WebRTCCallConstants.CALL_TYPE, "VIDEO")
            startCallJson.put(WebRTCCallConstants.MESSAGE_UNIQUE_ID, intent?.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID))
            startCallJson.put(WebRTCCallConstants.DEVICE_PAYLOAD, devicePayload)
            startCallJson.put(WebRTCCallConstants.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(context))
            startCallJson.put(FuguAppConstant.INVITE_LINK, intent?.getStringExtra(FuguAppConstant.INVITE_LINK))

            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER)
            if (intent?.hasExtra(DEVICE_PAYLOAD)!!) {
                HippoCallConfig.getInstance().sendMessage(intent?.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L), startCallJson)
            }
        }


    }
}