package com.hippoagent.appData;

/**
 * Created by gurmail on 16/05/18.
 *
 * @author gurmail
 */
public enum UserOnBoard {

    NONE(0),
    ONLY_NAME(1),
    ONLY_PASSWORD(2),
    BOTH_NAME_PASSWORD(3);

    private final int screenCode;

    /**
     * Constructor
     *
     * @param screenCode
     */
    UserOnBoard(int screenCode) {
        this.screenCode = screenCode;
    }

    /**
     * @param screenCode
     * @return
     */
    public static UserOnBoard get(int screenCode) {

        UserOnBoard status = NONE;

        for (UserOnBoard value : values()) {
            if (value.getScreenCode() == screenCode) {
                status = value;
                break;
            }
        }

        return status;
    }

    public int getScreenCode() {
        return screenCode;
    }
}
