package com.hippoagent.apis

import android.app.Activity
import com.google.gson.Gson
import com.hippoagent.MyApplication
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.ApiResponseFlags
import com.hippoagent.model.LoginResponse.LoginResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Log
import com.hippoagent.utils.SPLabels
import com.hippoagent.utils.UniqueIMEIID
import com.hippoagent.utils.filelogger.Logger
import io.paperdb.Paper

/**
 * Created by gurmail on 2020-05-01.
 * @author gurmail
 */
object HippoLogout {

    fun logout(activity: Activity) {
        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)
        val commonParams = CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, MyApplication.getInstance()?.userData?.accessToken)
                .add(Constants.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity))
                .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                .build()
        Logger.apiRequest("/api/agent/agentLogout", Gson().toJson(commonParams.map))
        RestClient.getApiInterface().logout(commonParams.map)
                .enqueue(object : ResponseResolver<LoginResponse>(activity, true, true) {
                    override fun success(loginResponse: LoginResponse) {
                        Logger.apiResponse("/api/agent/agentLogout", "")
                        try {
                            if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.statusCode) {
                                MyApplication.getInstance().logout(activity)
                            }
                        } catch (e: Exception) {
                            Logger.apiFailed("/api/agent/agentLogout", e.localizedMessage)
                            e.printStackTrace()
                        }

                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("/api/agent/agentLogout", error.message)
                        Log.e("error", "error")
                    }
                })
    }
}