package com.hippoagent.adapters;

import android.app.Activity;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fragments.ChatOptionFragment;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.utils.LoadImageFile;

import java.util.ArrayList;

import de.hdodenhof.circleimageview.CircleImageView;

/**
 * Created by gurmail on 17/05/19.
 *
 * @author gurmail
 */
public class ShowAgentsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<GetAgentsResponse.Agents> agentsList;
    private ChatOptionFragment.Callback callback;

    public ShowAgentsAdapter(Activity activity, ArrayList<GetAgentsResponse.Agents> agentsList, ChatOptionFragment.Callback callback) {
        this.activity = activity;
        this.agentsList = agentsList;
        this.callback = callback;
    }

    public void setData(ArrayList<GetAgentsResponse.Agents> agentsList) {
        this.agentsList = agentsList;
        notifyDataSetChanged();
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_agents, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder) viewholder;
            GetAgentsResponse.Agents agent = agentsList.get(position);
            holder.rlAgents.setTag(position);
            if (agent.getUserImage() != null) {
                LoadImageFile.getInstance().loadImage(activity, agent.getUserImage(),
                        R.drawable.agent_ic_profile_placeholder, holder.ivAssignAgentImage, 1);
//                    Glide.with(activity).load(agent.getUserImage())
//                            .placeholder(ContextCompat.getDrawable(activity, R.drawable.agent_ic_profile_placeholder))
//                            .dontAnimate()
//                            .error(ContextCompat.getDrawable(activity, R.drawable.agent_ic_profile_placeholder))
//                            .into(holder.ivAssignAgentImage);
            }
            if (MyApplication.getInstance().getUserData().getUserId() == agent.getUserId()) {
                holder.tvName.setText("Me");
            } else {
                holder.tvName.setText(agent.getFullName());
            }
            if (agent.getOnlineStatus().equals(FuguAppConstant.AVAILABLE)) {
                holder.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_available_without_border));
            } else if (agent.getOnlineStatus().equals(FuguAppConstant.AWAY)) {
                holder.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_away_without_border));
            } else {
                holder.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_offline_without_border));
            }
            holder.rlAgents.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = (int) v.getTag();
                    callback.onClick(pos, agentsList.get(pos));
                }
            });
        }
    }

    @Override
    public int getItemCount() {
        if (agentsList == null || agentsList.size() == 0) {
            return 0;
        } else {
            return agentsList.size();
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        public RelativeLayout rlAgents;
        public TextView tvName;
        public CircleImageView ivAssignAgentImage;
        public View viewStatus;

        public ViewHolder(final View itemView) {
            super(itemView);
            rlAgents = (RelativeLayout) itemView.findViewById(R.id.rlAgents);
            tvName = (TextView) itemView.findViewById(R.id.tvName);
            ivAssignAgentImage = (CircleImageView) itemView.findViewById(R.id.ivAssignAgentImage);
            viewStatus = (View) itemView.findViewById(R.id.viewStatus);
        }
    }
}
