package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.databinding.LayoutLoadmoreBinding;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.conversation_search.User;

import java.util.ArrayList;
import java.util.List;

public class PeopleAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context context;
    private List<User> peopleData = new ArrayList<>();
    private PeopleClickListener peopleClickListener;
    private Integer totalItemCount;

    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        context = parent.getContext();
        if (viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_loadmore, parent, false));
        } else {
            return new FuguTagging(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.list_item_people, parent, false));
        }
    }

    public PeopleAdapter(List<User> peopleData, PeopleClickListener peopleClickListener) {
        this.peopleData = peopleData;
        this.peopleClickListener = peopleClickListener;
    }

    @Override
    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof FuguTagging) {
            final FuguTagging holder1 = (FuguTagging) holder;
            holder1.tvPersonName.setText(peopleData.get(position).getFullName());
            holder1.tvPersonPhone.setText(peopleData.get(position).getPhoneNumber());
            holder1.tvPersonEmail.setText(peopleData.get(position).getEmail());
            if (MyApplication.getInstance().getUserData().getBusinessProperty().getEnableAgentCustomerChat().equalsIgnoreCase("1")) {
                holder1.tvNewChat.setVisibility(View.VISIBLE);
            } else {
                holder1.tvNewChat.setVisibility(View.GONE);
            }

//        holder1.llMain.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                activity.selectedPeopleUserId = null;
//                activity.selectedPeopleUserId = peopleData.get(position).getUserId().toString();
//                activity.getHomeFragment().apiGetConversation(peopleData.get(position).getUserId().toString(), String.valueOf(MyApplication.getInstance().getUserData().getUserId()), activity.getStatusFilter(), activity.getTypeFilter(), activity.getLabelsFilter(), 0, false, true, true);
//                activity.selectedPeople = null;
//                activity.selectedPeople = peopleData.get(position).getEmail();
//                activity.resetPeople();
//                activity.drawer.closeDrawer(Gravity.RIGHT);
//            }
//        });
//        holder1.tvNewChat.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//
//                GetConversationResponse.Conversation conversation = new GetConversationResponse.Conversation();
//                conversation.setChannelId(-5);
//                conversation.setChannelName("dummyChannelName");
//                conversation.setStatus(-2);
//                conversation.setAgentId(-2);
//                conversation.setUserId(peopleData.get(position).getUserId());
//                conversation.setLabel(peopleData.get(position).getFullName());
//
//                ((MainActivity) activity).getRlFilterToolTip().setVisibility(View.GONE);
//                conversation.setUnreadCount(0);
//                ((MainActivity) activity).getHomeFragment().getConversationFragment().setConversationChatCount(conversation);
//                Intent chatIntent = new Intent(activity, FuguChatActivity.class);
//                chatIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, GetConversationResponse.Conversation.class));
//                activity.startActivityForResult(chatIntent, 100);
//                //MyApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.CHAT_CLICKED, "conversation_clicked");
//
//                //activity.createConversation(peopleData.get(position).getUserId());
//            }
//        });
        } else if (holder instanceof LoadMoreHolder) {
            final LoadMoreHolder holder2 = (LoadMoreHolder) holder;
            holder2.loadmoreBinding.progressWheel.setVisibility(View.GONE);
            holder2.loadmoreBinding.tvLoadmore.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public int getItemCount() {
        if (peopleData == null || peopleData.size() == 0) {
            return 0;
        } else {
            if (totalItemCount > peopleData.size()) {
                return peopleData.size() + 1;
            } else {
                return peopleData.size();
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (isPositionFooter(position)) {
                return VIEW_TYPE_LOADING;
            }
            return VIEW_TYPE;
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    private boolean isPositionFooter(int position) {
        return position == peopleData.size();
    }

    public void setData(ArrayList<User> peopleData, int totalItemCount) {
        this.peopleData = peopleData;
        this.totalItemCount = totalItemCount;
        notifyDataSetChanged();
    }

    class FuguTagging extends RecyclerView.ViewHolder {
        private TextView tvNewChat, tvPersonEmail, tvPersonPhone, tvPersonName;
        private LinearLayout llMain;

        public FuguTagging(View itemView) {
            super(itemView);
            tvNewChat = itemView.findViewById(R.id.tvNewChat);
            tvPersonEmail = itemView.findViewById(R.id.tvPersonEmail);
            tvPersonPhone = itemView.findViewById(R.id.tvPersonPhone);
            tvPersonName = itemView.findViewById(R.id.tvPersonName);
            llMain = itemView.findViewById(R.id.llMain);

            llMain.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    peopleClickListener.onItemClick(peopleData.get(getAdapterPosition()));
                }
            });

            tvNewChat.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-5);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setUserId(peopleData.get(getAdapterPosition()).getUserId());
                    conversation.setLabel(peopleData.get(getAdapterPosition()).getFullName());

                    conversation.setUnreadCount(0);

                    peopleClickListener.onNewChatClick(conversation);
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        private LayoutLoadmoreBinding loadmoreBinding;

        public LoadMoreHolder(View itemView) {
            super(itemView);
            loadmoreBinding = DataBindingUtil.bind(itemView);
            loadmoreBinding.rlMainLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
//                    loadmoreBinding.progressWheel.setVisibility(View.VISIBLE);
//                    loadmoreBinding.tvLoadmore.setVisibility(View.GONE);
                    peopleClickListener.onLoadMoreClick();
                }
            });
        }
    }

    public interface PeopleClickListener {
        void onItemClick(User datum);

        void onNewChatClick(Conversation conversation);

        void onLoadMoreClick();
    }
}

