package com.hippoagent.adapters;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.HippoPayment;
import com.hippoagent.model.Message;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-11-06.
 *
 * @author gurmail
 */
public class PaymentAdapter extends RecyclerView.Adapter<PaymentAdapter.ViewHolder> {

    private ArrayList<HippoPayment> hippoPayments;
    private Message message;
    private String selectedId;

    public PaymentAdapter(Message message, ArrayList<HippoPayment> hippoPayments, String selectedId) {
        this.message = message;
        this.hippoPayments = hippoPayments;
        this.selectedId = selectedId;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.hippo_customer_payment_item, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.line.setVisibility(View.VISIBLE);
        if(hippoPayments.size() == 1) {
            viewHolder.radioBtn.setVisibility(View.GONE);
        }

        viewHolder.radioBtn.setVisibility(View.GONE);

        viewHolder.title.setText(hippoPayments.get(i).getTitle());
        if(!TextUtils.isEmpty(hippoPayments.get(i).getDescription())) {
            viewHolder.description.setVisibility(View.VISIBLE);
            viewHolder.description.setText(hippoPayments.get(i).getDescription());
        } else {
            viewHolder.description.setVisibility(View.GONE);
        }

        String symbols = hippoPayments.get(i).getCurrencySymbol();
        viewHolder.amount.setText(symbols +""+hippoPayments.get(i).getAmount());

        viewHolder.paid.setVisibility(View.GONE);
        if(!TextUtils.isEmpty(selectedId) && hippoPayments.get(i).getId().equalsIgnoreCase(selectedId)) {
            viewHolder.paid.setVisibility(View.VISIBLE);
        }

    }

    @Override
    public int getItemCount() {
//        if(hippoPayments.size()>1)
//            return 1;
        return hippoPayments.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView title;
        private TextView description;
        private TextView amount;
        private View line;
        private RelativeLayout paymentLayout;
        private RadioButton radioBtn;
        private TextView paid;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            paymentLayout = itemView.findViewById(R.id.paymentLayout);
            title = itemView.findViewById(R.id.title);
            description = itemView.findViewById(R.id.description);
            amount = itemView.findViewById(R.id.amount);
            line = itemView.findViewById(R.id.line);
            radioBtn = itemView.findViewById(R.id.radioBtn);
            paid = itemView.findViewById(R.id.paid);

            /*paymentLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if(listener != null) {
                            listener.onPaymentViewClicked(message, hippoPayments.get(getAdapterPosition()),
                                    getAdapterPosition(), hippoPayments.get(getAdapterPosition()).getPaymentUrl());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });*/
        }
    }
}
